/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.service.impl;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.chain.model.po.CacheDatas;
import io.nuls.chain.service.CacheDataService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.service.CmTransferService;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Service;
import java.util.List;

@Service
public class CmTransferServiceImpl
implements CmTransferService {
    @Autowired
    private CacheDataService cacheDataService;
    @Autowired
    private ChainService chainService;

    @Override
    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        try {
            long commitHeight = blockHeader.getHeight();
            CacheDatas moduleTxDatas = this.cacheDataService.getCacheDatas(commitHeight - 1L);
            this.chainService.rpcBlockChainRollback(txs, blockHeader.getTime());
            if (null == moduleTxDatas) {
                LoggerUtil.logger().info("chain module height ={} bak datas is null,maybe had rolled", new Object[]{commitHeight});
                return true;
            }
            this.cacheDataService.rollBlockTxs(chainId, commitHeight);
            return true;
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean rollbackV3(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        try {
            long commitHeight = blockHeader.getHeight();
            CacheDatas moduleTxDatas = this.cacheDataService.getCacheDatas(commitHeight - 1L);
            this.chainService.rpcBlockChainRollbackV4(txs, blockHeader.getTime());
            if (null == moduleTxDatas) {
                LoggerUtil.logger().info("chain module height ={} bak datas is null,maybe had rolled", new Object[]{commitHeight});
                return true;
            }
            this.cacheDataService.rollBlockTxs(chainId, commitHeight);
            return true;
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            throw new RuntimeException(e);
        }
    }
}

