/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.service.impl;

import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.dto.ChainAssetTotalCirculate;
import io.nuls.chain.model.po.ChainAsset;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.MessageService;
import io.nuls.chain.storage.ChainAssetStorage;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.BigIntegerUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class MessageServiceImpl
implements MessageService {
    @Autowired
    AssetService assetService;
    @Autowired
    private ChainAssetStorage chainAssetStorage;
    Map<String, Map<Integer, List<ChainAssetTotalCirculate>>> chainAssetMap = new HashMap<String, Map<Integer, List<ChainAssetTotalCirculate>>>();

    @Override
    public boolean initChainIssuingAssets(int chainId) {
        this.chainAssetMap.remove(String.valueOf(chainId));
        this.chainAssetMap.put(String.valueOf(chainId), new HashMap());
        return true;
    }

    @Override
    public void recChainIssuingAssets(int chainId, List<ChainAssetTotalCirculate> chainAssetTotalCirculates) {
        Map<Integer, List<ChainAssetTotalCirculate>> assetMap = this.chainAssetMap.get(String.valueOf(chainId));
        if (null != assetMap) {
            for (ChainAssetTotalCirculate chainAssetTotalCirculate : chainAssetTotalCirculates) {
                List<ChainAssetTotalCirculate> list = assetMap.get(chainAssetTotalCirculate.getAssetId());
                if (null == list) {
                    list = new ArrayList<ChainAssetTotalCirculate>();
                }
                list.add(chainAssetTotalCirculate);
                assetMap.put(chainAssetTotalCirculate.getAssetId(), list);
            }
        }
    }

    @Override
    public void dealChainIssuingAssets(int chainId) {
        Map<Integer, List<ChainAssetTotalCirculate>> assetMap = this.chainAssetMap.get(String.valueOf(chainId));
        if (null != assetMap) {
            for (Map.Entry<Integer, List<ChainAssetTotalCirculate>> entry : assetMap.entrySet()) {
                BigInteger totalAmount = BigInteger.ZERO;
                List<ChainAssetTotalCirculate> assetTotalCirculates = entry.getValue();
                for (ChainAssetTotalCirculate chainAssetTotalCirculate : assetTotalCirculates) {
                    totalAmount = totalAmount.add(chainAssetTotalCirculate.getFreeze()).add(chainAssetTotalCirculate.getAvailableAmount());
                }
                if (assetTotalCirculates.size() <= 0) continue;
                String key = CmRuntimeInfo.getAssetKey(chainId, entry.getKey());
                if (BigIntegerUtils.isGreaterThan((BigInteger)(totalAmount = new BigDecimal(totalAmount.toString()).divide(new BigDecimal(assetTotalCirculates.size()), RoundingMode.HALF_DOWN).setScale(0).toBigInteger()), (BigInteger)BigInteger.ZERO)) {
                    String chainAssetKey = CmRuntimeInfo.getChainAssetKey(chainId, key);
                    try {
                        ChainAsset chainAsset = this.chainAssetStorage.load(chainAssetKey);
                        if (null != chainAsset) {
                            totalAmount = totalAmount.add(chainAsset.getOutNumber()).subtract(chainAsset.getInNumber());
                        }
                        this.assetService.saveMsgChainCirculateAmount(key, totalAmount);
                        LoggerUtil.logger().info("Friendly Chain Asset Update Completed:key={},amount={}", new Object[]{key, totalAmount});
                    }
                    catch (Exception e) {
                        LoggerUtil.logger().error(e);
                    }
                    continue;
                }
                LoggerUtil.logger().info("Friendly link asset update failed:key={},amount={}", new Object[]{key, totalAmount});
            }
        }
    }

    @Override
    public void dealMainChainIssuingAssets(List<ChainAssetTotalCirculate> chainAssetTotalCirculates) {
        for (ChainAssetTotalCirculate chainAssetTotalCirculate : chainAssetTotalCirculates) {
            String key = CmRuntimeInfo.getAssetKey(chainAssetTotalCirculate.getChainId(), chainAssetTotalCirculate.getAssetId());
            BigInteger totalAmount = chainAssetTotalCirculate.getAvailableAmount().add(chainAssetTotalCirculate.getFreeze());
            if (BigIntegerUtils.isGreaterThan((BigInteger)totalAmount, (BigInteger)BigInteger.ZERO)) {
                String chainAssetKey = CmRuntimeInfo.getChainAssetKey(chainAssetTotalCirculate.getChainId(), key);
                try {
                    ChainAsset chainAsset = this.chainAssetStorage.load(chainAssetKey);
                    if (null != chainAsset) {
                        totalAmount = totalAmount.add(chainAsset.getOutNumber()).subtract(chainAsset.getInNumber());
                    }
                    this.assetService.saveMsgChainCirculateAmount(key, totalAmount);
                    LoggerUtil.logger().info("Main network asset update completed:key={},amount={}", new Object[]{key, totalAmount});
                }
                catch (Exception e) {
                    LoggerUtil.logger().error(e);
                }
                continue;
            }
            LoggerUtil.logger().info("Main network asset update failed:key={},amount={}", new Object[]{key, totalAmount});
        }
    }
}

