/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.storage.impl;

import io.nuls.chain.model.po.BlockHeight;
import io.nuls.chain.storage.BlockHeightStorage;
import io.nuls.chain.storage.InitDB;
import io.nuls.chain.storage.impl.BaseStorage;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.service.RocksDBService;

@Component
public class BlockHeightStorageImpl
extends BaseStorage
implements BlockHeightStorage,
InitDB,
InitializingBean {
    private final String TBL = "txs_block_height";

    public void afterPropertiesSet() {
    }

    @Override
    public BlockHeight getBlockHeight(int chainId) {
        byte[] stream = RocksDBService.get((String)"txs_block_height", (byte[])ByteUtils.intToBytes((int)chainId));
        if (stream == null) {
            return null;
        }
        try {
            BlockHeight blockHeight = new BlockHeight();
            blockHeight.parse(stream, 0);
            return blockHeight;
        }
        catch (Exception e) {
            LoggerUtil.logger().error("getBlockHeight serialize error.", e);
            return null;
        }
    }

    @Override
    public void saveOrUpdateBlockHeight(int chainId, BlockHeight blockHeight) throws Exception {
        LoggerUtil.logger().info("chainId = {},blockHeight={} saveOrUpdateBlockHeight", new Object[]{chainId, blockHeight});
        RocksDBService.put((String)"txs_block_height", (byte[])ByteUtils.intToBytes((int)chainId), (byte[])blockHeight.serialize());
    }

    @Override
    public void initTableName() throws NulsException {
        super.initTableName("txs_block_height");
    }
}

