/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.common;

import io.nuls.common.NCUtils;
import io.nuls.core.model.StringUtils;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ConfigBean {
    private int chainId;
    private int assetId;
    private long blockMaxSize;
    private long resetTime;
    private byte chainSwtichThreshold;
    private int cacheSize;
    private int heightRange;
    private int maxRollback;
    private byte consistencyNodePercent;
    private byte minNodeAmount;
    private byte downloadNumber;
    private int extendMaxSize;
    private int validBlockInterval;
    private byte smallBlockCache;
    private byte orphanChainMaxAge;
    private String logLevel;
    private int singleDownloadTimeout;
    private int waitNetworkInterval;
    private String genesisBlockPath;
    private long cachedBlockSizeLimit;
    private short interval;
    private byte effectiveRatioMinimum;
    private short continuousIntervalCountMinimum;
    private int minNodes;
    private int maxOutAmount;
    private int maxInAmount;
    private int sendHeight;
    private int byzantineRatio;
    private int minSignature;
    private String verifiers;
    private int mainByzantineRatio;
    private int maxSignatureCount;
    private Set<String> verifierSet = new HashSet<String>();
    private long packingInterval;
    private long redPublishLockTime;
    private long stopAgentLockTime;
    private byte commissionRateMin;
    private byte commissionRateMax;
    private BigInteger depositMin;
    private BigInteger depositMax;
    private BigInteger commissionMin;
    private BigInteger commissionMax;
    private BigInteger commissionMaxV23;
    private BigInteger entrusterDepositMin;
    private String seedNodes;
    private String password;
    private BigInteger blockReward;
    private int agentAssetId;
    private int agentChainId;
    private int awardAssetId;
    private BigInteger totalInflationAmount;
    private BigInteger inflationAmount;
    private long initTime;
    private double deflationRatio;
    private long deflationTimeInterval;
    private long maxViewGas;
    private long txMaxSize;
    private int moduleVerifyPercent;
    private int packageRpcReserveTime;
    private long txUnverifiedQueueSize;
    private int orphanTtl;
    private String feeAssets;
    private String feeUnit;
    private String feeCoefficient;
    private Map<String, Long> feeUnitMap;
    private Map<String, Double> feeCoeffMap;

    private void initFeeUnitMap() {
        int i;
        String[] vals;
        String[] keys;
        if (StringUtils.isNotBlank((String)this.feeAssets) && StringUtils.isNotBlank((String)this.feeUnit) && this.feeUnitMap == null) {
            this.feeUnitMap = new LinkedHashMap<String, Long>();
            keys = this.feeAssets.split(",");
            vals = this.feeUnit.split(",");
            for (i = 0; i < keys.length; ++i) {
                this.feeUnitMap.put(keys[i], Long.parseLong(vals[i]));
            }
        }
        if (StringUtils.isNotBlank((String)this.feeAssets) && StringUtils.isNotBlank((String)this.feeCoefficient) && this.feeCoeffMap == null) {
            this.feeCoeffMap = new LinkedHashMap<String, Double>();
            keys = this.feeAssets.split(",");
            vals = this.feeCoefficient.split(",");
            for (i = 0; i < keys.length; ++i) {
                this.feeCoeffMap.put(keys[i], Double.parseDouble(vals[i]));
            }
        }
    }

    public Long getFeeUnit(int chainId, int assetId) {
        return this.getFeeUnit(NCUtils.getTokenId(chainId, assetId));
    }

    public Long getFeeUnit(String tokenId) {
        if (null == this.feeUnitMap) {
            this.initFeeUnitMap();
        }
        return this.feeUnitMap.get(tokenId);
    }

    public Double getFeeCoefficient(int chainId, int assetId) {
        return this.getFeeCoefficient(NCUtils.getTokenId(chainId, assetId));
    }

    public Double getFeeCoefficient(String tokenId) {
        if (null == this.feeCoeffMap) {
            this.initFeeUnitMap();
        }
        return this.feeCoeffMap.get(tokenId);
    }

    public void setFeeAssets(String feeAssets) {
        this.feeAssets = feeAssets;
    }

    public Set<String> getFeeAssetsSet() {
        if (null == this.feeUnitMap) {
            this.initFeeUnitMap();
        }
        return this.feeUnitMap.keySet();
    }

    public void setFeeUnit(String feeUnit) {
        this.feeUnit = feeUnit;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public long getBlockMaxSize() {
        return this.blockMaxSize;
    }

    public void setBlockMaxSize(long blockMaxSize) {
        this.blockMaxSize = blockMaxSize;
    }

    public long getResetTime() {
        return this.resetTime;
    }

    public void setResetTime(long resetTime) {
        this.resetTime = resetTime;
    }

    public byte getChainSwtichThreshold() {
        return this.chainSwtichThreshold;
    }

    public void setChainSwtichThreshold(byte chainSwtichThreshold) {
        this.chainSwtichThreshold = chainSwtichThreshold;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getHeightRange() {
        return this.heightRange;
    }

    public void setHeightRange(int heightRange) {
        this.heightRange = heightRange;
    }

    public int getMaxRollback() {
        return this.maxRollback;
    }

    public void setMaxRollback(int maxRollback) {
        this.maxRollback = maxRollback;
    }

    public byte getConsistencyNodePercent() {
        return this.consistencyNodePercent;
    }

    public void setConsistencyNodePercent(byte consistencyNodePercent) {
        this.consistencyNodePercent = consistencyNodePercent;
    }

    public byte getMinNodeAmount() {
        return this.minNodeAmount;
    }

    public void setMinNodeAmount(byte minNodeAmount) {
        this.minNodeAmount = minNodeAmount;
    }

    public byte getDownloadNumber() {
        return this.downloadNumber;
    }

    public void setDownloadNumber(byte downloadNumber) {
        this.downloadNumber = downloadNumber;
    }

    public int getExtendMaxSize() {
        return this.extendMaxSize;
    }

    public void setExtendMaxSize(int extendMaxSize) {
        this.extendMaxSize = extendMaxSize;
    }

    public int getValidBlockInterval() {
        return this.validBlockInterval;
    }

    public void setValidBlockInterval(int validBlockInterval) {
        this.validBlockInterval = validBlockInterval;
    }

    public byte getSmallBlockCache() {
        return this.smallBlockCache;
    }

    public void setSmallBlockCache(byte smallBlockCache) {
        this.smallBlockCache = smallBlockCache;
    }

    public byte getOrphanChainMaxAge() {
        return this.orphanChainMaxAge;
    }

    public void setOrphanChainMaxAge(byte orphanChainMaxAge) {
        this.orphanChainMaxAge = orphanChainMaxAge;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public int getSingleDownloadTimeout() {
        return this.singleDownloadTimeout;
    }

    public void setSingleDownloadTimeout(int singleDownloadTimeout) {
        this.singleDownloadTimeout = singleDownloadTimeout;
    }

    public int getWaitNetworkInterval() {
        return this.waitNetworkInterval;
    }

    public void setWaitNetworkInterval(int waitNetworkInterval) {
        this.waitNetworkInterval = waitNetworkInterval;
    }

    public String getGenesisBlockPath() {
        return this.genesisBlockPath;
    }

    public void setGenesisBlockPath(String genesisBlockPath) {
        this.genesisBlockPath = genesisBlockPath;
    }

    public long getCachedBlockSizeLimit() {
        return this.cachedBlockSizeLimit;
    }

    public void setCachedBlockSizeLimit(long cachedBlockSizeLimit) {
        this.cachedBlockSizeLimit = cachedBlockSizeLimit;
    }

    public short getInterval() {
        return this.interval;
    }

    public void setInterval(short interval) {
        this.interval = interval;
    }

    public byte getEffectiveRatioMinimum() {
        return this.effectiveRatioMinimum;
    }

    public void setEffectiveRatioMinimum(byte effectiveRatioMinimum) {
        this.effectiveRatioMinimum = effectiveRatioMinimum;
    }

    public short getContinuousIntervalCountMinimum() {
        return this.continuousIntervalCountMinimum;
    }

    public void setContinuousIntervalCountMinimum(short continuousIntervalCountMinimum) {
        this.continuousIntervalCountMinimum = continuousIntervalCountMinimum;
    }

    public int getMinNodes() {
        return this.minNodes;
    }

    public void setMinNodes(int minNodes) {
        this.minNodes = minNodes;
    }

    public int getMaxOutAmount() {
        return this.maxOutAmount;
    }

    public void setMaxOutAmount(int maxOutAmount) {
        this.maxOutAmount = maxOutAmount;
    }

    public int getMaxInAmount() {
        return this.maxInAmount;
    }

    public void setMaxInAmount(int maxInAmount) {
        this.maxInAmount = maxInAmount;
    }

    public int getSendHeight() {
        return this.sendHeight;
    }

    public void setSendHeight(int sendHeight) {
        this.sendHeight = sendHeight;
    }

    public int getByzantineRatio() {
        return this.byzantineRatio;
    }

    public void setByzantineRatio(int byzantineRatio) {
        this.byzantineRatio = byzantineRatio;
    }

    public int getMinSignature() {
        return this.minSignature;
    }

    public void setMinSignature(int minSignature) {
        this.minSignature = minSignature;
    }

    public String getVerifiers() {
        return this.verifiers;
    }

    public void setVerifiers(String verifiers) {
        this.verifiers = verifiers;
    }

    public int getMainByzantineRatio() {
        return this.mainByzantineRatio;
    }

    public void setMainByzantineRatio(int mainByzantineRatio) {
        this.mainByzantineRatio = mainByzantineRatio;
    }

    public int getMaxSignatureCount() {
        return this.maxSignatureCount;
    }

    public void setMaxSignatureCount(int maxSignatureCount) {
        this.maxSignatureCount = maxSignatureCount;
    }

    public Set<String> getVerifierSet() {
        return this.verifierSet;
    }

    public void setVerifierSet(Set<String> verifierSet) {
        this.verifierSet = verifierSet;
    }

    public long getPackingInterval() {
        return this.packingInterval;
    }

    public void setPackingInterval(long packingInterval) {
        this.packingInterval = packingInterval;
    }

    public long getRedPublishLockTime() {
        return this.redPublishLockTime;
    }

    public void setRedPublishLockTime(long redPublishLockTime) {
        this.redPublishLockTime = redPublishLockTime;
    }

    public long getStopAgentLockTime() {
        return this.stopAgentLockTime;
    }

    public void setStopAgentLockTime(long stopAgentLockTime) {
        this.stopAgentLockTime = stopAgentLockTime;
    }

    public byte getCommissionRateMin() {
        return this.commissionRateMin;
    }

    public void setCommissionRateMin(byte commissionRateMin) {
        this.commissionRateMin = commissionRateMin;
    }

    public byte getCommissionRateMax() {
        return this.commissionRateMax;
    }

    public void setCommissionRateMax(byte commissionRateMax) {
        this.commissionRateMax = commissionRateMax;
    }

    public BigInteger getDepositMin() {
        return this.depositMin;
    }

    public void setDepositMin(BigInteger depositMin) {
        this.depositMin = depositMin;
    }

    public BigInteger getDepositMax() {
        return this.depositMax;
    }

    public void setDepositMax(BigInteger depositMax) {
        this.depositMax = depositMax;
    }

    public BigInteger getCommissionMin() {
        return this.commissionMin;
    }

    public void setCommissionMin(BigInteger commissionMin) {
        this.commissionMin = commissionMin;
    }

    public BigInteger getCommissionMax() {
        return this.commissionMax;
    }

    public void setCommissionMax(BigInteger commissionMax) {
        this.commissionMax = commissionMax;
    }

    public BigInteger getCommissionMaxV23() {
        return this.commissionMaxV23;
    }

    public void setCommissionMaxV23(BigInteger commissionMaxV23) {
        this.commissionMaxV23 = commissionMaxV23;
    }

    public BigInteger getEntrusterDepositMin() {
        return this.entrusterDepositMin;
    }

    public void setEntrusterDepositMin(BigInteger entrusterDepositMin) {
        this.entrusterDepositMin = entrusterDepositMin;
    }

    public String getSeedNodes() {
        return this.seedNodes;
    }

    public void setSeedNodes(String seedNodes) {
        this.seedNodes = seedNodes;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BigInteger getBlockReward() {
        return this.blockReward;
    }

    public void setBlockReward(BigInteger blockReward) {
        this.blockReward = blockReward;
    }

    public int getAgentAssetId() {
        return this.agentAssetId;
    }

    public void setAgentAssetId(int agentAssetId) {
        this.agentAssetId = agentAssetId;
    }

    public int getAgentChainId() {
        return this.agentChainId;
    }

    public void setAgentChainId(int agentChainId) {
        this.agentChainId = agentChainId;
    }

    public int getAwardAssetId() {
        return this.awardAssetId;
    }

    public void setAwardAssetId(int awardAssetId) {
        this.awardAssetId = awardAssetId;
    }

    public BigInteger getTotalInflationAmount() {
        return this.totalInflationAmount;
    }

    public void setTotalInflationAmount(BigInteger totalInflationAmount) {
        this.totalInflationAmount = totalInflationAmount;
    }

    public BigInteger getInflationAmount() {
        return this.inflationAmount;
    }

    public void setInflationAmount(BigInteger inflationAmount) {
        this.inflationAmount = inflationAmount;
    }

    public long getInitTime() {
        return this.initTime;
    }

    public void setInitTime(long initTime) {
        this.initTime = initTime;
    }

    public double getDeflationRatio() {
        return this.deflationRatio;
    }

    public void setDeflationRatio(double deflationRatio) {
        this.deflationRatio = deflationRatio;
    }

    public long getDeflationTimeInterval() {
        return this.deflationTimeInterval;
    }

    public void setDeflationTimeInterval(long deflationTimeInterval) {
        this.deflationTimeInterval = deflationTimeInterval;
    }

    public long getMaxViewGas() {
        return this.maxViewGas;
    }

    public void setMaxViewGas(long maxViewGas) {
        this.maxViewGas = maxViewGas;
    }

    public long getTxMaxSize() {
        return this.txMaxSize;
    }

    public void setTxMaxSize(long txMaxSize) {
        this.txMaxSize = txMaxSize;
    }

    public int getModuleVerifyPercent() {
        return this.moduleVerifyPercent;
    }

    public void setModuleVerifyPercent(int moduleVerifyPercent) {
        this.moduleVerifyPercent = moduleVerifyPercent;
    }

    public int getPackageRpcReserveTime() {
        return this.packageRpcReserveTime;
    }

    public void setPackageRpcReserveTime(int packageRpcReserveTime) {
        this.packageRpcReserveTime = packageRpcReserveTime;
    }

    public long getTxUnverifiedQueueSize() {
        return this.txUnverifiedQueueSize;
    }

    public void setTxUnverifiedQueueSize(long txUnverifiedQueueSize) {
        this.txUnverifiedQueueSize = txUnverifiedQueueSize;
    }

    public int getOrphanTtl() {
        return this.orphanTtl;
    }

    public void setOrphanTtl(int orphanTtl) {
        this.orphanTtl = orphanTtl;
    }
}

