/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.common;

import io.nuls.base.protocol.Protocol;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.protocol.ProtocolLoader;
import io.nuls.base.protocol.RegisterHelper;
import io.nuls.common.CommonContext;
import io.nuls.common.ConfigBean;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.transaction.utils.LoggerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@Component
public class ConfigManager {
    @Autowired
    private NulsCoresConfig config;

    public void init() throws Exception {
        Map<Integer, ConfigBean> configMap = this.configChain();
        if (configMap == null || configMap.size() == 0) {
            return;
        }
        CommonContext.CONFIG_BEAN_MAP.clear();
        CommonContext.CONFIG_BEAN_MAP.putAll(configMap);
    }

    public void registerProtocol() throws Exception {
        Map<Integer, ConfigBean> configMap = CommonContext.CONFIG_BEAN_MAP;
        if (configMap == null || configMap.size() == 0) {
            return;
        }
        for (Map.Entry<Integer, ConfigBean> entry : configMap.entrySet()) {
            int chainId = entry.getKey();
            ProtocolLoader.load((int)chainId);
            boolean regSuccess = RegisterHelper.registerTx((int)chainId, (Protocol)ProtocolGroupManager.getCurrentProtocol((int)chainId));
            if (!regSuccess) {
                LoggerUtil.LOG.error("RegisterHelper.registerTx fail..");
                System.exit(-1);
            }
            LoggerUtil.LOG.info("regTxRpc complete.....");
            regSuccess = RegisterHelper.registerProtocol((int)chainId);
            if (!regSuccess) {
                LoggerUtil.LOG.error("RegisterHelper.registerProtocol fail..");
                System.exit(-1);
            }
            LoggerUtil.LOG.info("register protocol ...");
            RegisterHelper.registerMsg((Protocol)ProtocolGroupManager.getOneProtocol());
            LoggerUtil.LOG.info("register msg ...");
        }
    }

    private Map<Integer, ConfigBean> configChain() {
        try {
            HashMap<Integer, ConfigBean> configMap = new HashMap<Integer, ConfigBean>();
            if (configMap.isEmpty()) {
                NulsCoresConfig configBean = this.config;
                if (this.config.getVerifiers() != null) {
                    configBean.setVerifierSet(new HashSet<String>(Arrays.asList(this.config.getVerifiers().split(","))));
                } else {
                    configBean.setVerifierSet(new HashSet<String>());
                }
                configMap.put(((ConfigBean)configBean).getChainId(), configBean);
            }
            return configMap;
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
            return null;
        }
    }
}

