/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus;

import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.utils.enumeration.ConsensusStatus;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.util.AddressPrefixDatas;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Component
public class ConsensusBootStrap
implements INulsCoresBootstrap {
    @Autowired
    private NulsCoresConfig consensusConfig;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AddressPrefixDatas addressPrefixDatas;

    @Override
    public int order() {
        return 4;
    }

    @Override
    public void mainFunction(String[] args) {
        this.init();
    }

    public void init() {
        try {
            this.initSys();
            this.initDB();
            this.chainManager.initChain();
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    @Override
    public Module moduleInfo() {
        return new Module(ModuleE.CS.abbr, "1.0");
    }

    private boolean doStart() {
        try {
            this.chainManager.runChain();
            return true;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public void onDependenciesReady() {
        try {
            this.doStart();
            this.chainManager.registerContractTx();
            for (Chain chain : this.chainManager.getChainMap().values()) {
                CallMethodUtils.sendState(chain, chain.isPacker());
                chain.setConsensusStatus(ConsensusStatus.RUNNING);
            }
            Log.debug((String)"cs onDependenciesReady");
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    private void initSys() throws Exception {
        System.setProperty("file.encoding", StandardCharsets.UTF_8.name());
        Field charset = Charset.class.getDeclaredField("defaultCharset");
        charset.setAccessible(true);
        charset.set(null, StandardCharsets.UTF_8);
    }

    private void initDB() throws Exception {
        RocksDBService.init((String)(this.consensusConfig.getDataPath() + File.separator + ModuleE.CS.name));
        RocksDBService.createTable((String)"config");
        if (this.consensusConfig.getMainChainId() != 1) {
            return;
        }
    }
}

