/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.economic.nuls.util.manager;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinTo;
import io.nuls.consensus.economic.nuls.model.bo.AgentInfo;
import io.nuls.consensus.economic.nuls.model.bo.ConsensusConfigInfo;
import io.nuls.consensus.economic.nuls.model.bo.DepositInfo;
import io.nuls.consensus.economic.nuls.model.bo.InflationInfo;
import io.nuls.consensus.economic.nuls.model.bo.RoundInfo;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ArraysTool;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.DoubleUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class EconomicManager {
    public static Map<Integer, ConsensusConfigInfo> configMap = new HashMap<Integer, ConsensusConfigInfo>();
    private static InflationInfo lastVisitInflationInfo = null;

    public static List<CoinTo> getRewardCoin(AgentInfo agentInfo, RoundInfo roundInfo, ConsensusConfigInfo consensusConfig, long unlockHeight, Map<String, BigInteger> awardAssetMap) throws NulsException {
        ArrayList<CoinTo> rewardList = new ArrayList<CoinTo>();
        if (BigIntegerUtils.isEqual((BigInteger)agentInfo.getDeposit(), (BigInteger)BigInteger.ZERO)) {
            if (awardAssetMap == null || awardAssetMap.isEmpty()) {
                return rewardList;
            }
            for (Map.Entry<String, BigInteger> rewardEntry : awardAssetMap.entrySet()) {
                String[] assetInfo = rewardEntry.getKey().split("_");
                CoinTo agentReword = new CoinTo(agentInfo.getRewardAddress(), Integer.valueOf(assetInfo[0]).intValue(), Integer.valueOf(assetInfo[1]).intValue(), rewardEntry.getValue(), unlockHeight);
                rewardList.add(agentReword);
            }
            return rewardList;
        }
        if (consensusConfig.getTotalInflationAmount().equals(BigInteger.ZERO) || consensusConfig.getInflationAmount().equals(BigInteger.ZERO)) {
            return rewardList;
        }
        BigDecimal totalAll = EconomicManager.calcRoundConsensusReward(roundInfo, consensusConfig).setScale(2, 1);
        Log.info((String)"Number of blocks produced in this round{}The total amount of rewards in this round\uff1a{}", (Object[])new Object[]{roundInfo.getMemberCount(), totalAll});
        BigInteger selfAllDeposit = agentInfo.getDeposit().add(agentInfo.getTotalDeposit());
        BigDecimal agentWeight = DoubleUtils.mul((BigDecimal)new BigDecimal(selfAllDeposit), (double)agentInfo.getCreditVal());
        if (roundInfo.getTotalWeight() > 0.0 && agentWeight.doubleValue() > 0.0) {
            BigInteger consensusReword = DoubleUtils.mul((BigDecimal)totalAll, (BigDecimal)DoubleUtils.div((BigDecimal)agentWeight, (double)roundInfo.getTotalWeight())).toBigInteger();
            String assetKey = consensusConfig.getChainId() + "_" + consensusConfig.getAwardAssetId();
            if (awardAssetMap.keySet().contains(assetKey)) {
                awardAssetMap.put(assetKey, awardAssetMap.get(assetKey).add(consensusReword));
            } else {
                awardAssetMap.put(assetKey, consensusReword);
            }
        }
        if (awardAssetMap == null || awardAssetMap.isEmpty()) {
            return rewardList;
        }
        Map<String, BigDecimal> depositWeightMap = EconomicManager.getDepositWeight(agentInfo, selfAllDeposit);
        for (Map.Entry<String, BigInteger> rewardEntry : awardAssetMap.entrySet()) {
            String[] assetInfo = rewardEntry.getKey().split("_");
            BigDecimal totalReward = new BigDecimal(rewardEntry.getValue());
            rewardList.addAll(EconomicManager.assembleCoinTo(depositWeightMap, Integer.valueOf(assetInfo[0]), Integer.valueOf(assetInfo[1]), totalReward, unlockHeight));
        }
        return rewardList;
    }

    private static Map<String, BigDecimal> getDepositWeight(AgentInfo agentInfo, BigInteger totalDeposit) {
        HashMap<String, BigDecimal> depositWeightMap = new HashMap<String, BigDecimal>(16);
        BigDecimal commissionRate = new BigDecimal(DoubleUtils.div((double)agentInfo.getCommissionRate(), (double)100.0, (int)2));
        if (commissionRate.compareTo(BigDecimal.ONE) >= 0) {
            depositWeightMap.put(AddressTool.getStringAddressByBytes((byte[])agentInfo.getRewardAddress()), BigDecimal.ONE);
            return depositWeightMap;
        }
        BigDecimal depositRate = new BigDecimal(1).subtract(commissionRate);
        BigInteger creatorDeposit = agentInfo.getDeposit();
        for (DepositInfo deposit : agentInfo.getDepositList()) {
            if (ArraysTool.arrayEquals((byte[])agentInfo.getRewardAddress(), (byte[])deposit.getAddress())) {
                creatorDeposit = creatorDeposit.add(deposit.getDeposit());
                continue;
            }
            String depositAddress = AddressTool.getStringAddressByBytes((byte[])deposit.getAddress());
            BigDecimal depositWeight = new BigDecimal(deposit.getDeposit()).divide(new BigDecimal(totalDeposit), 8, RoundingMode.HALF_DOWN).multiply(depositRate);
            if (depositWeightMap.keySet().contains(depositAddress)) {
                depositWeightMap.put(depositAddress, ((BigDecimal)depositWeightMap.get(depositAddress)).add(depositWeight));
                continue;
            }
            depositWeightMap.put(depositAddress, depositWeight);
        }
        BigDecimal creatorWeight = new BigDecimal(creatorDeposit).divide(new BigDecimal(totalDeposit), 8, RoundingMode.HALF_DOWN);
        BigDecimal creatorCommissionWeight = BigDecimal.ONE.subtract(creatorWeight).multiply(commissionRate);
        creatorWeight = creatorWeight.add(creatorCommissionWeight);
        depositWeightMap.put(AddressTool.getStringAddressByBytes((byte[])agentInfo.getRewardAddress()), creatorWeight);
        Log.debug((String)"Block weight allocation\uff1a{}", (Object[])new Object[]{((Object)depositWeightMap).toString()});
        return depositWeightMap;
    }

    private static List<CoinTo> assembleCoinTo(Map<String, BigDecimal> depositWeightMap, int assetChainId, int assetId, BigDecimal totalReward, long unlockHeight) {
        ArrayList<CoinTo> coinToList = new ArrayList<CoinTo>();
        for (Map.Entry<String, BigDecimal> entry : depositWeightMap.entrySet()) {
            String address = entry.getKey();
            BigDecimal depositWeight = entry.getValue();
            BigInteger amount = totalReward.multiply(depositWeight).toBigInteger();
            CoinTo coinTo = new CoinTo(AddressTool.getAddress((String)address), assetChainId, assetId, amount, unlockHeight);
            coinToList.add(coinTo);
        }
        return coinToList;
    }

    private static BigDecimal calcRoundConsensusReward(RoundInfo roundInfo, ConsensusConfigInfo consensusConfig) throws NulsException {
        long currentCount;
        BigDecimal totalAll = BigDecimal.ZERO;
        long roundStartTime = roundInfo.getRoundStartTime() + consensusConfig.getPackingInterval();
        long roundEndTime = roundInfo.getRoundEndTime();
        boolean changeInflationInfo = lastVisitInflationInfo == null || roundStartTime >= lastVisitInflationInfo.getEndTime() || roundEndTime <= lastVisitInflationInfo.getStartTime();
        InflationInfo inflationInfo = EconomicManager.getInflationInfo(consensusConfig, roundStartTime);
        if (roundStartTime >= inflationInfo.getStartTime() && roundEndTime <= inflationInfo.getEndTime()) {
            return DoubleUtils.mul((BigDecimal)new BigDecimal(roundInfo.getMemberCount()), (BigDecimal)new BigDecimal(inflationInfo.getAwardUnit()));
        }
        while (roundEndTime > inflationInfo.getEndTime()) {
            currentCount = (inflationInfo.getEndTime() - roundStartTime) / consensusConfig.getPackingInterval() + 1L;
            totalAll = totalAll.add(DoubleUtils.mul((BigDecimal)new BigDecimal(currentCount), (BigDecimal)new BigDecimal(inflationInfo.getAwardUnit())));
            Log.info((String)"The consensus reward for this round is{}The quantity is{}", (Object[])new Object[]{inflationInfo.getAwardUnit(), currentCount});
            inflationInfo = EconomicManager.getInflationInfo(consensusConfig, roundStartTime += currentCount * consensusConfig.getPackingInterval());
        }
        currentCount = (roundEndTime - roundStartTime) / consensusConfig.getPackingInterval() + 1L;
        Log.info((String)"The consensus reward for this round is{}The quantity is{}", (Object[])new Object[]{inflationInfo.getAwardUnit(), currentCount});
        totalAll = totalAll.add(DoubleUtils.mul((BigDecimal)new BigDecimal(currentCount), (BigDecimal)new BigDecimal(inflationInfo.getAwardUnit())));
        if (changeInflationInfo) {
            lastVisitInflationInfo = inflationInfo;
        }
        return totalAll;
    }

    private static InflationInfo getInflationInfo(ConsensusConfigInfo consensusConfig, long time) throws NulsException {
        if (lastVisitInflationInfo != null && time >= lastVisitInflationInfo.getStartTime() && time <= lastVisitInflationInfo.getEndTime()) {
            return lastVisitInflationInfo;
        }
        InflationInfo inflationInfo = new InflationInfo();
        long startTime = consensusConfig.getInitTime();
        long endTime = consensusConfig.getInitTime() + consensusConfig.getDeflationTimeInterval();
        if (time < startTime) {
            time = startTime;
            Log.info((String)"The current time is less than the start time of deflation\uff01");
        }
        if (time <= endTime) {
            inflationInfo.setStartTime(startTime);
            inflationInfo.setEndTime(endTime);
            inflationInfo.setInflationAmount(new BigDecimal(consensusConfig.getInflationAmount()));
            inflationInfo.setAwardUnit(EconomicManager.calcAwardUnit(consensusConfig, new BigDecimal(consensusConfig.getInflationAmount())));
        } else {
            long differentCount = (time - endTime) / consensusConfig.getDeflationTimeInterval();
            if ((time - endTime) % consensusConfig.getDeflationTimeInterval() != 0L) {
                ++differentCount;
            }
            long differentTime = consensusConfig.getDeflationTimeInterval() * differentCount;
            inflationInfo.setStartTime(startTime + differentTime);
            inflationInfo.setEndTime(endTime + differentTime);
            double ratio = DoubleUtils.div((double)consensusConfig.getDeflationRatio(), (double)100.0, (int)4);
            BigDecimal inflationAmount = DoubleUtils.mul((BigDecimal)new BigDecimal(consensusConfig.getInflationAmount()), (BigDecimal)BigDecimal.valueOf(Math.pow(ratio, differentCount)));
            inflationInfo.setInflationAmount(inflationAmount);
            inflationInfo.setAwardUnit(EconomicManager.calcAwardUnit(consensusConfig, inflationAmount));
        }
        Log.info((String)"Inflation changes, current inflation start time{}\uff1aThe end time of inflation at the current stage\uff1a{},Total inflation at the current stage\uff1a{}At the current stage, unit rewards for block production\uff1a{}", (Object[])new Object[]{inflationInfo.getStartTime(), inflationInfo.getEndTime(), inflationInfo.getInflationAmount(), inflationInfo.getAwardUnit()});
        return inflationInfo;
    }

    private static double calcAwardUnit(ConsensusConfigInfo consensusConfig, BigDecimal inflationAmount) {
        long blockCount = consensusConfig.getDeflationTimeInterval() / consensusConfig.getPackingInterval();
        return DoubleUtils.div((BigDecimal)inflationAmount, (BigDecimal)BigDecimal.valueOf(blockCount)).setScale(4, 4).doubleValue();
    }
}

