/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.bo.round;

import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.core.crypto.Sha256Hash;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.TypeDescriptor;
import java.util.ArrayList;
import java.util.List;

@ApiModel(name="Rotation member information")
public class MeetingMember
implements Comparable<MeetingMember> {
    @ApiModelProperty(description="Round index")
    private long roundIndex;
    @ApiModelProperty(description="Start time of round")
    private long roundStartTime;
    @ApiModelProperty(description="Which block did this node exit in this round")
    private int packingIndexOfRound;
    @ApiModelProperty(description="Consensus node information")
    private Agent agent;
    @ApiModelProperty(description="Current node delegation information", type=@TypeDescriptor(value=List.class, collectionElement=Deposit.class))
    private List<Deposit> depositList = new ArrayList<Deposit>();
    @ApiModelProperty(description="Sorting values")
    private String sortValue;
    @ApiModelProperty(description="Starting block time of the current node")
    private long packStartTime;
    @ApiModelProperty(description="End time of current node block output")
    private long packEndTime;

    public String getSortValue() {
        if (this.sortValue == null) {
            byte[] hash = ByteUtils.concatenate((byte[][])new byte[][]{this.agent.getPackingAddress(), SerializeUtils.uint64ToByteArray((long)this.roundStartTime)});
            this.sortValue = Sha256Hash.twiceOf((byte[])hash).toString();
        }
        return this.sortValue;
    }

    public int getPackingIndexOfRound() {
        return this.packingIndexOfRound;
    }

    public void setPackingIndexOfRound(int packingIndexOfRound) {
        this.packingIndexOfRound = packingIndexOfRound;
    }

    public long getPackStartTime() {
        return this.packStartTime;
    }

    public void setPackStartTime(long packStartTime) {
        this.packStartTime = packStartTime;
    }

    public long getPackEndTime() {
        return this.packEndTime;
    }

    public void setPackEndTime(long packEndTime) {
        this.packEndTime = packEndTime;
    }

    @Override
    public int compareTo(MeetingMember o2) {
        return this.getSortValue().compareTo(o2.getSortValue());
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public List<Deposit> getDepositList() {
        return this.depositList;
    }

    public void setDepositList(List<Deposit> depositList) {
        this.depositList = depositList;
    }

    public void setSortValue(String sortValue) {
        this.sortValue = sortValue;
    }

    public long getRoundStartTime() {
        return this.roundStartTime;
    }

    public void setRoundStartTime(long roundStartTime) {
        this.roundStartTime = roundStartTime;
    }

    public long getRoundIndex() {
        return this.roundIndex;
    }

    public void setRoundIndex(long roundIndex) {
        this.roundIndex = roundIndex;
    }
}

