/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.dto.output;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.nuls.base.basic.AddressTool;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import java.math.BigInteger;

@ApiModel(name="Node information details")
public class AgentDTO {
    @ApiModelProperty(description="nodeHASH")
    private String agentHash;
    @ApiModelProperty(description="Node address")
    private String agentAddress;
    @ApiModelProperty(description="Node block address")
    private String packingAddress;
    @ApiModelProperty(description="Node reward address")
    private String rewardAddress;
    @ApiModelProperty(description="Mortgage amount")
    private String deposit;
    @ApiModelProperty(description="commission rate")
    private byte commissionRate;
    @ApiModelProperty(description="Node Name")
    private String agentName;
    @ApiModelProperty(description="nodeID")
    private String agentId;
    @JsonIgnore
    @ApiModelProperty(description="Node Introduction")
    private String introduction;
    @ApiModelProperty(description="Node creation time")
    private long time;
    @ApiModelProperty(description="Node packaging height")
    private long blockHeight;
    @ApiModelProperty(description="Node failure height")
    private long delHeight;
    @ApiModelProperty(description="state")
    private int status;
    @ApiModelProperty(description="Reputation value")
    private double creditVal;
    @ApiModelProperty(description="Total entrusted amount")
    private String totalDeposit;
    @ApiModelProperty(description="Create node transactionsHASH")
    private String txHash;
    @ApiModelProperty(description="Number of Commissioners")
    private final int memberCount;
    @ApiModelProperty(description="version")
    private String version;

    public AgentDTO(Agent agent) {
        this.agentHash = agent.getTxHash().toHex();
        this.agentAddress = AddressTool.getStringAddressByBytes((byte[])agent.getAgentAddress());
        this.packingAddress = AddressTool.getStringAddressByBytes((byte[])agent.getPackingAddress());
        this.rewardAddress = AddressTool.getStringAddressByBytes((byte[])agent.getRewardAddress());
        this.deposit = BigIntegerUtils.bigIntegerToString((BigInteger)agent.getDeposit());
        this.commissionRate = agent.getCommissionRate();
        this.agentName = agent.getAlais();
        this.agentId = ((AgentManager)SpringLiteContext.getBean(AgentManager.class)).getAgentId(agent.getTxHash());
        this.time = agent.getTime();
        this.blockHeight = agent.getBlockHeight();
        this.delHeight = agent.getDelHeight();
        this.status = agent.getStatus();
        this.creditVal = agent.getRealCreditVal();
        this.totalDeposit = String.valueOf(agent.getReTotalDeposit());
        this.txHash = agent.getTxHash().toHex();
        this.memberCount = agent.getMemberCount();
    }

    public String getAgentAddress() {
        return this.agentAddress;
    }

    public void setAgentAddress(String agentAddress) {
        this.agentAddress = agentAddress;
    }

    public String getPackingAddress() {
        return this.packingAddress;
    }

    public void setPackingAddress(String packingAddress) {
        this.packingAddress = packingAddress;
    }

    public String getRewardAddress() {
        return this.rewardAddress;
    }

    public void setRewardAddress(String rewardAddress) {
        this.rewardAddress = rewardAddress;
    }

    public byte getCommissionRate() {
        return this.commissionRate;
    }

    public void setCommissionRate(byte commissionRate) {
        this.commissionRate = commissionRate;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public long getDelHeight() {
        return this.delHeight;
    }

    public void setDelHeight(long delHeight) {
        this.delHeight = delHeight;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public double getCreditVal() {
        return this.creditVal;
    }

    public void setCreditVal(double creditVal) {
        this.creditVal = creditVal;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public String getAgentHash() {
        return this.agentHash;
    }

    public void setAgentHash(String agentHash) {
        this.agentHash = agentHash;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDeposit() {
        return this.deposit;
    }

    public void setDeposit(String deposit) {
        this.deposit = deposit;
    }

    public String getTotalDeposit() {
        return this.totalDeposit;
    }

    public void setTotalDeposit(String totalDeposit) {
        this.totalDeposit = totalDeposit;
    }
}

