/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.dto.transaction;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinFrom;
import io.nuls.consensus.model.dto.transaction.CoinDto;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class CoinFromDto
extends CoinDto {
    @ApiModelProperty(description="accountnonceValue ofHexString, prevent double flower transactions, retrieve the previous transactionhashAt the end of8Bytes")
    private String nonce;
    @ApiModelProperty(description="0Ordinary transactions,-1Unlock amount transaction\uff08Exit consensus, exit delegation\uff09")
    private byte locked;

    public CoinFromDto() {
    }

    public CoinFromDto(CoinFrom from) {
        this.address = AddressTool.getStringAddressByBytes((byte[])from.getAddress());
        this.amount = from.getAmount().toString();
        this.assetsChainId = from.getAssetsChainId();
        this.assetsId = from.getAssetsId();
        this.nonce = HexUtil.encode((byte[])from.getNonce());
        this.locked = from.getLocked();
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public byte getLocked() {
        return this.locked;
    }

    public void setLocked(byte locked) {
        this.locked = locked;
    }
}

