/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.po;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import org.bouncycastle.util.encoders.Hex;

public class RandomSeedStatusPo
extends BaseNulsData {
    private byte[] address;
    private long height;
    private byte[] seedHash;
    private byte[] nextSeed;

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public byte[] getNextSeed() {
        return this.nextSeed;
    }

    public void setNextSeed(byte[] nextSeed) {
        this.nextSeed = nextSeed;
    }

    public byte[] getSeedHash() {
        return this.seedHash;
    }

    public void setSeedHash(byte[] seedHash) {
        this.seedHash = seedHash;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeInt64(this.height);
        stream.write(this.seedHash);
        if (null != this.nextSeed) {
            stream.write(this.nextSeed);
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.height = byteBuffer.readInt64();
        this.seedHash = byteBuffer.readBytes(8);
        if (!byteBuffer.isFinished()) {
            this.nextSeed = byteBuffer.readBytes(32);
        }
    }

    public int size() {
        int size = 48;
        if (null == this.nextSeed) {
            size = 16;
        }
        return size;
    }

    public String toString() {
        String result = "{address=" + AddressTool.getStringAddressByBytes((byte[])this.address) + ", height=" + this.height + ", seedHash=" + Hex.encode((byte[])this.seedHash);
        if (null != this.nextSeed) {
            result = result + ", nextSeed=" + Hex.encode((byte[])this.nextSeed);
        }
        result = result + "}";
        return result;
    }
}

