/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.dto.input.ValidBlockDTO;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.service.BlockService;
import io.nuls.consensus.utils.manager.BlockManager;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.validator.BlockValidator;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.message.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class BlockServiceImpl
implements BlockService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private BlockManager blockManager;
    @Autowired
    private BlockValidator blockValidator;

    @Override
    public Result addBlock(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("blockHeader") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            String headerHex = (String)params.get("blockHeader");
            BlockHeader header = new BlockHeader();
            header.parse(RPCUtil.decode((String)headerHex), 0);
            this.blockManager.addNewBlock(chain, header);
            HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
            validResult.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(validResult);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
    }

    @Override
    public Result chainRollBack(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("height") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        int height = (Integer)params.get("height");
        this.blockManager.chainRollBack(chain, height);
        HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
        validResult.put("value", true);
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(validResult);
    }

    @Override
    public Result receiveHeaderList(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("headerList") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            List headerList = (List)params.get("headerList");
            ArrayList<BlockHeader> blockHeaderList = new ArrayList<BlockHeader>();
            for (String header : headerList) {
                BlockHeader blockHeader = new BlockHeader();
                blockHeader.parse(RPCUtil.decode((String)header), 0);
                blockHeaderList.add(blockHeader);
            }
            List<BlockHeader> localBlockHeaders = chain.getBlockHeaderList();
            localBlockHeaders.addAll(0, blockHeaderList);
            HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
            validResult.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(validResult);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
    }

    @Override
    public Result validBlock(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        ValidBlockDTO dto = (ValidBlockDTO)JSONUtils.map2pojo(params, ValidBlockDTO.class);
        if (dto.getChainId() <= 0 || dto.getBlock() == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = dto.getChainId();
        boolean isDownload = dto.getDownload() == 0;
        String blockHex = dto.getBlock();
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
        validResult.put("value", false);
        try {
            Block block = new Block();
            block.parse(new NulsByteBuffer(RPCUtil.decode((String)blockHex)));
            this.blockValidator.validate(isDownload, chain, block);
            Response response = CallMethodUtils.verify(chainId, block.getTxs(), block.getHeader(), chain.getNewestHeader(), chain.getLogger());
            if (response.isSuccess()) {
                Map responseData = (Map)response.getResponseData();
                Map v = (Map)responseData.get("tx_batchVerify");
                return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData((Object)v);
            }
            chain.getLogger().info("Block transaction validation failed!");
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode()).setData(validResult);
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
        }
        return Result.getFailed((ErrorCode)ConsensusErrorCode.FAILED).setData(validResult);
    }
}

