/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.CancelDeposit;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.bo.tx.txdata.StopAgent;
import io.nuls.consensus.model.dto.input.ContractAgentDTO;
import io.nuls.consensus.model.dto.input.ContractDepositDTO;
import io.nuls.consensus.model.dto.input.ContractStopAgentDTO;
import io.nuls.consensus.model.dto.input.ContractWithdrawDTO;
import io.nuls.consensus.model.dto.input.SearchContractAgentDTO;
import io.nuls.consensus.model.dto.input.SearchContractDepositDTO;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.service.ContractService;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.consensus.storage.DepositStorageService;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.CoinDataManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class ContractServiceImpl
implements ContractService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private CoinDataManager coinDataManager;
    @Autowired
    private TxValidator validatorManager;
    @Autowired
    private RoundManager roundManager;
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private AgentStorageService agentStorageService;
    @Autowired
    private DepositStorageService depositStorageService;

    @Override
    public Result createAgent(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        ContractAgentDTO dto = (ContractAgentDTO)JSONUtils.map2pojo(params, ContractAgentDTO.class);
        int chainId = dto.getChainId();
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        Transaction tx = new Transaction(20);
        tx.setTime(dto.getBlockTime());
        Agent agent = new Agent();
        agent.setAgentAddress(AddressTool.getAddress((String)dto.getContractAddress()));
        agent.setPackingAddress(AddressTool.getAddress((String)dto.getPackingAddress()));
        agent.setRewardAddress(agent.getAgentAddress());
        agent.setDeposit(BigIntegerUtils.stringToBigInteger((String)dto.getDeposit()));
        agent.setCommissionRate(Byte.valueOf(dto.getCommissionRate()));
        try {
            tx.setTxData(agent.serialize());
            CoinData coinData = this.coinDataManager.getContractCoinData(agent.getAgentAddress(), chain, new BigInteger(dto.getDeposit()), -1L, RPCUtil.decode((String)dto.getContractNonce()), new BigInteger(dto.getContractBalance()));
            tx.setCoinData(coinData.serialize());
            boolean validResult = this.validatorManager.validateTx(chain, tx);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            HashMap result = new HashMap(16);
            ArrayList<String> value = new ArrayList<String>();
            value.add(tx.getHash().toHex());
            value.add(RPCUtil.encode((byte[])tx.serialize()));
            result.put("value", value);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
    }

    @Override
    public Result stopAgent(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        ContractStopAgentDTO dto = (ContractStopAgentDTO)JSONUtils.map2pojo(params, ContractStopAgentDTO.class);
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        Transaction tx = new Transaction(23);
        StopAgent stopAgent = new StopAgent();
        stopAgent.setAddress(AddressTool.getAddress((String)dto.getContractAddress()));
        List<Agent> agentList = chain.getAgentList();
        Agent agent = null;
        for (Agent a : agentList) {
            if (a.getDelHeight() > 0L || !Arrays.equals(a.getAgentAddress(), AddressTool.getAddress((String)dto.getContractAddress()))) continue;
            agent = a;
            break;
        }
        if (agent == null || agent.getDelHeight() > 0L) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        try {
            stopAgent.setCreateTxHash(agent.getTxHash());
            tx.setTxData(stopAgent.serialize());
            tx.setTime(dto.getBlockTime());
            CoinData coinData = this.coinDataManager.getStopAgentCoinData(chain, agent, tx.getTime() + chain.getConfig().getStopAgentLockTime());
            tx.setCoinData(coinData.serialize());
            boolean validResult = this.validatorManager.validateTx(chain, tx);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            HashMap result = new HashMap(16);
            ArrayList<String> value = new ArrayList<String>();
            value.add(tx.getHash().toHex());
            value.add(RPCUtil.encode((byte[])tx.serialize()));
            result.put("value", value);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result depositToAgent(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        ContractDepositDTO dto = (ContractDepositDTO)JSONUtils.map2pojo(params, ContractDepositDTO.class);
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        if (!NulsHash.validHash((String)dto.getAgentHash())) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        Transaction tx = new Transaction(21);
        Deposit deposit = new Deposit();
        deposit.setAddress(AddressTool.getAddress((String)dto.getContractAddress()));
        deposit.setDeposit(BigIntegerUtils.stringToBigInteger((String)dto.getDeposit()));
        try {
            deposit.setAgentHash(NulsHash.fromHex((String)dto.getAgentHash()));
            tx.setTxData(deposit.serialize());
            tx.setTime(dto.getBlockTime());
            CoinData coinData = this.coinDataManager.getContractCoinData(deposit.getAddress(), chain, new BigInteger(dto.getDeposit()), -1L, RPCUtil.decode((String)dto.getContractNonce()), new BigInteger(dto.getContractBalance()));
            tx.setCoinData(coinData.serialize());
            boolean validResult = this.validatorManager.validateTx(chain, tx);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            HashMap result = new HashMap(16);
            ArrayList<String> value = new ArrayList<String>();
            value.add(tx.getHash().toHex());
            value.add(RPCUtil.encode((byte[])tx.serialize()));
            result.put("value", value);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result withdraw(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        ContractWithdrawDTO dto = (ContractWithdrawDTO)JSONUtils.map2pojo(params, ContractWithdrawDTO.class);
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        if (!NulsHash.validHash((String)dto.getJoinAgentHash())) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        try {
            byte[] hash = NulsHash.fromHex((String)dto.getJoinAgentHash()).getBytes();
            Transaction depositTransaction = CallMethodUtils.getTransaction(chain, dto.getJoinAgentHash());
            if (depositTransaction == null) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_NOT_EXIST);
            }
            CoinData depositCoinData = new CoinData();
            depositCoinData.parse(depositTransaction.getCoinData(), 0);
            Deposit deposit = new Deposit();
            deposit.parse(depositTransaction.getTxData(), 0);
            boolean flag = false;
            for (CoinTo to : depositCoinData.getTo()) {
                if (to.getLockTime() != -1L || to.getAmount().compareTo(deposit.getDeposit()) != 0) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
            }
            Transaction cancelDepositTransaction = new Transaction(22);
            CancelDeposit cancelDeposit = new CancelDeposit();
            cancelDeposit.setAddress(AddressTool.getAddress((String)dto.getContractAddress()));
            cancelDeposit.setJoinTxHash(new NulsHash(hash));
            cancelDepositTransaction.setTxData(cancelDeposit.serialize());
            CoinData coinData = this.coinDataManager.getContractUnlockCoinData(cancelDeposit.getAddress(), chain, deposit.getDeposit(), 0L);
            ((CoinFrom)coinData.getFrom().get(0)).setNonce(CallMethodUtils.getNonce(hash));
            cancelDepositTransaction.setCoinData(coinData.serialize());
            cancelDepositTransaction.setTime(dto.getBlockTime());
            boolean validResult = this.validatorManager.validateTx(chain, cancelDepositTransaction);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            HashMap result = new HashMap(16);
            ArrayList<String> value = new ArrayList<String>();
            value.add(cancelDepositTransaction.getHash().toHex());
            value.add(RPCUtil.encode((byte[])cancelDepositTransaction.serialize()));
            result.put("value", value);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result getAgentInfo(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        SearchContractAgentDTO dto = (SearchContractAgentDTO)JSONUtils.map2pojo(params, SearchContractAgentDTO.class);
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        if (!NulsHash.validHash((String)dto.getAgentHash())) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        String contractSender = dto.getContractSender();
        if (StringUtils.isNotBlank((String)contractSender) && !AddressTool.validAddress((int)dto.getChainId(), (String)contractSender)) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.ADDRESS_ERROR);
        }
        if (!AddressTool.validContractAddress((byte[])AddressTool.getAddress((String)dto.getContractAddress()), (int)dto.getChainId())) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.ADDRESS_ERROR);
        }
        NulsHash agentHash = NulsHash.fromHex((String)dto.getAgentHash());
        List<Agent> agentList = chain.getAgentList();
        for (Agent agent : agentList) {
            if (!agent.getTxHash().equals((Object)agentHash)) continue;
            HashMap result = new HashMap(16);
            ArrayList<String> value = new ArrayList<String>();
            value.add(AddressTool.getStringAddressByBytes((byte[])agent.getAgentAddress()));
            value.add(AddressTool.getStringAddressByBytes((byte[])agent.getPackingAddress()));
            value.add(AddressTool.getStringAddressByBytes((byte[])agent.getRewardAddress()));
            value.add(agent.getDeposit().toString());
            if (ProtocolGroupManager.getCurrentVersion((int)chain.getConfig().getChainId()) >= 5) {
                value.add(this.agentManager.getAgentDeposit(chain, agent).toString());
            } else {
                value.add(agent.getTotalDeposit().toString());
            }
            value.add(String.valueOf(agent.getCommissionRate()));
            value.add(String.valueOf(agent.getTime()));
            value.add(String.valueOf(agent.getBlockHeight()));
            value.add(String.valueOf(agent.getDelHeight()));
            MeetingRound round = this.roundManager.getCurrentRound(chain);
            if (round != null && round.getOnlyMember(agent.getPackingAddress(), chain) != null) {
                value.add(String.valueOf(1));
            } else {
                value.add(String.valueOf(agent.getStatus()));
            }
            result.put("value", value);
            try {
                chain.getLogger().info("contract cs_getContractDepositInfo, param is {}, data is {}", new Object[]{JSONUtils.obj2json((Object)dto), JSONUtils.obj2json(result)});
            }
            catch (Exception e) {
                chain.getLogger().warn(e.getMessage());
            }
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        return Result.getFailed((ErrorCode)ConsensusErrorCode.AGENT_NOT_EXIST);
    }

    @Override
    public Result getDepositInfo(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        SearchContractDepositDTO dto = (SearchContractDepositDTO)JSONUtils.map2pojo(params, SearchContractDepositDTO.class);
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        if (!NulsHash.validHash((String)dto.getJoinAgentHash())) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        String contractSender = dto.getContractSender();
        if (StringUtils.isNotBlank((String)contractSender) && !AddressTool.validAddress((int)dto.getChainId(), (String)contractSender)) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.ADDRESS_ERROR);
        }
        if (!AddressTool.validContractAddress((byte[])AddressTool.getAddress((String)dto.getContractAddress()), (int)dto.getChainId())) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.ADDRESS_ERROR);
        }
        NulsHash hash = NulsHash.fromHex((String)dto.getJoinAgentHash());
        DepositPo deposit = this.depositStorageService.get(hash, chain.getConfig().getChainId());
        HashMap result = new HashMap(16);
        ArrayList<String> value = new ArrayList<String>();
        value.add(deposit.getAgentHash().toHex());
        AgentPo agentPo = this.agentStorageService.get(deposit.getAgentHash(), chain.getConfig().getChainId());
        value.add(AddressTool.getStringAddressByBytes((byte[])agentPo.getAgentAddress()));
        value.add(AddressTool.getStringAddressByBytes((byte[])deposit.getAddress()));
        value.add(deposit.getDeposit().toString());
        value.add(String.valueOf(deposit.getTime()));
        value.add(String.valueOf(deposit.getBlockHeight()));
        value.add(String.valueOf(deposit.getDelHeight()));
        MeetingRound round = this.roundManager.getCurrentRound(chain);
        if (round != null && round.getOnlyMember(agentPo.getPackingAddress(), chain) != null) {
            value.add(String.valueOf(1));
        } else {
            value.add(String.valueOf(0));
        }
        result.put("value", value);
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
    }

    @Override
    public Result triggerCoinBaseContract(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("tx") == null || params.get("blockHeader") == null || params.get("stateRoot") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        HashMap<String, String> result = new HashMap<String, String>(2);
        String stateRoot = null;
        try {
            MeetingMember member;
            Transaction coinBaseTransaction = new Transaction();
            coinBaseTransaction.parse(RPCUtil.decode((String)((String)params.get("tx"))), 0);
            BlockHeader blockHeader = new BlockHeader();
            String originalStateRoot = (String)params.get("stateRoot");
            blockHeader.parse(RPCUtil.decode((String)((String)params.get("blockHeader"))), 0);
            BlockExtendsData extendsData = blockHeader.getExtendsData();
            MeetingRound round = this.roundManager.getRoundByIndex(chain, extendsData.getRoundIndex());
            if (round == null) {
                round = this.roundManager.getRound(chain, extendsData, false);
            }
            if (AddressTool.validContractAddress((byte[])(member = round.getMember(extendsData.getPackingIndexOfRound())).getAgent().getRewardAddress(), (int)chain.getConfig().getChainId())) {
                stateRoot = CallMethodUtils.triggerContract(chain.getConfig().getChainId(), originalStateRoot, blockHeader.getHeight() - 1L, AddressTool.getStringAddressByBytes((byte[])member.getAgent().getRewardAddress()), RPCUtil.encode((byte[])coinBaseTransaction.serialize()));
                extendsData.setStateRoot(RPCUtil.decode((String)stateRoot));
            } else if (this.coinDataManager.hasContractAddress(coinBaseTransaction.getCoinDataInstance(), chain.getConfig().getChainId())) {
                stateRoot = CallMethodUtils.triggerContract(chain.getConfig().getChainId(), originalStateRoot, blockHeader.getHeight() - 1L, null, RPCUtil.encode((byte[])coinBaseTransaction.serialize()));
                extendsData.setStateRoot(RPCUtil.decode((String)stateRoot));
            } else {
                stateRoot = originalStateRoot;
            }
            result.put("value", stateRoot);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            result.put("value", null);
            return Result.getFailed((ErrorCode)e.getErrorCode()).setData(result);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            result.put("value", null);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.FAILED).setData(result);
        }
    }
}

