/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.storage.impl;

import io.nuls.base.data.NulsHash;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.storage.DepositStorageService;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.List;

@Component
public class DepositStorageServiceImpl
implements DepositStorageService {
    @Override
    public boolean save(DepositPo depositPo, int chainID) {
        if (depositPo == null || depositPo.getTxHash() == null) {
            return false;
        }
        try {
            byte[] key = depositPo.getTxHash().getBytes();
            byte[] value = depositPo.serialize();
            return RocksDBService.put((String)("consensus_deposit" + chainID), (byte[])key, (byte[])value);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public DepositPo get(NulsHash hash, int chainID) {
        if (hash == null) {
            return null;
        }
        try {
            byte[] value = RocksDBService.get((String)("consensus_deposit" + chainID), (byte[])hash.getBytes());
            if (value == null) {
                return null;
            }
            DepositPo po = new DepositPo();
            po.parse(value, 0);
            po.setTxHash(hash);
            return po;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean delete(NulsHash hash, int chainID) {
        if (hash == null) {
            return false;
        }
        try {
            byte[] key = hash.getBytes();
            return RocksDBService.delete((String)("consensus_deposit" + chainID), (byte[])key);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public List<DepositPo> getList(int chainID) throws NulsException {
        List list = RocksDBService.entryList((String)("consensus_deposit" + chainID));
        ArrayList<DepositPo> depositList = new ArrayList<DepositPo>();
        for (Entry entry : list) {
            DepositPo po = new DepositPo();
            po.parse((byte[])entry.getValue(), 0);
            NulsHash hash = new NulsHash((byte[])entry.getKey());
            po.setTxHash(hash);
            depositList.add(po);
        }
        return depositList;
    }

    @Override
    public int size(int chainID) {
        List keyList = RocksDBService.keyList((String)("consensus_deposit" + chainID));
        if (keyList != null) {
            return keyList.size();
        }
        return 0;
    }
}

