/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.storage.impl;

import io.nuls.consensus.model.po.PunishLogPo;
import io.nuls.consensus.storage.PunishStorageService;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.List;

@Component
public class PunishStorageServiceImpl
implements PunishStorageService {
    @Override
    public boolean save(PunishLogPo po, int chainID) {
        if (po == null || po.getKey() == null) {
            return false;
        }
        try {
            return RocksDBService.put((String)("consensus_punish" + chainID), (byte[])po.getKey(), (byte[])po.serialize());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean delete(byte[] key, int chainID) {
        if (key == null) {
            return false;
        }
        try {
            return RocksDBService.delete((String)("consensus_punish" + chainID), (byte[])key);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public List<PunishLogPo> getPunishList(int chainID) throws Exception {
        try {
            List list = RocksDBService.entryList((String)("consensus_punish" + chainID));
            ArrayList<PunishLogPo> agentList = new ArrayList<PunishLogPo>();
            for (Entry entry : list) {
                PunishLogPo po = new PunishLogPo();
                po.parse((byte[])entry.getValue(), 0);
                agentList.add(po);
            }
            return agentList;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw e;
        }
    }
}

