/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.storage.impl;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.consensus.constant.ConsensusConstant;
import io.nuls.consensus.model.po.RandomSeedPo;
import io.nuls.consensus.model.po.RandomSeedStatusPo;
import io.nuls.consensus.storage.RandomSeedsStorageService;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ArraysTool;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.List;

@Component
public class RandomSeedsStorageServiceImpl
implements RandomSeedsStorageService {
    @Override
    public RandomSeedStatusPo getAddressStatus(int chainId, byte[] address) {
        byte[] bytes = RocksDBService.get((String)("random_seed" + chainId), (byte[])address);
        if (null == bytes) {
            return null;
        }
        RandomSeedStatusPo po = new RandomSeedStatusPo();
        try {
            po.parse(new NulsByteBuffer(bytes, 0));
            po.setAddress(address);
        }
        catch (NulsException e) {
            Log.error((Throwable)e);
        }
        return po;
    }

    @Override
    public boolean saveAddressStatus(int chainId, byte[] address, long nowHeight, byte[] nextSeed, byte[] seedHash) {
        RandomSeedStatusPo po = new RandomSeedStatusPo();
        po.setAddress(address);
        po.setHeight(nowHeight);
        po.setNextSeed(nextSeed);
        po.setSeedHash(seedHash);
        try {
            RocksDBService.put((String)("random_seed" + chainId), (byte[])address, (byte[])po.serialize());
            return true;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public void deleteAddressStatus(int chainId, byte[] address) {
        try {
            RocksDBService.delete((String)("random_seed" + chainId), (byte[])address);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean saveRandomSeed(int chainId, long height, long preHeight, byte[] seed, byte[] nextSeedHash) {
        RandomSeedPo po = new RandomSeedPo();
        po.setPreHeight(preHeight);
        po.setSeed(seed);
        po.setNextSeedHash(nextSeedHash);
        try {
            RocksDBService.put((String)("random_seed" + chainId), (byte[])SerializeUtils.uint64ToByteArray((long)height), (byte[])po.serialize());
            return true;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean deleteRandomSeed(int chainId, long height) {
        try {
            RocksDBService.delete((String)("random_seed" + chainId), (byte[])SerializeUtils.uint64ToByteArray((long)height));
            return true;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public RandomSeedPo getSeed(int chainId, long height) {
        byte[] bytes = RocksDBService.get((String)("random_seed" + chainId), (byte[])SerializeUtils.uint64ToByteArray((long)height));
        if (null == bytes) {
            return null;
        }
        RandomSeedPo po = new RandomSeedPo();
        try {
            po.parse(new NulsByteBuffer(bytes, 0));
            po.setHeight(height);
        }
        catch (NulsException e) {
            Log.error((Throwable)e);
        }
        return po;
    }

    @Override
    public List<byte[]> getSeeds(int chainId, long maxHeight, int seedCount) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        long minHeight = maxHeight - 1000L;
        while (maxHeight > minHeight) {
            RandomSeedPo po;
            if (null != (po = this.getSeed(chainId, maxHeight--)) && !ArraysTool.arrayEquals((byte[])po.getSeed(), (byte[])ConsensusConstant.EMPTY_SEED)) {
                list.add(po.getSeed());
            }
            if (list.size() < seedCount) continue;
            break;
        }
        return list;
    }

    @Override
    public List<byte[]> getSeeds(int chainId, long startHeight, long endHeight) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        long height = startHeight;
        while (height <= endHeight) {
            RandomSeedPo po;
            if (null == (po = this.getSeed(chainId, height++)) || ArraysTool.arrayEquals((byte[])po.getSeed(), (byte[])ConsensusConstant.EMPTY_SEED)) continue;
            list.add(po.getSeed());
        }
        return list;
    }
}

