/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.tx.v1;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.service.impl.RandomSeedService;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import java.util.List;
import java.util.Map;

@Component(value="CoinBaseProcessorV1")
public class CoinBaseProcessor
implements TransactionProcessor {
    @Autowired
    private RoundManager roundManager;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private RandomSeedService randomSeedService;

    public int getType() {
        return 1;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        return null;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        if (blockHeader == null) {
            Log.warn((String)"empty blockHeader");
            return true;
        }
        try {
            Chain chain = this.chainManager.getChainMap().get(chainId);
            BlockHeader newestHeader = chain.getNewestHeader();
            if (newestHeader == null) {
                Log.warn((String)"empty newestHeader");
                return true;
            }
            byte[] prePackingAddress = newestHeader.getPackingAddress(chainId);
            this.randomSeedService.processBlock(chainId, blockHeader, prePackingAddress);
        }
        catch (Exception e) {
            Log.error((String)"save random seed error.", (Throwable)e);
        }
        return true;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        if (blockHeader == null) {
            return true;
        }
        try {
            this.randomSeedService.rollbackBlock(chainId, blockHeader);
        }
        catch (Exception e) {
            Log.error((String)"rollback random seed error.", (Throwable)e);
        }
        return true;
    }
}

