/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.tx.v3;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.utils.LoggerUtil;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.DepositManager;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component(value="DepositProcessorV3")
public class DepositProcessor
implements TransactionProcessor {
    @Autowired
    private DepositManager depositManager;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TxValidator txValidator;

    public int getType() {
        return 5;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            result.put("txList", txs);
            result.put("errorCode", ConsensusErrorCode.CHAIN_NOT_EXIST.getCode());
            return result;
        }
        ArrayList<Transaction> invalidTxList = new ArrayList<Transaction>();
        String errorCode = null;
        Set<NulsHash> invalidHashSet = this.txValidator.getInvalidAgentHash(txMap.get(8), txMap.get(23), txMap.get(9), chain);
        Map<Object, Object> agentDepositTotalMap = new HashMap(16);
        try {
            Map<NulsHash, BigInteger> contractDepositMap = this.getContractDepositMap(chain, txMap.get(21));
            if (contractDepositMap != null) {
                agentDepositTotalMap = contractDepositMap;
            }
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
        }
        for (Transaction depositTx : txs) {
            try {
                Deposit deposit = new Deposit();
                deposit.parse(depositTx.getTxData(), 0);
                if (!this.verifyV3(chain, depositTx, deposit.getAddress())) {
                    invalidTxList.add(depositTx);
                    continue;
                }
                if (!this.txValidator.validateTx(chain, depositTx)) {
                    invalidTxList.add(depositTx);
                    chain.getLogger().info("Delegated transaction verification failed");
                    continue;
                }
                if (invalidHashSet.contains(deposit.getAgentHash())) {
                    invalidTxList.add(depositTx);
                    chain.getLogger().info("Conflict between Intelligent Delegation Transaction and Red Card Transaction or Stop Node Transaction");
                    errorCode = ConsensusErrorCode.CONFLICT_ERROR.getCode();
                }
                NulsHash agentHash = deposit.getAgentHash();
                BigInteger totalDeposit = BigInteger.ZERO;
                if (agentDepositTotalMap.containsKey(agentHash)) {
                    totalDeposit = ((BigInteger)agentDepositTotalMap.get(agentHash)).add(deposit.getDeposit());
                    if (totalDeposit.compareTo(chain.getConfig().getCommissionMax()) > 0) {
                        chain.getLogger().info("Node delegation amount exceeds maximum delegation amount");
                        throw new NulsException(ConsensusErrorCode.DEPOSIT_OVER_AMOUNT);
                    }
                    agentDepositTotalMap.put(agentHash, totalDeposit);
                    continue;
                }
                List<DepositPo> poList = this.txValidator.getDepositListByAgent(chain, deposit.getAgentHash());
                for (DepositPo cd : poList) {
                    totalDeposit = totalDeposit.add(cd.getDeposit());
                }
                totalDeposit = totalDeposit.add(deposit.getDeposit());
                agentDepositTotalMap.put(agentHash, totalDeposit);
            }
            catch (NulsException e) {
                invalidTxList.add(depositTx);
                chain.getLogger().error("Intelligent Contract Creation Node Transaction Verification Failed");
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
            }
            catch (IOException io) {
                invalidTxList.add(depositTx);
                chain.getLogger().error("Intelligent Contract Creation Node Transaction Verification Failed");
                chain.getLogger().error((Exception)io);
                errorCode = ConsensusErrorCode.SERIALIZE_ERROR.getCode();
            }
        }
        result.put("txList", invalidTxList);
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        boolean commitResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.depositManager.depositCommit(tx, blockHeader, chain)) continue;
                commitSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to deposit transaction submission");
                chain.getLogger().error(e);
                commitResult = false;
            }
        }
        if (!commitResult) {
            for (Transaction rollbackTx : commitSuccessList) {
                try {
                    this.depositManager.depositRollBack(rollbackTx, chain);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to deposit transaction rollback");
                    chain.getLogger().error(e);
                }
            }
        }
        return commitResult;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> rollbackSuccessList = new ArrayList<Transaction>();
        boolean rollbackResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.depositManager.depositRollBack(tx, chain)) continue;
                rollbackSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to deposit transaction rollback");
                chain.getLogger().error(e);
                rollbackResult = false;
            }
        }
        if (!rollbackResult) {
            for (Transaction commitTx : rollbackSuccessList) {
                try {
                    this.depositManager.depositCommit(commitTx, blockHeader, chain);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to deposit transaction submission");
                    chain.getLogger().error(e);
                }
            }
        }
        return rollbackResult;
    }

    private boolean verifyV3(Chain chain, Transaction tx, byte[] creator) throws NulsException {
        TransactionSignature transactionSignature = new TransactionSignature();
        if (tx.getTransactionSignature() == null) {
            chain.getLogger().error("Unsigned Commission transaction");
            throw new NulsException(ConsensusErrorCode.TX_CREATOR_NOT_SIGNED);
        }
        transactionSignature.parse(tx.getTransactionSignature(), 0);
        if (transactionSignature.getP2PHKSignatures() == null || transactionSignature.getP2PHKSignatures().isEmpty()) {
            throw new NulsException(ConsensusErrorCode.TX_CREATOR_NOT_SIGNED);
        }
        if (!Arrays.equals(creator, AddressTool.getAddress((byte[])((P2PHKSignature)transactionSignature.getP2PHKSignatures().get(0)).getPublicKey(), (int)chain.getConfig().getChainId()))) {
            chain.getLogger().error("The signature of the entrusted transaction is not the signature of the entrusting party");
            throw new NulsException(ConsensusErrorCode.TX_CREATOR_NOT_SIGNED);
        }
        CoinData coinData = tx.getCoinDataInstance();
        if (!Arrays.equals(creator, ((CoinFrom)coinData.getFrom().get(0)).getAddress()) || !Arrays.equals(creator, ((CoinTo)coinData.getTo().get(0)).getAddress())) {
            chain.getLogger().error("From address or to address in coinData is not the principal address");
            throw new NulsException(ConsensusErrorCode.COIN_DATA_VALID_ERROR);
        }
        return true;
    }

    private Map<NulsHash, BigInteger> getContractDepositMap(Chain chain, List<Transaction> contractDepositList) throws NulsException {
        if (contractDepositList == null || contractDepositList.size() == 0) {
            return null;
        }
        HashMap<NulsHash, BigInteger> depositMap = new HashMap<NulsHash, BigInteger>(16);
        for (Transaction tx : contractDepositList) {
            Deposit deposit = new Deposit();
            deposit.parse(tx.getTxData(), 0);
            NulsHash agentHash = deposit.getAgentHash();
            BigInteger totalDeposit = BigInteger.ZERO;
            if (depositMap.containsKey(agentHash)) {
                totalDeposit = ((BigInteger)depositMap.get(agentHash)).add(deposit.getDeposit());
                depositMap.put(agentHash, totalDeposit);
                continue;
            }
            List<DepositPo> poList = this.txValidator.getDepositListByAgent(chain, deposit.getAgentHash());
            for (DepositPo cd : poList) {
                totalDeposit = totalDeposit.add(cd.getDeposit());
            }
            totalDeposit = totalDeposit.add(deposit.getDeposit());
            depositMap.put(agentHash, totalDeposit);
        }
        return depositMap;
    }
}

