/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.tx.v3;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.CancelDeposit;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.consensus.storage.DepositStorageService;
import io.nuls.consensus.utils.LoggerUtil;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.DepositManager;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component(value="WithdrawProcessorV3")
public class WithdrawProcessor
implements TransactionProcessor {
    @Autowired
    private DepositManager depositManager;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TxValidator txValidator;
    @Autowired
    private DepositStorageService depositStorageService;
    @Autowired
    private AgentStorageService agentStorageService;

    public int getType() {
        return 6;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        CancelDeposit cancelDeposit;
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            result.put("txList", txs);
            result.put("errorCode", ConsensusErrorCode.CHAIN_NOT_EXIST.getCode());
            return result;
        }
        ArrayList<Transaction> invalidTxList = new ArrayList<Transaction>();
        String errorCode = null;
        HashSet<NulsHash> hashSet = new HashSet<NulsHash>();
        Set<NulsHash> invalidHashSet = this.txValidator.getInvalidAgentHash(txMap.get(8), txMap.get(23), txMap.get(9), chain);
        List<Transaction> contractWithdrawTxList = txMap.get(22);
        if (contractWithdrawTxList != null && contractWithdrawTxList.size() > 0) {
            for (Transaction contractWithdrawTx : contractWithdrawTxList) {
                try {
                    cancelDeposit = new CancelDeposit();
                    cancelDeposit.parse(contractWithdrawTx.getTxData(), 0);
                    hashSet.add(cancelDeposit.getJoinTxHash());
                }
                catch (Exception e) {
                    chain.getLogger().error(e);
                }
            }
        }
        for (Transaction withdrawTx : txs) {
            try {
                if (!this.txValidator.validateTx(chain, withdrawTx)) {
                    invalidTxList.add(withdrawTx);
                    chain.getLogger().error("Intelligent contract withdrawal delegation transaction verification failed");
                    continue;
                }
                cancelDeposit = new CancelDeposit();
                cancelDeposit.parse(withdrawTx.getTxData(), 0);
                DepositPo depositPo = this.depositStorageService.get(cancelDeposit.getJoinTxHash(), chainId);
                AgentPo agentPo = this.agentStorageService.get(depositPo.getAgentHash(), chainId);
                if (null == agentPo) {
                    invalidTxList.add(withdrawTx);
                    errorCode = ConsensusErrorCode.AGENT_NOT_EXIST.getCode();
                    continue;
                }
                if (!this.verifyV3(chain, withdrawTx, depositPo.getAddress())) {
                    invalidTxList.add(withdrawTx);
                    continue;
                }
                if (invalidHashSet.contains(agentPo.getHash())) {
                    invalidTxList.add(withdrawTx);
                    errorCode = ConsensusErrorCode.CONFLICT_ERROR.getCode();
                    continue;
                }
                if (hashSet.add(cancelDeposit.getJoinTxHash())) continue;
                invalidTxList.add(withdrawTx);
                chain.getLogger().info("Repeated transactions");
                errorCode = ConsensusErrorCode.CONFLICT_ERROR.getCode();
            }
            catch (NulsException e) {
                invalidTxList.add(withdrawTx);
                chain.getLogger().error("Intelligent Contract Creation Node Transaction Verification Failed");
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
            }
            catch (IOException io) {
                invalidTxList.add(withdrawTx);
                chain.getLogger().error("Intelligent Contract Creation Node Transaction Verification Failed");
                chain.getLogger().error((Exception)io);
                errorCode = ConsensusErrorCode.SERIALIZE_ERROR.getCode();
            }
        }
        result.put("txList", invalidTxList);
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        boolean commitResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.depositManager.cancelDepositCommit(tx, blockHeader, chain)) continue;
                commitSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to withdraw transaction submission");
                chain.getLogger().error(e);
                commitResult = false;
            }
        }
        if (!commitResult) {
            for (Transaction rollbackTx : commitSuccessList) {
                try {
                    this.depositManager.cancelDepositRollBack(rollbackTx, chain, blockHeader);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to withdraw transaction rollback");
                    chain.getLogger().error(e);
                }
            }
        }
        return commitResult;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> rollbackSuccessList = new ArrayList<Transaction>();
        boolean rollbackResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.depositManager.cancelDepositRollBack(tx, chain, blockHeader)) continue;
                rollbackSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to withdraw transaction rollback");
                chain.getLogger().error(e);
                rollbackResult = false;
            }
        }
        if (!rollbackResult) {
            for (Transaction commitTx : rollbackSuccessList) {
                try {
                    this.depositManager.cancelDepositCommit(commitTx, blockHeader, chain);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to withdraw transaction submission");
                    chain.getLogger().error(e);
                }
            }
        }
        return rollbackResult;
    }

    private boolean verifyV3(Chain chain, Transaction tx, byte[] creator) throws NulsException {
        TransactionSignature transactionSignature = new TransactionSignature();
        if (tx.getTransactionSignature() == null) {
            chain.getLogger().error("Unsigned Commission transaction");
            throw new NulsException(ConsensusErrorCode.TX_CREATOR_NOT_SIGNED);
        }
        transactionSignature.parse(tx.getTransactionSignature(), 0);
        if (transactionSignature.getP2PHKSignatures() == null || transactionSignature.getP2PHKSignatures().isEmpty()) {
            chain.getLogger().error("Unsigned Commission transaction");
            throw new NulsException(ConsensusErrorCode.TX_CREATOR_NOT_SIGNED);
        }
        if (!Arrays.equals(creator, AddressTool.getAddress((byte[])((P2PHKSignature)transactionSignature.getP2PHKSignatures().get(0)).getPublicKey(), (int)chain.getConfig().getChainId()))) {
            chain.getLogger().error("The signature of the entrusted transaction is not the signature of the entrusting party");
            throw new NulsException(ConsensusErrorCode.TX_CREATOR_NOT_SIGNED);
        }
        CoinData coinData = tx.getCoinDataInstance();
        if (!Arrays.equals(creator, ((CoinFrom)coinData.getFrom().get(0)).getAddress()) || !Arrays.equals(creator, ((CoinTo)coinData.getTo().get(0)).getAddress())) {
            chain.getLogger().error("From address or to address in coinData is not the principal address");
            throw new NulsException(ConsensusErrorCode.COIN_DATA_VALID_ERROR);
        }
        return true;
    }
}

