/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.tx.v4;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.DelayStopAgent;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.consensus.storage.DepositStorageService;
import io.nuls.consensus.utils.LoggerUtil;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.DepositManager;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="DelayStopAgentProcessorV1")
public class DelayStopAgentProcessor
implements TransactionProcessor {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AgentStorageService agentStorageService;
    @Autowired
    private DepositStorageService depositStorageService;
    @Autowired
    private TxValidator txValidator;
    @Autowired
    private DepositManager depositManager;

    public int getType() {
        return 34;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            result.put("txList", txs);
            result.put("errorCode", ConsensusErrorCode.CHAIN_NOT_EXIST.getCode());
            return result;
        }
        ArrayList<Transaction> invalidTxList = new ArrayList<Transaction>();
        String errorCode = null;
        for (Transaction tx : txs) {
            try {
                if (this.txValidator.validateTx(chain, tx)) continue;
                invalidTxList.add(tx);
                chain.getLogger().info("Delay stop agent transaction verification failed");
            }
            catch (NulsException e) {
                invalidTxList.add(tx);
                chain.getLogger().error("Intelligent Delay stop agent Transaction Verification Failed");
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
            }
            catch (IOException io) {
                invalidTxList.add(tx);
                chain.getLogger().error("Intelligent Delay stop agent Transaction Verification Failed");
                chain.getLogger().error((Exception)io);
                errorCode = ConsensusErrorCode.SERIALIZE_ERROR.getCode();
            }
        }
        result.put("txList", invalidTxList);
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        boolean commitResult = true;
        for (Transaction tx : txs) {
            try {
                if (this.realCommit(tx, chain, blockHeader)) {
                    commitSuccessList.add(tx);
                    continue;
                }
                commitResult = false;
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to red punish transaction submission");
                chain.getLogger().error(e);
                commitResult = false;
            }
        }
        if (!commitResult) {
            for (Transaction rollbackTx : commitSuccessList) {
                try {
                    this.realRollback(rollbackTx, chain, blockHeader);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to red punish transaction rollback");
                    chain.getLogger().error(e);
                }
            }
        }
        return commitResult;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> rollbackSuccessList = new ArrayList<Transaction>();
        boolean rollbackResult = true;
        for (Transaction tx : txs) {
            try {
                if (this.realRollback(tx, chain, blockHeader)) {
                    rollbackSuccessList.add(tx);
                    continue;
                }
                rollbackResult = false;
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to red punish transaction rollback");
                chain.getLogger().error(e);
                rollbackResult = false;
            }
        }
        if (!rollbackResult) {
            for (Transaction commitTx : rollbackSuccessList) {
                try {
                    this.realCommit(commitTx, chain, blockHeader);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to red punish transaction submission");
                    chain.getLogger().error(e);
                }
            }
        }
        return rollbackResult;
    }

    public boolean realCommit(Transaction tx, Chain chain, BlockHeader blockHeader) throws NulsException {
        long blockHeight = blockHeader.getHeight();
        int chainId = chain.getConfig().getChainId();
        DelayStopAgent txData = new DelayStopAgent();
        txData.parse(tx.getTxData(), 0);
        AgentPo agent = this.agentStorageService.get(txData.getAgentHash(), chainId);
        if (null == agent) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        List<DepositPo> depositPoList = this.depositStorageService.getList(chainId);
        ArrayList<DepositPo> updatedList = new ArrayList<DepositPo>();
        for (DepositPo po : depositPoList) {
            if (po.getDelHeight() >= 0L || !po.getAgentHash().equals((Object)txData.getAgentHash())) continue;
            po.setDelHeight(blockHeight);
            boolean b = this.depositStorageService.save(po, chainId);
            if (!b) {
                for (DepositPo po2 : updatedList) {
                    po2.setDelHeight(-1L);
                    this.depositStorageService.save(po2, chainId);
                }
                throw new NulsException(ConsensusErrorCode.SAVE_FAILED);
            }
            updatedList.add(po);
        }
        if (!updatedList.isEmpty()) {
            for (DepositPo depositPo : updatedList) {
                this.depositManager.updateDeposit(chain, this.depositManager.poToDeposit(depositPo));
            }
        }
        return true;
    }

    public boolean realRollback(Transaction tx, Chain chain, BlockHeader blockHeader) throws NulsException {
        long blockHeight = blockHeader.getHeight();
        int chainId = chain.getConfig().getChainId();
        DelayStopAgent txData = new DelayStopAgent();
        txData.parse(tx.getTxData(), 0);
        AgentPo agent1 = this.agentStorageService.get(txData.getAgentHash(), chainId);
        if (null == agent1) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        List<DepositPo> depositPoList = this.depositStorageService.getList(chainId);
        ArrayList<DepositPo> updatedList = new ArrayList<DepositPo>();
        for (DepositPo po : depositPoList) {
            boolean success;
            if (!po.getAgentHash().equals((Object)txData.getAgentHash())) continue;
            if (po.getDelHeight() == blockHeight) {
                po.setDelHeight(-1L);
            }
            if (!(success = this.depositStorageService.save(po, chainId))) {
                for (DepositPo po2 : updatedList) {
                    po2.setDelHeight(blockHeight);
                    this.depositStorageService.save(po2, chainId);
                }
                throw new NulsException(ConsensusErrorCode.ROLLBACK_FAILED);
            }
            updatedList.add(po);
        }
        if (!updatedList.isEmpty()) {
            for (DepositPo po2 : updatedList) {
                this.depositManager.updateDeposit(chain, this.depositManager.poToDeposit(po2));
            }
        }
        return true;
    }
}

