/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.NulsHash;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.bo.tx.txdata.StopAgent;
import io.nuls.consensus.model.dto.input.CreateAgentDTO;
import io.nuls.consensus.model.dto.input.CreateDepositDTO;
import io.nuls.consensus.model.dto.input.StopAgentDTO;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.StringUtils;
import java.util.Arrays;
import java.util.List;

public class TxUtil {
    public static Agent createAgent(CreateAgentDTO dto) {
        Agent agent = new Agent();
        agent.setAgentAddress(AddressTool.getAddress((String)dto.getAgentAddress()));
        agent.setPackingAddress(AddressTool.getAddress((String)dto.getPackingAddress()));
        if (StringUtils.isBlank((String)dto.getRewardAddress())) {
            agent.setRewardAddress(agent.getAgentAddress());
        } else {
            agent.setRewardAddress(AddressTool.getAddress((String)dto.getRewardAddress()));
        }
        agent.setDeposit(BigIntegerUtils.stringToBigInteger((String)dto.getDeposit()));
        agent.setCommissionRate(dto.getCommissionRate());
        return agent;
    }

    public static StopAgent createStopAgent(Chain chain, StopAgentDTO dto) throws NulsException {
        StopAgent stopAgent = new StopAgent();
        stopAgent.setAddress(AddressTool.getAddress((String)dto.getAddress()));
        List<Agent> agentList = chain.getAgentList();
        Agent agent = null;
        for (Agent a : agentList) {
            if (a.getDelHeight() > 0L || !Arrays.equals(a.getAgentAddress(), AddressTool.getAddress((String)dto.getAddress()))) continue;
            agent = a;
            break;
        }
        if (agent == null || agent.getDelHeight() > 0L) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        stopAgent.setCreateTxHash(agent.getTxHash());
        return stopAgent;
    }

    public static Deposit createDeposit(CreateDepositDTO dto) {
        Deposit deposit = new Deposit();
        deposit.setAddress(AddressTool.getAddress((String)dto.getAddress()));
        deposit.setAgentHash(NulsHash.fromHex((String)dto.getAgentHash()));
        deposit.setDeposit(BigIntegerUtils.stringToBigInteger((String)dto.getDeposit()));
        return deposit;
    }
}

