/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.compare;

import io.nuls.consensus.model.bo.tx.txdata.Agent;
import java.util.Comparator;

public class AgentComparatorRpc
implements Comparator<Agent> {
    public static final int DEPOSIT = 0;
    public static final int COMMISSION_RATE = 1;
    public static final int CREDIT_VALUE = 2;
    public static final int DEPOSITABLE = 3;
    public static final int COMPREHENSIVE = 4;
    private static final AgentComparatorRpc[] INSTANCE_ARRAY = new AgentComparatorRpc[]{new AgentComparatorRpc(0), new AgentComparatorRpc(1), new AgentComparatorRpc(2), new AgentComparatorRpc(3), new AgentComparatorRpc(4)};
    private final int sortType;

    public static AgentComparatorRpc getInstance(int sortType) {
        switch (sortType) {
            case 0: {
                return INSTANCE_ARRAY[0];
            }
            case 1: {
                return INSTANCE_ARRAY[1];
            }
            case 2: {
                return INSTANCE_ARRAY[2];
            }
            case 3: {
                return INSTANCE_ARRAY[3];
            }
            case 4: {
                return INSTANCE_ARRAY[4];
            }
        }
        return INSTANCE_ARRAY[2];
    }

    private AgentComparatorRpc(int sortType) {
        this.sortType = sortType;
    }

    @Override
    public int compare(Agent o1, Agent o2) {
        switch (this.sortType) {
            case 0: {
                return o2.getDeposit().compareTo(o1.getDeposit());
            }
            case 1: {
                if (o1.getCommissionRate() < o2.getCommissionRate()) {
                    return -1;
                }
                if (o1.getCommissionRate() == o2.getCommissionRate()) {
                    return 0;
                }
                return 1;
            }
            case 2: {
                if (o2.getCreditVal() < o1.getCreditVal()) {
                    return -1;
                }
                if (o2.getCreditVal() == o1.getCreditVal()) {
                    return 0;
                }
                return 1;
            }
            case 3: {
                return o2.getTotalDeposit().compareTo(o1.getTotalDeposit());
            }
        }
        if (o2.getCreditVal() < o1.getCreditVal()) {
            return -1;
        }
        if (o2.getCreditVal() == o1.getCreditVal()) {
            return 0;
        }
        return 1;
    }
}

