/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.compare;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinFrom;
import java.util.Arrays;
import java.util.Comparator;

public class CoinFromComparator
implements Comparator<CoinFrom> {
    @Override
    public int compare(CoinFrom o1, CoinFrom o2) {
        if (!Arrays.equals(o1.getAddress(), o2.getAddress())) {
            return AddressTool.getStringAddressByBytes((byte[])o1.getAddress()).compareTo(AddressTool.getStringAddressByBytes((byte[])o2.getAddress()));
        }
        if (o1.getAssetsChainId() != o2.getAssetsChainId()) {
            return o1.getAssetsChainId() - o2.getAssetsChainId();
        }
        if (o1.getAssetsId() != o2.getAssetsId()) {
            return o1.getAssetsId() - o2.getAssetsId();
        }
        if (!o1.getAmount().equals(o2.getAmount())) {
            return o1.getAmount().compareTo(o2.getAmount());
        }
        return Arrays.compare(o1.getNonce(), o2.getNonce());
    }
}

