/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.manager;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.po.PunishLogPo;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.utils.enumeration.PunishType;
import io.nuls.consensus.utils.manager.FixRedPunishBugHelper;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.DoubleUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class RoundManager {
    @Autowired
    private FixRedPunishBugHelper fixRedPunishBugHelper;

    public void addRound(Chain chain, MeetingRound meetingRound) {
        List<MeetingRound> roundList = chain.getRoundList();
        if (roundList == null) {
            roundList = new ArrayList<MeetingRound>();
        } else {
            this.rollBackRound(chain, meetingRound.getIndex() - 1L);
        }
        if (roundList.size() > 0 && meetingRound.getPreRound() == null) {
            meetingRound.setPreRound(roundList.get(roundList.size() - 1));
        }
        roundList.add(meetingRound);
        if (roundList.size() > 10) {
            roundList.get(0).setPreRound(null);
            roundList.remove(0);
        }
    }

    public void rollBackRound(Chain chain, long roundIndex) {
        List<MeetingRound> roundList = chain.getRoundList();
        for (int index = roundList.size() - 1; index >= 0 && roundList.get(index).getIndex() > roundIndex; --index) {
            roundList.remove(index);
        }
    }

    public boolean clearRound(Chain chain, int count) {
        List<MeetingRound> roundList = chain.getRoundList();
        if (roundList.size() > count) {
            roundList = roundList.subList(roundList.size() - count, roundList.size());
            MeetingRound round = roundList.get(0);
            round.setPreRound(null);
        }
        return true;
    }

    public boolean clearRound(Chain chain, long roundIndex) {
        MeetingRound round;
        List<MeetingRound> roundList = chain.getRoundList();
        for (int i = roundList.size() - 1; i >= 0 && (round = roundList.get(i)).getIndex() > roundIndex; --i) {
            roundList.remove(i);
        }
        return true;
    }

    public MeetingRound getRoundByIndex(Chain chain, long roundIndex) {
        List<MeetingRound> roundList = chain.getRoundList();
        for (int i = roundList.size() - 1; i >= 0; --i) {
            MeetingRound round = roundList.get(i);
            if (round.getIndex() == roundIndex) {
                return round;
            }
            if (round.getIndex() < roundIndex) break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIsNeedReset(Chain chain) throws Exception {
        List<MeetingRound> roundList = chain.getRoundList();
        if (roundList == null || roundList.size() == 0) {
            this.initRound(chain);
        } else {
            chain.getRoundLock().lock();
            try {
                MeetingRound lastRound = roundList.get(roundList.size() - 1);
                BlockHeader blockHeader = chain.getNewestHeader();
                BlockExtendsData blockRoundData = blockHeader.getExtendsData();
                if (blockRoundData.getRoundIndex() < lastRound.getIndex()) {
                    roundList.clear();
                    this.initRound(chain);
                }
            }
            finally {
                chain.getRoundLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeetingRound getCurrentRound(Chain chain) {
        chain.getRoundLock().lock();
        List<MeetingRound> roundList = chain.getRoundList();
        try {
            if (roundList == null || roundList.size() == 0) {
                MeetingRound meetingRound = null;
                return meetingRound;
            }
            MeetingRound meetingRound = roundList.get(roundList.size() - 1);
            return meetingRound;
        }
        finally {
            chain.getRoundLock().unlock();
        }
    }

    public void initRound(Chain chain) throws Exception {
        MeetingRound currentRound = this.resetRound(chain, false);
        if (currentRound.getPreRound() == null) {
            BlockHeader blockHeader;
            BlockHeader newestHeader = chain.getNewestHeader();
            BlockExtendsData extendsData = newestHeader.getExtendsData();
            List<BlockHeader> blockHeaderList = chain.getBlockHeaderList();
            for (int i = blockHeaderList.size() - 1; i >= 0 && (extendsData = (blockHeader = blockHeaderList.get(i)).getExtendsData()).getRoundIndex() >= currentRound.getIndex(); --i) {
            }
            MeetingRound preRound = this.getRound(chain, extendsData, false);
            currentRound.setPreRound(preRound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeetingRound resetRound(Chain chain, boolean isRealTime) throws Exception {
        chain.getRoundLock().lock();
        try {
            MeetingRound round = this.getCurrentRound(chain);
            if (isRealTime) {
                MeetingRound nextRound;
                if (round == null || round.getEndTime() < NulsDateUtils.getCurrentTimeSeconds()) {
                    nextRound = this.getRound(chain, null, true);
                    nextRound.setPreRound(round);
                    this.addRound(chain, nextRound);
                    round = nextRound;
                }
                nextRound = round;
                return nextRound;
            }
            BlockHeader blockHeader = chain.getNewestHeader();
            BlockExtendsData extendsData = blockHeader.getExtendsData();
            if (round != null && extendsData.getRoundIndex() == round.getIndex() && extendsData.getPackingIndexOfRound() != extendsData.getConsensusMemberCount()) {
                MeetingRound meetingRound = round;
                return meetingRound;
            }
            MeetingRound nextRound = this.getRound(chain, extendsData, false);
            if (round != null && nextRound.getIndex() <= round.getIndex()) {
                MeetingRound meetingRound = nextRound;
                return meetingRound;
            }
            nextRound.setPreRound(round);
            this.addRound(chain, nextRound);
            MeetingRound meetingRound = nextRound;
            return meetingRound;
        }
        finally {
            chain.getRoundLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeetingRound getRound(Chain chain, BlockExtendsData roundData, boolean isRealTime) throws Exception {
        chain.getRoundLock().lock();
        try {
            if (isRealTime && roundData == null) {
                MeetingRound meetingRound = this.getRoundByRealTime(chain);
                return meetingRound;
            }
            if (!isRealTime && roundData == null) {
                MeetingRound meetingRound = this.getRoundByNewestBlock(chain);
                return meetingRound;
            }
            MeetingRound meetingRound = this.getRoundByExpectedRound(chain, roundData);
            return meetingRound;
        }
        finally {
            chain.getRoundLock().unlock();
        }
    }

    public MeetingRound getRoundByTime(Chain chain, long time) throws Exception {
        int blockHeaderSize = chain.getBlockHeaderList().size();
        for (int index = blockHeaderSize - 1; index >= 0; --index) {
            BlockHeader blockHeader = chain.getBlockHeaderList().get(index);
            if (blockHeader.getTime() > time) continue;
            BlockExtendsData blockExtendsData = blockHeader.getExtendsData();
            long roundStartTime = blockExtendsData.getRoundStartTime();
            long roundEndTime = roundStartTime + chain.getConfig().getPackingInterval() * (long)blockExtendsData.getConsensusMemberCount();
            if (roundStartTime > time) continue;
            if (roundEndTime >= time) {
                return this.getRound(chain, blockExtendsData, false);
            }
            for (int realIndex = index + 1; realIndex <= blockHeaderSize - 1; ++realIndex) {
                blockExtendsData.parse(chain.getBlockHeaderList().get(realIndex).getExtend(), 0);
                roundStartTime = blockExtendsData.getRoundStartTime();
                roundEndTime = roundStartTime + chain.getConfig().getPackingInterval() * (long)blockExtendsData.getConsensusMemberCount();
                if (roundStartTime > time) {
                    return null;
                }
                if (roundEndTime < time) continue;
                return this.getRound(chain, blockExtendsData, false);
            }
            return null;
        }
        return null;
    }

    private MeetingRound getRoundByRealTime(Chain chain) throws Exception {
        long startTime;
        long index;
        BlockHeader bestBlockHeader;
        BlockHeader startBlockHeader = bestBlockHeader = chain.getNewestHeader();
        BlockExtendsData bestRoundData = bestBlockHeader.getExtendsData();
        long bestRoundEndTime = bestRoundData.getRoundEndTime(chain.getConfig().getPackingInterval());
        if (startBlockHeader.getHeight() != 0L) {
            long roundIndex = bestRoundData.getRoundIndex();
            if (bestRoundData.getConsensusMemberCount() == bestRoundData.getPackingIndexOfRound() || NulsDateUtils.getCurrentTimeSeconds() >= bestRoundEndTime) {
                ++roundIndex;
            }
            startBlockHeader = this.getFirstBlockOfPreRound(chain, roundIndex);
        }
        long nowTime = NulsDateUtils.getCurrentTimeSeconds();
        long packingInterval = chain.getConfig().getPackingInterval();
        if (nowTime < bestRoundEndTime) {
            index = bestRoundData.getRoundIndex();
            startTime = bestRoundData.getRoundStartTime();
        } else {
            long diffTime = nowTime - bestRoundEndTime;
            int consensusMemberCount = bestRoundData.getConsensusMemberCount();
            if (bestBlockHeader.getHeight() == 0L) {
                consensusMemberCount = chain.getConfig().getSeedNodes().split(",").length;
            }
            int diffRoundCount = (int)(diffTime / ((long)consensusMemberCount * packingInterval));
            index = bestRoundData.getRoundIndex() + (long)diffRoundCount + 1L;
            startTime = bestRoundEndTime + (long)(diffRoundCount * consensusMemberCount) * packingInterval;
        }
        return this.calculationRound(chain, startBlockHeader, index, startTime);
    }

    private MeetingRound getRoundByNewestBlock(Chain chain) throws Exception {
        BlockHeader bestBlockHeader = chain.getNewestHeader();
        BlockExtendsData extendsData = bestBlockHeader.getExtendsData();
        extendsData.setRoundStartTime(extendsData.getRoundEndTime(chain.getConfig().getPackingInterval()));
        extendsData.setRoundIndex(extendsData.getRoundIndex() + 1L);
        return this.getRoundByExpectedRound(chain, extendsData);
    }

    private MeetingRound getRoundByExpectedRound(Chain chain, BlockExtendsData roundData) throws Exception {
        BlockHeader startBlockHeader = chain.getNewestHeader();
        long roundIndex = roundData.getRoundIndex();
        long roundStartTime = roundData.getRoundStartTime();
        if (startBlockHeader.getHeight() != 0L) {
            startBlockHeader = this.getFirstBlockOfPreRound(chain, roundIndex);
        }
        return this.calculationRound(chain, startBlockHeader, roundIndex, roundStartTime);
    }

    public MeetingRound getRoundByRoundIndex(Chain chain, long roundIndex, long roundStartTime) throws Exception {
        BlockHeader startBlockHeader = chain.getNewestHeader();
        if (startBlockHeader.getHeight() != 0L) {
            startBlockHeader = this.getFirstBlockOfPreRound(chain, roundIndex);
        }
        return this.calculationRound(chain, startBlockHeader, roundIndex, roundStartTime);
    }

    private MeetingRound calculationRound(Chain chain, BlockHeader startBlockHeader, long index, long startTime) throws Exception {
        MeetingRound round = new MeetingRound();
        round.setIndex(index);
        round.setStartTime(startTime);
        this.setMemberList(chain, round, startBlockHeader);
        List<byte[]> packingAddressList = CallMethodUtils.getEncryptedAddressList(chain);
        if (!packingAddressList.isEmpty()) {
            round.calcLocalPacker(packingAddressList, chain);
        }
        chain.getLogger().debug("The current round is\uff1a" + round.getIndex() + ";Starting packaging time of the current round\uff1a" + NulsDateUtils.convertDate((Date)new Date(startTime * 1000L)));
        chain.getLogger().debug("\ncalculation||index:{},startTime:{},startHeight:{},hash:{}\n" + round.toString() + "\n\n", new Object[]{index, startTime * 1000L, startBlockHeader.getHeight(), startBlockHeader.getHash()});
        return round;
    }

    private void setMemberList(Chain chain, MeetingRound round, BlockHeader startBlockHeader) throws NulsException {
        ArrayList<MeetingMember> memberList = new ArrayList<MeetingMember>();
        String seedNodesStr = chain.getConfig().getSeedNodes();
        if (StringUtils.isNotBlank((String)seedNodesStr)) {
            String[] seedNodes;
            for (String address : seedNodes = seedNodesStr.split(",")) {
                byte[] addressByte = AddressTool.getAddress((String)address);
                MeetingMember member = new MeetingMember();
                Agent agent = new Agent();
                agent.setAgentAddress(addressByte);
                agent.setPackingAddress(addressByte);
                agent.setRewardAddress(addressByte);
                agent.setCreditVal(0.0);
                agent.setDeposit(BigInteger.ZERO);
                member.setRoundStartTime(round.getStartTime());
                member.setAgent(agent);
                member.setRoundIndex(round.getIndex());
                memberList.add(member);
            }
        }
        List<Agent> agentList = this.getAliveAgentList(chain, startBlockHeader.getHeight());
        for (Agent agent : agentList) {
            Agent realAgent = new Agent();
            try {
                realAgent.parse(agent.serialize(), 0);
                realAgent.setTxHash(agent.getTxHash());
            }
            catch (IOException io) {
                Log.error((Throwable)io);
                return;
            }
            MeetingMember member = new MeetingMember();
            member.setRoundStartTime(round.getStartTime());
            List<Deposit> cdList = this.getDepositListByAgentId(chain, realAgent.getTxHash(), startBlockHeader.getHeight());
            BigInteger totalDeposit = BigInteger.ZERO;
            for (Deposit dtx : cdList) {
                totalDeposit = totalDeposit.add(dtx.getDeposit());
            }
            agent.setTotalDeposit(totalDeposit);
            realAgent.setTotalDeposit(totalDeposit);
            member.setDepositList(cdList);
            member.setRoundIndex(round.getIndex());
            member.setAgent(realAgent);
            boolean isItIn = realAgent.getTotalDeposit().compareTo(chain.getConfig().getCommissionMin()) >= 0;
            if (!isItIn) continue;
            realAgent.setCreditVal(this.calcCreditVal(chain, member, startBlockHeader));
            memberList.add(member);
        }
        round.init(memberList, chain);
    }

    private List<Deposit> getDepositListByAgentId(Chain chain, NulsHash agentHash, long startBlockHeight) {
        List<Deposit> depositList = chain.getDepositList();
        ArrayList<Deposit> resultList = new ArrayList<Deposit>();
        for (int i = depositList.size() - 1; i >= 0; --i) {
            Deposit deposit = depositList.get(i);
            if (deposit.getDelHeight() != -1L && deposit.getDelHeight() <= startBlockHeight || deposit.getBlockHeight() > startBlockHeight || deposit.getBlockHeight() < 0L || !deposit.getAgentHash().equals((Object)agentHash)) continue;
            resultList.add(deposit);
        }
        return resultList;
    }

    private List<Agent> getAliveAgentList(Chain chain, long startBlockHeight) {
        List<Agent> agentList = chain.getAgentList();
        ArrayList<Agent> resultList = new ArrayList<Agent>();
        for (int i = agentList.size() - 1; i >= 0; --i) {
            Agent agent = agentList.get(i);
            this.fixRedPunishBugHelper.v13Filter(chain.getConfig().getChainId(), agent, startBlockHeight);
            if (agent.getDelHeight() != -1L && agent.getDelHeight() <= startBlockHeight || agent.getBlockHeight() > startBlockHeight || agent.getBlockHeight() < 0L) continue;
            resultList.add(agent);
        }
        return resultList;
    }

    private double calcCreditVal(Chain chain, MeetingMember member, BlockHeader blockHeader) throws NulsException {
        BlockExtendsData roundData = blockHeader.getExtendsData();
        long roundStart = roundData.getRoundIndex() - 100L;
        if (roundStart < 0L) {
            roundStart = 0L;
        }
        long blockCount = this.getBlockCountByAddress(chain, member.getAgent().getPackingAddress(), roundStart, roundData.getRoundIndex() - 1L);
        long sumRoundVal = this.getPunishCountByAddress(chain, member.getAgent().getAgentAddress(), roundStart, roundData.getRoundIndex() - 1L, PunishType.YELLOW.getCode());
        double ability = DoubleUtils.div((double)blockCount, (double)100.0);
        double penalty = DoubleUtils.div((double)sumRoundVal, (double)100.0);
        return DoubleUtils.round((double)DoubleUtils.sub((double)ability, (double)penalty), (int)4);
    }

    private long getPunishCountByAddress(Chain chain, byte[] address, long roundStart, long roundEnd, int code) throws NulsException {
        long count = 0L;
        List<PunishLogPo> punishList = chain.getYellowPunishList();
        if (code == PunishType.RED.getCode()) {
            punishList = chain.getRedPunishList();
        }
        for (int i = punishList.size() - 1; i >= 0 && count < 100L; --i) {
            PunishLogPo punish = punishList.get(i);
            if (punish.getRoundIndex() > roundEnd) continue;
            if (punish.getRoundIndex() < roundStart) break;
            if (!Arrays.equals(punish.getAddress(), address)) continue;
            ++count;
        }
        if (count > 100L) {
            return 100L;
        }
        return count;
    }

    public BlockHeader getFirstBlockOfPreRound(Chain chain, long roundIndex) {
        BlockHeader firstBlockHeader = null;
        long startRoundIndex = 0L;
        List<BlockHeader> blockHeaderList = chain.getBlockHeaderList();
        for (int i = blockHeaderList.size() - 1; i >= 0; --i) {
            BlockHeader blockHeader = blockHeaderList.get(i);
            long currentRoundIndex = blockHeader.getExtendsData().getRoundIndex();
            if (roundIndex <= currentRoundIndex) continue;
            if (startRoundIndex == 0L) {
                startRoundIndex = currentRoundIndex;
            }
            if (currentRoundIndex >= startRoundIndex) continue;
            firstBlockHeader = blockHeaderList.get(i + 1);
            BlockExtendsData roundData = firstBlockHeader.getExtendsData();
            if (roundData.getPackingIndexOfRound() <= 1) break;
            firstBlockHeader = blockHeader;
            break;
        }
        if (firstBlockHeader == null) {
            firstBlockHeader = chain.getNewestHeader();
            chain.getLogger().warn("the first block of pre round not found");
        }
        return firstBlockHeader;
    }

    public MeetingRound getPreRound(Chain chain, long roundIndex) throws Exception {
        BlockHeader blockHeader;
        List<BlockHeader> blockHeaderList = chain.getBlockHeaderList();
        BlockExtendsData extendsData = null;
        for (int i = blockHeaderList.size() - 1; i >= 0 && (extendsData = (blockHeader = blockHeaderList.get(i)).getExtendsData()).getRoundIndex() >= roundIndex; --i) {
        }
        if (extendsData == null) {
            return null;
        }
        return this.getRound(chain, extendsData, false);
    }

    private long getBlockCountByAddress(Chain chain, byte[] packingAddress, long roundStart, long roundEnd) {
        long count = 0L;
        List<BlockHeader> blockHeaderList = chain.getBlockHeaderList();
        for (int i = blockHeaderList.size() - 1; i >= 0; --i) {
            BlockHeader blockHeader = blockHeaderList.get(i);
            BlockExtendsData roundData = blockHeader.getExtendsData();
            if (roundData.getRoundIndex() > roundEnd) continue;
            if (roundData.getRoundIndex() < roundStart) break;
            if (!Arrays.equals(blockHeader.getPackingAddress(chain.getConfig().getChainId()), packingAddress)) continue;
            ++count;
        }
        return count;
    }

    public Map<String, List<String>> getAgentChangeInfo(Chain chain, BlockExtendsData lastExtendsData, BlockExtendsData currentExtendsData) {
        List<String> cancelAgentList;
        List<String> registerAgentList;
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(2);
        long lastRoundIndex = -1L;
        if (lastExtendsData != null) {
            lastRoundIndex = lastExtendsData.getRoundIndex();
        }
        long currentRoundIndex = currentExtendsData.getRoundIndex();
        MeetingRound lastRound = null;
        try {
            MeetingRound currentRound;
            if (lastRoundIndex != -1L && (lastRound = this.getRoundByIndex(chain, lastRoundIndex)) == null) {
                lastRound = this.getRound(chain, lastExtendsData, false);
            }
            if ((currentRound = this.getRoundByIndex(chain, currentRoundIndex)) == null) {
                currentRound = this.getRound(chain, currentExtendsData, false);
            }
            registerAgentList = this.getAgentChangeList(lastRound, currentRound, true);
            cancelAgentList = this.getAgentChangeList(lastRound, currentRound, false);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return null;
        }
        resultMap.put("registerAgentList", registerAgentList);
        resultMap.put("cancelAgentList", cancelAgentList);
        return resultMap;
    }

    private List<String> getAgentChangeList(MeetingRound lastRound, MeetingRound currentRound, boolean isRegister) {
        ArrayList<String> lastRoundAgentList = new ArrayList<String>();
        ArrayList<String> currentRoundAgentList = new ArrayList<String>();
        if (lastRound != null) {
            for (MeetingMember member : lastRound.getMemberList()) {
                lastRoundAgentList.add(AddressTool.getStringAddressByBytes((byte[])member.getAgent().getPackingAddress()));
            }
        }
        for (MeetingMember member : currentRound.getMemberList()) {
            currentRoundAgentList.add(AddressTool.getStringAddressByBytes((byte[])member.getAgent().getPackingAddress()));
        }
        if (isRegister) {
            currentRoundAgentList.removeAll(lastRoundAgentList);
            return currentRoundAgentList;
        }
        lastRoundAgentList.removeAll(currentRoundAgentList);
        return lastRoundAgentList;
    }
}

