/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.validator;

import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.CancelDeposit;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.bo.tx.txdata.RedPunishData;
import io.nuls.consensus.model.bo.tx.txdata.StopAgent;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.consensus.storage.DepositStorageService;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Component
public class BatchValidator {
    @Autowired
    private DepositStorageService depositStorageService;
    @Autowired
    private AgentStorageService agentStorageService;
    @Autowired
    private TxValidator txValidator;

    public void batchValid(List<Transaction> txList, Chain chain) throws NulsException {
        if (null == txList || txList.isEmpty()) {
            throw new NulsException(ConsensusErrorCode.TRANSACTION_LIST_IS_NULL);
        }
        txList.sort((tx, compareTx) -> {
            if (tx.getType() == compareTx.getType()) {
                return (int)(tx.getTime() - compareTx.getTime());
            }
            return compareTx.getType() - tx.getType();
        });
        ArrayList<Transaction> redPunishTxs = new ArrayList<Transaction>();
        ArrayList<Transaction> yellowPunishTxs = new ArrayList<Transaction>();
        ArrayList<Transaction> coinBasePunishTxs = new ArrayList<Transaction>();
        ArrayList<Transaction> createAgentTxs = new ArrayList<Transaction>();
        ArrayList<Transaction> stopAgentTxs = new ArrayList<Transaction>();
        ArrayList<Transaction> depositTxs = new ArrayList<Transaction>();
        ArrayList<Transaction> withdrawTxs = new ArrayList<Transaction>();
        for (Transaction tx2 : txList) {
            switch (tx2.getType()) {
                case 8: {
                    redPunishTxs.add(tx2);
                    break;
                }
                case 4: 
                case 20: {
                    createAgentTxs.add(tx2);
                    break;
                }
                case 9: 
                case 23: {
                    stopAgentTxs.add(tx2);
                    break;
                }
                case 5: 
                case 21: {
                    depositTxs.add(tx2);
                    break;
                }
                case 6: 
                case 22: {
                    withdrawTxs.add(tx2);
                    break;
                }
                case 7: {
                    yellowPunishTxs.add(tx2);
                    break;
                }
                case 1: {
                    coinBasePunishTxs.add(tx2);
                    break;
                }
            }
        }
        HashSet<String> redPunishAddressSet = new HashSet();
        HashSet<NulsHash> invalidAgentHash = new HashSet();
        if (!redPunishTxs.isEmpty()) {
            redPunishAddressSet = this.redPunishValid(redPunishTxs);
        }
        if (!redPunishAddressSet.isEmpty() || !createAgentTxs.isEmpty()) {
            this.createAgentValid(createAgentTxs, redPunishAddressSet, chain);
        }
        if (!stopAgentTxs.isEmpty()) {
            this.stopAgentValid(stopAgentTxs, redPunishAddressSet, chain);
        }
        if (!(depositTxs.isEmpty() && withdrawTxs.isEmpty() || redPunishAddressSet.isEmpty() && stopAgentTxs.isEmpty())) {
            invalidAgentHash = this.getInvalidAgentHash(redPunishAddressSet, stopAgentTxs, chain);
        }
        if (!invalidAgentHash.isEmpty() && !depositTxs.isEmpty()) {
            this.depositValid(depositTxs, invalidAgentHash, chain);
        }
        if (!withdrawTxs.isEmpty()) {
            this.withdrawValid(withdrawTxs, invalidAgentHash, chain);
        }
        txList.removeAll(redPunishTxs);
        txList.removeAll(createAgentTxs);
        txList.removeAll(stopAgentTxs);
        txList.removeAll(depositTxs);
        txList.removeAll(withdrawTxs);
        txList.removeAll(yellowPunishTxs);
        txList.removeAll(coinBasePunishTxs);
    }

    private Set<String> redPunishValid(List<Transaction> redPunishTxs) throws NulsException {
        HashSet<String> addressHexSet = new HashSet<String>();
        Iterator<Transaction> iterator = redPunishTxs.iterator();
        RedPunishData redPunishData = new RedPunishData();
        while (iterator.hasNext()) {
            Transaction tx = iterator.next();
            redPunishData.parse(tx.getTxData(), 0);
            String addressHex = HexUtil.encode((byte[])redPunishData.getAddress());
            if (addressHexSet.add(addressHex)) continue;
            iterator.remove();
        }
        return addressHexSet;
    }

    private void createAgentValid(List<Transaction> createTxs, Set<String> redPunishAddressSet, Chain chain) throws NulsException {
        Iterator<Transaction> iterator = createTxs.iterator();
        Agent agent = new Agent();
        HashSet<String> createAgentAddressSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Transaction tx;
            block5: {
                tx = iterator.next();
                try {
                    boolean basicValidResult = this.txValidator.validateTx(chain, tx);
                    if (!basicValidResult) {
                        iterator.remove();
                    }
                    break block5;
                }
                catch (IOException e) {
                    iterator.remove();
                }
                continue;
            }
            agent.parse(tx.getTxData(), 0);
            String agentAddressHex = HexUtil.encode((byte[])agent.getAgentAddress());
            String packAddressHex = HexUtil.encode((byte[])agent.getPackingAddress());
            if (!redPunishAddressSet.isEmpty() && (redPunishAddressSet.contains(agentAddressHex) || redPunishAddressSet.contains(packAddressHex))) {
                iterator.remove();
                continue;
            }
            if (createAgentAddressSet.add(agentAddressHex) && createAgentAddressSet.add(packAddressHex)) continue;
            iterator.remove();
        }
    }

    private void stopAgentValid(List<Transaction> stopAgentTxs, Set<String> redPunishAddressSet, Chain chain) throws NulsException {
        HashSet<NulsHash> hashSet = new HashSet<NulsHash>();
        Iterator<Transaction> iterator = stopAgentTxs.iterator();
        StopAgent stopAgent = new StopAgent();
        Agent agent = new Agent();
        while (iterator.hasNext()) {
            Transaction tx;
            block7: {
                tx = iterator.next();
                try {
                    boolean basicValidResult = this.txValidator.validateTx(chain, tx);
                    if (!basicValidResult) {
                        iterator.remove();
                    }
                    break block7;
                }
                catch (IOException e) {
                    iterator.remove();
                }
                continue;
            }
            stopAgent.parse(tx.getTxData(), 0);
            if (!hashSet.add(stopAgent.getCreateTxHash())) {
                iterator.remove();
                continue;
            }
            if (stopAgent.getAddress() == null) {
                Transaction createAgentTx = CallMethodUtils.getTransaction(chain, stopAgent.getCreateTxHash().toHex());
                if (createAgentTx == null) {
                    iterator.remove();
                    continue;
                }
                agent.parse(createAgentTx.getTxData(), 0);
                stopAgent.setAddress(agent.getAgentAddress());
            }
            if (redPunishAddressSet.isEmpty() || !redPunishAddressSet.contains(HexUtil.encode((byte[])stopAgent.getAddress())) && !redPunishAddressSet.contains(HexUtil.encode((byte[])agent.getPackingAddress()))) continue;
            iterator.remove();
        }
    }

    private void depositValid(List<Transaction> depositTxs, Set<NulsHash> invalidAgentHash, Chain chain) throws NulsException {
        Deposit deposit = new Deposit();
        Iterator<Transaction> iterator = depositTxs.iterator();
        while (iterator.hasNext()) {
            Transaction tx;
            block4: {
                tx = iterator.next();
                try {
                    boolean basicValidResult = this.txValidator.validateTx(chain, tx);
                    if (!basicValidResult) {
                        iterator.remove();
                    }
                    break block4;
                }
                catch (IOException e) {
                    iterator.remove();
                }
                continue;
            }
            deposit.parse(tx.getTxData(), 0);
            if (!invalidAgentHash.contains(deposit.getAgentHash())) continue;
            iterator.remove();
        }
    }

    private void withdrawValid(List<Transaction> withdrawTxs, Set<NulsHash> invalidAgentHash, Chain chain) throws NulsException {
        Iterator<Transaction> iterator = withdrawTxs.iterator();
        CancelDeposit cancelDeposit = new CancelDeposit();
        HashSet<NulsHash> hashSet = new HashSet<NulsHash>();
        int chainId = chain.getConfig().getChainId();
        while (iterator.hasNext()) {
            Transaction tx;
            block6: {
                tx = iterator.next();
                try {
                    boolean basicValidResult = this.txValidator.validateTx(chain, tx);
                    if (!basicValidResult) {
                        iterator.remove();
                    }
                    break block6;
                }
                catch (IOException e) {
                    iterator.remove();
                }
                continue;
            }
            cancelDeposit.parse(tx.getTxData(), 0);
            if (!hashSet.add(cancelDeposit.getJoinTxHash())) {
                iterator.remove();
                continue;
            }
            DepositPo depositPo = this.depositStorageService.get(cancelDeposit.getJoinTxHash(), chainId);
            AgentPo agentPo = this.agentStorageService.get(depositPo.getAgentHash(), chainId);
            if (null == agentPo) {
                iterator.remove();
                continue;
            }
            if (!invalidAgentHash.contains(agentPo.getHash())) continue;
            iterator.remove();
        }
    }

    private Set<NulsHash> getInvalidAgentHash(Set<String> redPunishAddressSet, List<Transaction> stopAgentTxs, Chain chain) throws NulsException {
        HashSet<NulsHash> agentHashSet = new HashSet<NulsHash>();
        List<Agent> agentList = chain.getAgentList();
        long startBlockHeight = chain.getNewestHeader().getHeight();
        if (!redPunishAddressSet.isEmpty()) {
            for (Agent agent : agentList) {
                if (agent.getDelHeight() != -1L && agent.getDelHeight() <= startBlockHeight || agent.getBlockHeight() > startBlockHeight || agent.getBlockHeight() < 0L || !redPunishAddressSet.contains(HexUtil.encode((byte[])agent.getAgentAddress())) && !redPunishAddressSet.contains(HexUtil.encode((byte[])agent.getPackingAddress()))) continue;
                agentHashSet.add(agent.getTxHash());
            }
        }
        if (stopAgentTxs != null) {
            StopAgent stopAgent = new StopAgent();
            for (Transaction tx : stopAgentTxs) {
                stopAgent.parse(tx.getTxData(), 0);
                agentHashSet.add(stopAgent.getCreateTxHash());
            }
        }
        return agentHashSet;
    }
}

