/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.protocol.CommonAdvice;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.protocol.cmd.TransactionDispatcher;
import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractTokenAssetsInfo;
import io.nuls.contract.rpc.call.LedgerCall;
import io.nuls.contract.tx.common.TransactionCommitAdvice;
import io.nuls.contract.tx.common.TransactionRollbackAdvice;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.LogUtil;
import io.nuls.contract.util.VMContext;
import io.nuls.contract.vm.program.ProgramMethod;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.core.io.IoUtils;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.util.AddressPrefixDatas;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Component
public class SmartContractBootStrap
implements INulsCoresBootstrap {
    @Autowired
    private NulsCoresConfig contractConfig;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AddressPrefixDatas addressPrefixDatas;
    @Autowired
    private ContractHelper contractHelper;

    @Override
    public int order() {
        return 7;
    }

    @Override
    public void mainFunction(String[] args) {
        this.init();
    }

    public void init() {
        try {
            SmartContractBootStrap.systemConfig();
            this.initContractDefaultLog();
            this.initNulsConfig();
            this.initDB();
            this.initNRC20Standard();
            this.initNRC721Standard();
            this.initNRC1155Standard();
            this.chainManager.initChain();
        }
        catch (Exception e) {
            Log.error((String)"ContractBootsrap init error!");
            throw new RuntimeException(e);
        }
    }

    private void initNulsConfig() {
        ContractContext.DEFAULT_ENCODING = Charset.forName(this.contractConfig.getEncoding());
        ContractContext.DATA_PATH = this.contractConfig.getDataPath() + File.separator + ModuleE.SC.name;
        ContractContext.MAIN_ASSETS_ID = this.contractConfig.getMainAssetId();
        ContractContext.MAIN_CHAIN_ID = this.contractConfig.getMainChainId();
        ContractContext.LOCAL_CHAIN_ID = this.contractConfig.getChainId();
        ContractContext.LOCAL_MAIN_ASSET_ID = this.contractConfig.getAssetId();
        ContractContext.FEE_ASSETS_SET = this.contractConfig.getFeeAssetsSet();
        if (StringUtils.isNotBlank((String)this.contractConfig.getCrossTokenSystemContract())) {
            ContractContext.CROSS_CHAIN_SYSTEM_CONTRACT = AddressTool.getAddress((String)this.contractConfig.getCrossTokenSystemContract());
        }
        ContractContext.setContractHelper(this.contractHelper);
    }

    private static void systemConfig() throws Exception {
        System.setProperty("protostuff.runtime.allow_null_array_element", "true");
        System.setProperty("file.encoding", StandardCharsets.UTF_8.name());
        Field charset = Charset.class.getDeclaredField("defaultCharset");
        charset.setAccessible(true);
        charset.set(null, StandardCharsets.UTF_8);
    }

    private void initContractDefaultLog() {
        LogUtil.configDefaultLog("smart-contract", this.contractConfig.getPackageLogPackages(), this.contractConfig.getPackageLogLevels());
    }

    private void initNRC20Standard() {
        String json = null;
        try {
            json = IoUtils.read((String)("contract" + File.separator + "nrc20.json"));
        }
        catch (Exception e) {
            Log.error((String)"init NRC20Standard error.", (Throwable)e);
        }
        if (json == null) {
            Log.warn((String)"init NRC20Standard empty data file!");
            return;
        }
        Map jsonMap = null;
        try {
            jsonMap = JSONUtils.json2map((String)json, ProgramMethod.class);
        }
        catch (Exception e) {
            Log.error((String)"init NRC20Standard map error.", (Throwable)e);
        }
        VMContext.setNrc20Methods(jsonMap);
    }

    private void initNRC721Standard() {
        String json = null;
        try {
            json = IoUtils.read((String)("contract" + File.separator + "nrc721.json"));
        }
        catch (Exception e) {
            Log.error((String)"init NRC721Standard error.", (Throwable)e);
        }
        if (json == null) {
            Log.warn((String)"init NRC721Standard empty data file!");
            return;
        }
        Map jsonMap = null;
        try {
            jsonMap = JSONUtils.json2map((String)json, ProgramMethod.class);
        }
        catch (Exception e) {
            Log.error((String)"init NRC721Standard map error.", (Throwable)e);
        }
        VMContext.setNrc721Methods(jsonMap);
    }

    private void initNRC1155Standard() {
        String json = null;
        try {
            json = IoUtils.read((String)("contract" + File.separator + "nrc1155.json"));
        }
        catch (Exception e) {
            Log.error((String)"init NRC1155Standard error.", (Throwable)e);
        }
        if (json == null) {
            Log.warn((String)"init NRC1155Standard empty data file!");
            return;
        }
        Map jsonMap = null;
        try {
            jsonMap = JSONUtils.json2map((String)json, ProgramMethod.class);
        }
        catch (Exception e) {
            Log.error((String)"init NRC20Standard map error.", (Throwable)e);
        }
        VMContext.setNrc1155Methods(jsonMap);
    }

    private void initDB() throws Exception {
        HashSet<CallSite> skipTables = new HashSet<CallSite>();
        skipTables.add((CallSite)((Object)("contract_" + this.contractConfig.getChainId())));
        RocksDBManager.init((String)ContractContext.DATA_PATH, null, skipTables);
        ContractUtil.createTable("contract_config");
    }

    @Override
    public Module moduleInfo() {
        return new Module(ModuleE.SC.abbr, "1.0");
    }

    private boolean doStart() {
        TransactionDispatcher dispatcher = (TransactionDispatcher)SpringLiteContext.getBean(TransactionDispatcher.class);
        TransactionCommitAdvice commitAdvice = (TransactionCommitAdvice)SpringLiteContext.getBean(TransactionCommitAdvice.class);
        TransactionRollbackAdvice rollbackAdvice = (TransactionRollbackAdvice)SpringLiteContext.getBean(TransactionRollbackAdvice.class);
        dispatcher.register(ModuleE.SC, (CommonAdvice)commitAdvice, (CommonAdvice)rollbackAdvice);
        Log.info((String)"module chain do start");
        return true;
    }

    @Override
    public void onDependenciesReady() {
        this.doStart();
        Log.info((String)"all dependency module ready");
        Map<Integer, Chain> chainMap = this.chainManager.getChainMap();
        for (Chain chain : chainMap.values()) {
            int chainId = chain.getChainId();
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) < ContractContext.UPDATE_VERSION_V250) continue;
            try {
                List<Map> regTokenList = LedgerCall.getRegTokenList(chainId);
                if (regTokenList != null && !regTokenList.isEmpty()) {
                    Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = chain.getTokenAssetsInfoMap();
                    Map<String, String> tokenAssetsContractAddressInfoMap = chain.getTokenAssetsContractAddressInfoMap();
                    regTokenList.stream().forEach(map -> {
                        int assetId = Integer.parseInt(map.get("assetId").toString());
                        String tokenContractAddress = map.get("assetOwnerAddress").toString();
                        tokenAssetsInfoMap.put(tokenContractAddress, new ContractTokenAssetsInfo(chainId, assetId));
                        tokenAssetsContractAddressInfoMap.put(chainId + "-" + assetId, tokenContractAddress);
                    });
                }
            }
            catch (NulsException e) {
                throw new RuntimeException(e);
            }
            Log.info((String)"initial cross token asset completed");
        }
    }
}

