/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.helper;

import io.nuls.base.data.Transaction;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.util.ContractUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class ContractConflictChecker {
    private final ReentrantLock lock = new ReentrantLock();
    private List<Set<String>> contractSetList;

    public static ContractConflictChecker newInstance() {
        return new ContractConflictChecker();
    }

    public void add(Set<String> element) {
        this.contractSetList.add(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConflict(int chainId, Transaction tx, ContractResult contractResult, Set<String> commitSet) {
        this.lock.lock();
        try {
            boolean isConflict = false;
            Set<String> collectAddress = ContractUtil.collectAddress(chainId, contractResult);
            for (String address : collectAddress) {
                if (!this.containAddress(address, commitSet)) continue;
                isConflict = true;
                break;
            }
            if (!isConflict && contractResult.isSuccess()) {
                commitSet.addAll(collectAddress);
            }
            boolean bl = isConflict;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean containAddress(String address, Set<String> commitSet) {
        for (Set<String> set : this.contractSetList) {
            if (set == commitSet || !set.contains(address)) continue;
            return true;
        }
        return false;
    }

    public List<Set<String>> getContractSetList() {
        return this.contractSetList;
    }

    public void setContractSetList(List<Set<String>> contractSetList) {
        this.contractSetList = contractSetList;
    }
}

