/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.helper;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.common.NCUtils;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.enums.ContractStatus;
import io.nuls.contract.enums.TokenTypeStatus;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.BatchInfo;
import io.nuls.contract.model.bo.BatchInfoV8;
import io.nuls.contract.model.bo.CallableResult;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.model.bo.ContractCreate;
import io.nuls.contract.model.bo.ContractInternalCreate;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractTokenAssetsInfo;
import io.nuls.contract.model.bo.ContractTokenInfo;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.dto.ContractConstructorInfoDto;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.contract.model.tx.ContractReturnGasTransaction;
import io.nuls.contract.model.txdata.CallContractData;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.rpc.call.BlockCall;
import io.nuls.contract.rpc.call.LedgerCall;
import io.nuls.contract.service.ContractService;
import io.nuls.contract.storage.ContractAddressStorageService;
import io.nuls.contract.storage.ContractRewardLogByConsensusStorageService;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.util.VMContext;
import io.nuls.contract.vm.program.ProgramCall;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.contract.vm.program.ProgramInternalCreate;
import io.nuls.contract.vm.program.ProgramMethod;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.contract.vm.program.ProgramResult;
import io.nuls.contract.vm.program.ProgramStatus;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteArrayWrapper;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.LongUtils;
import io.nuls.core.model.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public class ContractHelper {
    @Autowired
    private VMContext vmContext;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private ContractAddressStorageService contractAddressStorageService;
    @Autowired
    private ContractService contractService;
    @Autowired
    private NulsCoresConfig contractConfig;
    @Autowired
    private ContractRewardLogByConsensusStorageService contractRewardLogByConsensusStorageService;
    private static final BigInteger MAXIMUM_DECIMALS = BigInteger.valueOf(18L);
    private static final BigInteger MAXIMUM_TOTAL_SUPPLY = BigInteger.valueOf(2L).pow(256).subtract(BigInteger.ONE);
    private Set<String> unlockedNrc20Set = new HashSet<String>();

    public ProgramExecutor getProgramExecutor(int chainId) {
        Chain chain = this.getChain(chainId);
        if (chain == null) {
            return null;
        }
        return chain.getProgramExecutor();
    }

    public Chain getChain(int chainId) {
        return this.chainManager.getChainMap().get(chainId);
    }

    public ProgramMethod getMethodInfoByCode(int chainId, String methodName, String methodDesc, byte[] code) {
        if (StringUtils.isBlank((String)methodName) || code == null) {
            return null;
        }
        List<ProgramMethod> methods = this.getAllMethods(chainId, code);
        return this.getMethodInfo(methodName, methodDesc, methods);
    }

    public ContractConstructorInfoDto getConstructor(int chainId, byte[] contractCode) {
        try {
            ContractConstructorInfoDto dto = new ContractConstructorInfoDto();
            List<ProgramMethod> programMethods = this.getAllMethods(chainId, contractCode);
            if (programMethods == null || programMethods.size() == 0) {
                return null;
            }
            for (ProgramMethod method : programMethods) {
                if (!"<init>".equals(method.getName())) continue;
                dto.setConstructor(method);
                break;
            }
            dto.setNrc20(this.checkTokenContract(programMethods, null, VMContext.getNrc20Methods().values()));
            return dto;
        }
        catch (Exception e) {
            Log.error(e);
            return null;
        }
    }

    public List<ProgramMethod> getAllMethods(int chainId, byte[] contractCode) {
        return this.getProgramExecutor(chainId).jarMethod(contractCode);
    }

    public byte[] getContractCode(int chainId, byte[] currentStateRoot, byte[] codeAddress) {
        ProgramExecutor track = this.getProgramExecutor(chainId).begin(currentStateRoot);
        return track.contractCode(codeAddress);
    }

    public byte[] getContractCodeHash(int chainId, byte[] currentStateRoot, byte[] codeAddress) {
        ProgramExecutor track = this.getProgramExecutor(chainId).begin(currentStateRoot);
        return track.contractCodeHash(codeAddress);
    }

    private ProgramMethod getMethodInfo(String methodName, String methodDesc, List<ProgramMethod> methods) {
        if (methods != null && methods.size() > 0) {
            boolean emptyDesc = StringUtils.isBlank((String)methodDesc);
            for (ProgramMethod method : methods) {
                if (!methodName.equals(method.getName())) continue;
                if (emptyDesc) {
                    return method;
                }
                if (!methodDesc.equals(method.getDesc())) continue;
                return method;
            }
        }
        return null;
    }

    public ProgramMethod getMethodInfoByContractAddress(int chainId, byte[] currentStateRoot, String methodName, String methodDesc, byte[] contractAddressBytes) {
        if (StringUtils.isBlank((String)methodName)) {
            return null;
        }
        ProgramExecutor track = this.getProgramExecutor(chainId).begin(currentStateRoot);
        List<ProgramMethod> methods = track.method(contractAddressBytes);
        return this.getMethodInfo(methodName, methodDesc, methods);
    }

    private boolean checkTokenContract(List<ProgramMethod> methods, Map<String, ProgramMethod> contractMethodsMap, Collection<ProgramMethod> tokenStandardProgramMethods) {
        if (methods == null || methods.size() == 0) {
            return false;
        }
        if (contractMethodsMap == null) {
            contractMethodsMap = new HashMap<String, ProgramMethod>(methods.size());
        }
        for (ProgramMethod method : methods) {
            contractMethodsMap.put(ContractUtil.methodSignature(method), method);
        }
        for (ProgramMethod standardMethod : tokenStandardProgramMethods) {
            ProgramMethod mappingMethod = contractMethodsMap.get(ContractUtil.methodSignature(standardMethod));
            if (mappingMethod == null) {
                return false;
            }
            if (standardMethod.equalsTokenMethod(mappingMethod)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAcceptDirectTransfer(List<ProgramMethod> methods) {
        if (methods == null || methods.size() == 0) {
            return false;
        }
        for (ProgramMethod method : methods) {
            if (!"_payable".equals(method.getName()) || !"() return void".equals(method.getDesc())) continue;
            return method.isPayable();
        }
        return false;
    }

    public ProgramResult invokeViewMethod(int chainId, byte[] contractAddressBytes, String methodName, String methodDesc, Object ... args) {
        return this.invokeViewMethod(chainId, contractAddressBytes, methodName, methodDesc, ContractUtil.twoDimensionalArray(args));
    }

    public ProgramResult invokeViewMethod(int chainId, byte[] contractAddressBytes, String methodName, String methodDesc, String[][] args) {
        BlockHeader blockHeader;
        try {
            blockHeader = BlockCall.getLatestBlockHeader(chainId);
        }
        catch (NulsException e) {
            Log.error(e);
            return ProgramResult.getFailed(e.getMessage());
        }
        if (blockHeader == null) {
            return ProgramResult.getFailed("block header is null.");
        }
        long blockHeight = blockHeader.getHeight();
        byte[] currentStateRoot = ContractUtil.getStateRoot(blockHeader);
        return this.invokeViewMethod(chainId, null, false, currentStateRoot, blockHeight, contractAddressBytes, methodName, methodDesc, args);
    }

    public ProgramResult invokeCustomGasViewMethod(int chainId, BlockHeader blockHeader, byte[] contractAddressBytes, String methodName, String methodDesc, String[][] args) {
        if (blockHeader == null) {
            return ProgramResult.getFailed("block header is null.");
        }
        long blockHeight = blockHeader.getHeight();
        byte[] currentStateRoot = ContractUtil.getStateRoot(blockHeader);
        return this.invokeViewMethod(chainId, null, true, currentStateRoot, blockHeight, contractAddressBytes, methodName, methodDesc, args);
    }

    private ProgramResult invokeViewMethod(int chainId, ProgramExecutor executor, byte[] stateRoot, long blockHeight, byte[] contractAddressBytes, String methodName, String methodDesc, Object ... args) {
        return this.invokeViewMethod(chainId, executor, false, stateRoot, blockHeight, contractAddressBytes, methodName, methodDesc, ContractUtil.twoDimensionalArray(args));
    }

    public ProgramResult invokeViewMethod(int chainId, byte[] stateRoot, long blockHeight, byte[] contractAddressBytes, String methodName, String methodDesc, String[][] args) {
        return this.invokeViewMethod(chainId, null, false, stateRoot, blockHeight, contractAddressBytes, methodName, methodDesc, args);
    }

    public ProgramResult invokeViewMethod(int chainId, ProgramExecutor executor, boolean isCustomGasLimit, byte[] stateRoot, long blockHeight, byte[] contractAddressBytes, String methodName, String methodDesc, String[][] args) {
        long gasLimit = isCustomGasLimit ? this.vmContext.getCustomMaxViewGasLimit(chainId) : 10000000L;
        ProgramCall programCall = new ProgramCall();
        programCall.setContractAddress(contractAddressBytes);
        programCall.setValue(BigInteger.ZERO);
        programCall.setGasLimit(gasLimit);
        programCall.setPrice(1L);
        programCall.setNumber(blockHeight);
        programCall.setMethodName(methodName);
        programCall.setMethodDesc(methodDesc);
        programCall.setArgs(args);
        programCall.setViewMethod(isCustomGasLimit);
        ProgramExecutor track = executor == null ? this.getProgramExecutor(chainId).begin(stateRoot) : executor.startTracking();
        ProgramResult programResult = track.call(programCall);
        return programResult;
    }

    public Result validateNrc20Contract(int chainId, ProgramExecutor track, ContractWrapperTransaction tx, ContractResult contractResult) {
        ContractData createContractData = tx.getContractData();
        byte[] contractCode = createContractData.getCode();
        return this.validateNrc20Contract(chainId, track, contractResult.getContractAddress(), contractCode, contractResult);
    }

    public Result validateNrc20ContractByInternalCreate(int chainId, ProgramExecutor track, ProgramInternalCreate internalCreate, ContractResult contractResult) {
        Result result = this.validateNrc20Contract(chainId, track, internalCreate.getContractAddress(), internalCreate.getContractCode(), contractResult);
        if (result.isSuccess()) {
            ContractInternalCreate create = new ContractInternalCreate();
            create.setSender(internalCreate.getSender());
            create.setContractAddress(internalCreate.getContractAddress());
            create.setCodeCopyBy(internalCreate.getCodeCopyBy());
            create.setArgs(internalCreate.getArgs());
            create.setAcceptDirectTransfer(contractResult.isAcceptDirectTransfer());
            create.setTokenType(contractResult.getTokenType());
            create.setTokenName(contractResult.getTokenName());
            create.setTokenSymbol(contractResult.getTokenSymbol());
            create.setTokenDecimals(contractResult.getTokenDecimals());
            create.setTokenTotalSupply(contractResult.getTokenTotalSupply());
            contractResult.getInternalCreates().add(create);
        } else {
            contractResult.getInternalCreates().clear();
        }
        contractResult.setAcceptDirectTransfer(false);
        contractResult.setTokenType(TokenTypeStatus.NOT_TOKEN.status());
        contractResult.setTokenName(null);
        contractResult.setTokenSymbol(null);
        contractResult.setTokenDecimals(0);
        contractResult.setTokenTotalSupply(null);
        return result;
    }

    private boolean validTokenNameOrSymbol(int chainId, String name) {
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_14) {
            if (StringUtils.isBlank((String)name)) {
                return false;
            }
            String upperCaseName = name.toUpperCase();
            if (upperCaseName.equals("NULS")) {
                return false;
            }
            byte[] aliasBytes = name.getBytes(StandardCharsets.UTF_8);
            if (aliasBytes.length < 1 || aliasBytes.length > 20) {
                return false;
            }
            return name.matches("^([a-zA-Z0-9]+[a-zA-Z0-9_]*[a-zA-Z0-9]+)|[a-zA-Z0-9]+${1,20}");
        }
        return FormatValidUtils.validTokenNameOrSymbol((String)name);
    }

    public Result validateNrc20Contract(int chainId, ProgramExecutor track, byte[] contractAddress, byte[] contractCode, ContractResult contractResult) {
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_16) {
            return this.validateNrc20ContractP16(chainId, track, contractAddress, contractCode, contractResult);
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_15) {
            return this.validateNrc20ContractP15(chainId, track, contractAddress, contractCode, contractResult);
        }
        return this.validateNrc20ContractP0(chainId, track, contractAddress, contractCode, contractResult);
    }

    private Result validateNrc20ContractP0(int chainId, ProgramExecutor track, byte[] contractAddress, byte[] contractCode, ContractResult contractResult) {
        if (contractResult == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        long bestBlockHeight = this.vmContext.getBestHeight(chainId);
        List<ProgramMethod> methods = this.getAllMethods(chainId, contractCode);
        HashMap<String, ProgramMethod> contractMethodsMap = new HashMap<String, ProgramMethod>();
        boolean isNrc20 = this.checkTokenContract(methods, contractMethodsMap, VMContext.getNrc20Methods().values());
        boolean isNrc721 = false;
        if (!isNrc20) {
            isNrc721 = this.checkTokenContract(methods, contractMethodsMap, VMContext.getNrc721Methods().values());
        }
        if (isNrc20) {
            contractResult.setTokenType(TokenTypeStatus.NRC20.status());
        } else if (isNrc721) {
            contractResult.setTokenType(TokenTypeStatus.NRC721.status());
        }
        boolean isAcceptDirectTransfer = this.checkAcceptDirectTransfer(methods);
        contractResult.setNrc20(isNrc20);
        contractResult.setAcceptDirectTransfer(isAcceptDirectTransfer);
        if (isNrc20 || isNrc721) {
            String symbol;
            String tokenName;
            ProgramResult programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "name", null, null);
            if (programResult.isSuccess() && StringUtils.isNotBlank((String)(tokenName = programResult.getResult()))) {
                if (!this.validTokenNameOrSymbol(chainId, tokenName)) {
                    contractResult.setError(true);
                    contractResult.setErrorMessage("The format of the name is incorrect.");
                    return ContractUtil.getFailed();
                }
                contractResult.setTokenName(tokenName);
            }
            if ((programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "symbol", null, null)).isSuccess() && StringUtils.isNotBlank((String)(symbol = programResult.getResult()))) {
                if (!this.validTokenNameOrSymbol(chainId, symbol)) {
                    contractResult.setError(true);
                    contractResult.setErrorMessage("The format of the symbol is incorrect.");
                    return ContractUtil.getFailed();
                }
                contractResult.setTokenSymbol(symbol);
            }
            if (isNrc20) {
                String totalSupply;
                String decimals;
                programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "decimals", null, null);
                BigInteger decimalsBig = BigInteger.ZERO;
                if (programResult.isSuccess() && StringUtils.isNotBlank((String)(decimals = programResult.getResult()))) {
                    try {
                        decimalsBig = new BigInteger(decimals);
                        if (decimalsBig.compareTo(BigInteger.ZERO) < 0 || decimalsBig.compareTo(MAXIMUM_DECIMALS) > 0) {
                            contractResult.setError(true);
                            contractResult.setErrorMessage("The value of decimals ranges from 0 to 18.");
                            return ContractUtil.getFailed();
                        }
                        contractResult.setTokenDecimals(decimalsBig.intValue());
                    }
                    catch (Exception e) {
                        Log.error("Get nrc20 decimals error.", e);
                    }
                }
                if ((programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "totalSupply", null, null)).isSuccess() && StringUtils.isNotBlank((String)(totalSupply = programResult.getResult()))) {
                    try {
                        BigInteger totalSupplyBig = new BigInteger(totalSupply);
                        if (totalSupplyBig.compareTo(BigInteger.ZERO) <= 0 || totalSupplyBig.compareTo(MAXIMUM_TOTAL_SUPPLY.multiply(BigInteger.TEN.pow(decimalsBig.intValue()))) > 0) {
                            contractResult.setErrorMessage("The value of totalSupply ranges from 1 to 2^256 - 1.");
                            contractResult.setError(true);
                            return ContractUtil.getFailed();
                        }
                        contractResult.setTokenTotalSupply(totalSupplyBig);
                    }
                    catch (Exception e) {
                        Log.error("Get nrc20 totalSupply error.", e);
                    }
                }
            }
        }
        return ContractUtil.getSuccess();
    }

    private Result validateNrc20ContractP15(int chainId, ProgramExecutor track, byte[] contractAddress, byte[] contractCode, ContractResult contractResult) {
        if (contractResult == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        long bestBlockHeight = this.vmContext.getBestHeight(chainId);
        List<ProgramMethod> methods = this.getAllMethods(chainId, contractCode);
        HashMap<String, ProgramMethod> contractMethodsMap = new HashMap<String, ProgramMethod>();
        boolean isNrc20 = this.checkTokenContract(methods, contractMethodsMap, VMContext.getNrc20Methods().values());
        boolean isNrc721 = false;
        if (!isNrc20) {
            isNrc721 = this.checkTokenContract(methods, contractMethodsMap, VMContext.getNrc721Methods().values());
        }
        if (isNrc20) {
            contractResult.setTokenType(TokenTypeStatus.NRC20.status());
        } else if (isNrc721) {
            contractResult.setTokenType(TokenTypeStatus.NRC721.status());
        }
        boolean isAcceptDirectTransfer = this.checkAcceptDirectTransfer(methods);
        contractResult.setNrc20(isNrc20);
        contractResult.setAcceptDirectTransfer(isAcceptDirectTransfer);
        if (isNrc20 || isNrc721) {
            String symbol;
            String tokenName;
            ProgramResult programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "name", null, null);
            if (programResult.isSuccess() && StringUtils.isNotBlank((String)(tokenName = programResult.getResult()))) {
                if (!this.validTokenNameOrSymbol(chainId, tokenName)) {
                    contractResult.setError(true);
                    contractResult.setErrorMessage("The format of the name is incorrect.");
                    return ContractUtil.getFailed();
                }
                contractResult.setTokenName(tokenName);
            }
            if ((programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "symbol", null, null)).isSuccess() && StringUtils.isNotBlank((String)(symbol = programResult.getResult()))) {
                if (!this.validTokenNameOrSymbol(chainId, symbol)) {
                    contractResult.setError(true);
                    contractResult.setErrorMessage("The format of the symbol is incorrect.");
                    return ContractUtil.getFailed();
                }
                contractResult.setTokenSymbol(symbol);
            }
            if (isNrc20) {
                String totalSupply;
                String decimals;
                programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "decimals", null, null);
                BigInteger decimalsBig = BigInteger.ZERO;
                if (programResult.isSuccess() && StringUtils.isNotBlank((String)(decimals = programResult.getResult()))) {
                    try {
                        decimalsBig = new BigInteger(decimals);
                        if (decimalsBig.compareTo(BigInteger.ZERO) < 0 || decimalsBig.compareTo(MAXIMUM_DECIMALS) > 0) {
                            contractResult.setError(true);
                            contractResult.setErrorMessage("The value of decimals ranges from 0 to 18.");
                            return ContractUtil.getFailed();
                        }
                        contractResult.setTokenDecimals(decimalsBig.intValue());
                    }
                    catch (Exception e) {
                        Log.error("Get nrc20 decimals error.", e);
                    }
                }
                if ((programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "totalSupply", null, null)).isSuccess() && StringUtils.isNotBlank((String)(totalSupply = programResult.getResult()))) {
                    try {
                        BigInteger totalSupplyBig = new BigInteger(totalSupply);
                        if (totalSupplyBig.compareTo(BigInteger.ZERO) < 0 || totalSupplyBig.compareTo(MAXIMUM_TOTAL_SUPPLY.multiply(BigInteger.TEN.pow(decimalsBig.intValue()))) > 0) {
                            contractResult.setErrorMessage("The value of totalSupply ranges from 0 to 2^256 - 1.");
                            contractResult.setError(true);
                            return ContractUtil.getFailed();
                        }
                        contractResult.setTokenTotalSupply(totalSupplyBig);
                    }
                    catch (Exception e) {
                        Log.error("Get nrc20 totalSupply error.", e);
                    }
                }
            }
        }
        return ContractUtil.getSuccess();
    }

    private Result validateNrc20ContractP16(int chainId, ProgramExecutor track, byte[] contractAddress, byte[] contractCode, ContractResult contractResult) {
        if (contractResult == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        long bestBlockHeight = this.vmContext.getBestHeight(chainId);
        List<ProgramMethod> methods = this.getAllMethods(chainId, contractCode);
        HashMap<String, ProgramMethod> contractMethodsMap = new HashMap<String, ProgramMethod>();
        boolean isNrc20 = this.checkTokenContract(methods, contractMethodsMap, VMContext.getNrc20Methods().values());
        boolean isNrc721 = false;
        boolean isNrc1155 = false;
        if (!isNrc20) {
            isNrc721 = this.checkTokenContract(methods, contractMethodsMap, VMContext.getNrc721Methods().values());
        }
        if (!isNrc721) {
            isNrc1155 = this.checkTokenContract(methods, contractMethodsMap, VMContext.getNrc1155Methods().values());
        }
        if (isNrc20) {
            contractResult.setTokenType(TokenTypeStatus.NRC20.status());
        } else if (isNrc721) {
            contractResult.setTokenType(TokenTypeStatus.NRC721.status());
        } else if (isNrc1155) {
            contractResult.setTokenType(TokenTypeStatus.NRC1155.status());
        }
        boolean isAcceptDirectTransfer = this.checkAcceptDirectTransfer(methods);
        contractResult.setNrc20(isNrc20);
        contractResult.setAcceptDirectTransfer(isAcceptDirectTransfer);
        if (isNrc20 || isNrc721 || isNrc1155) {
            String symbol;
            String tokenName;
            ProgramResult programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "name", null, null);
            if (programResult.isSuccess() && StringUtils.isNotBlank((String)(tokenName = programResult.getResult()))) {
                if (!this.validTokenNameOrSymbol(chainId, tokenName)) {
                    contractResult.setError(true);
                    contractResult.setErrorMessage("The format of the name is incorrect.");
                    return ContractUtil.getFailed();
                }
                contractResult.setTokenName(tokenName);
            }
            if ((programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "symbol", null, null)).isSuccess() && StringUtils.isNotBlank((String)(symbol = programResult.getResult()))) {
                if (!this.validTokenNameOrSymbol(chainId, symbol)) {
                    contractResult.setError(true);
                    contractResult.setErrorMessage("The format of the symbol is incorrect.");
                    return ContractUtil.getFailed();
                }
                contractResult.setTokenSymbol(symbol);
            }
            if (isNrc20) {
                String totalSupply;
                String decimals;
                programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "decimals", null, null);
                BigInteger decimalsBig = BigInteger.ZERO;
                if (programResult.isSuccess() && StringUtils.isNotBlank((String)(decimals = programResult.getResult()))) {
                    try {
                        decimalsBig = new BigInteger(decimals);
                        if (decimalsBig.compareTo(BigInteger.ZERO) < 0 || decimalsBig.compareTo(MAXIMUM_DECIMALS) > 0) {
                            contractResult.setError(true);
                            contractResult.setErrorMessage("The value of decimals ranges from 0 to 18.");
                            return ContractUtil.getFailed();
                        }
                        contractResult.setTokenDecimals(decimalsBig.intValue());
                    }
                    catch (Exception e) {
                        Log.error("Get nrc20 decimals error.", e);
                    }
                }
                if ((programResult = this.invokeViewMethod(chainId, track, null, bestBlockHeight, contractAddress, "totalSupply", null, null)).isSuccess() && StringUtils.isNotBlank((String)(totalSupply = programResult.getResult()))) {
                    try {
                        BigInteger totalSupplyBig = new BigInteger(totalSupply);
                        if (totalSupplyBig.compareTo(BigInteger.ZERO) < 0 || totalSupplyBig.compareTo(MAXIMUM_TOTAL_SUPPLY.multiply(BigInteger.TEN.pow(decimalsBig.intValue()))) > 0) {
                            contractResult.setErrorMessage("The value of totalSupply ranges from 0 to 2^256 - 1.");
                            contractResult.setError(true);
                            return ContractUtil.getFailed();
                        }
                        contractResult.setTokenTotalSupply(totalSupplyBig);
                    }
                    catch (Exception e) {
                        Log.error("Get nrc20 totalSupply error.", e);
                    }
                }
            }
        }
        return ContractUtil.getSuccess();
    }

    public ContractBalance getBalance(int chainId, int assetChainId, int assetId, byte[] address) {
        ContractTempBalanceManager tempBalanceManager = ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_BALANCE ? this.getBatchInfoTempBalanceManagerV8(chainId) : this.getBatchInfoTempBalanceManager(chainId);
        if (tempBalanceManager != null) {
            Result<ContractBalance> balance = tempBalanceManager.getBalance(address, assetChainId, assetId);
            if (balance.isSuccess()) {
                return (ContractBalance)balance.getData();
            }
            Log.error("[{}] Get balance error.", AddressTool.getStringAddressByBytes((byte[])address));
        } else {
            ContractBalance realBalance = this.getRealBalance(chainId, assetChainId, assetId, AddressTool.getStringAddressByBytes((byte[])address));
            if (realBalance != null) {
                return realBalance;
            }
        }
        return ContractBalance.newInstance();
    }

    public ContractBalance getRealBalance(int chainId, int assetChainId, int assetId, String address) {
        try {
            Map<String, Object> balance = LedgerCall.getConfirmedBalanceAndNonce(this.getChain(chainId), assetChainId, assetId, address);
            ContractBalance contractBalance = ContractBalance.newInstance();
            contractBalance.setBalance(new BigInteger(balance.get("available").toString()));
            contractBalance.setFreeze(new BigInteger(balance.get("freeze").toString()));
            contractBalance.setNonce((String)balance.get("nonce"));
            return contractBalance;
        }
        catch (NulsException e) {
            Log.error(e);
            return ContractBalance.newInstance();
        }
    }

    public ContractBalance getUnConfirmedBalanceAndNonce(int chainId, int assetChainId, int assetId, String address) {
        try {
            Map<String, Object> balance = LedgerCall.getBalanceAndNonce(this.getChain(chainId), assetChainId, assetId, address);
            ContractBalance contractBalance = ContractBalance.newInstance();
            contractBalance.setBalance(new BigInteger(balance.get("available").toString()));
            contractBalance.setFreeze(new BigInteger(balance.get("freeze").toString()));
            contractBalance.setNonce((String)balance.get("nonce"));
            return contractBalance;
        }
        catch (NulsException e) {
            Log.error(e);
            return ContractBalance.newInstance();
        }
    }

    public void createTempBalanceManagerAndCurrentBlockHeader(int chainId, long number, long blockTime, byte[] packingAddress) {
        ContractTempBalanceManager tempBalanceManager = ContractTempBalanceManager.newInstance(chainId);
        BlockHeader tempHeader = new BlockHeader();
        tempHeader.setHeight(number);
        tempHeader.setTime(blockTime);
        tempHeader.setPackingAddress(packingAddress);
        Chain chain = this.getChain(chainId);
        chain.getBatchInfo().setTempBalanceManager(tempBalanceManager);
        chain.getBatchInfo().setCurrentBlockHeader(tempHeader);
    }

    public ContractTempBalanceManager getBatchInfoTempBalanceManagerV8(int chainId) {
        BatchInfoV8 batchInfo = this.getChain(chainId).getBatchInfoV8();
        if (batchInfo == null) {
            return null;
        }
        return batchInfo.getTempBalanceManager();
    }

    public BlockHeader getBatchInfoCurrentBlockHeaderV8(int chainId) {
        BatchInfoV8 batchInfo = this.getChain(chainId).getBatchInfoV8();
        if (batchInfo == null) {
            return null;
        }
        return batchInfo.getCurrentBlockHeader();
    }

    public ContractTempBalanceManager getBatchInfoTempBalanceManager(int chainId) {
        BatchInfo batchInfo = this.getChain(chainId).getBatchInfo();
        if (batchInfo == null) {
            return null;
        }
        return batchInfo.getTempBalanceManager();
    }

    public BlockHeader getBatchInfoCurrentBlockHeader(int chainId) {
        BatchInfo batchInfo = this.getChain(chainId).getBatchInfo();
        if (batchInfo == null) {
            return null;
        }
        return batchInfo.getCurrentBlockHeader();
    }

    public Result<ContractAddressInfoPo> getContractAddressInfo(int chainId, byte[] contractAddressBytes) {
        return this.contractAddressStorageService.getContractAddressInfo(chainId, contractAddressBytes);
    }

    public Result<ContractTokenInfo> getContractToken(int chainId, BlockHeader blockHeader, String address, String contractAddress) {
        try {
            Result result;
            if (StringUtils.isBlank((String)contractAddress) || StringUtils.isBlank((String)address)) {
                return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
            }
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress) || !AddressTool.validAddress((int)chainId, (String)address)) {
                return Result.getFailed((ErrorCode)ContractErrorCode.ADDRESS_ERROR);
            }
            long blockHeight = blockHeader.getHeight();
            byte[] currentStateRoot = ContractUtil.getStateRoot(blockHeader);
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            Result<ContractAddressInfoPo> contractAddressInfoResult = this.getContractAddressInfo(chainId, contractAddressBytes);
            ContractAddressInfoPo po = (ContractAddressInfoPo)contractAddressInfoResult.getData();
            if (po == null) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            if (!po.isNrc20()) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_NOT_NRC20);
            }
            ProgramResult programResult = this.invokeViewMethod(chainId, null, false, currentStateRoot, blockHeight, contractAddressBytes, "balanceOf", null, ContractUtil.twoDimensionalArray(new Object[]{address}));
            if (!programResult.isSuccess()) {
                result = ContractUtil.getFailed();
                result.setMsg(ContractUtil.simplifyErrorMsg(programResult.getErrorMessage()));
            } else {
                BigInteger lockAmount = BigInteger.ZERO;
                if (!this.unlockedNrc20Set.contains(contractAddress)) {
                    ProgramResult lockedProgramResult = this.invokeViewMethod(chainId, null, false, currentStateRoot, blockHeight, contractAddressBytes, "lockedBalanceOf", null, ContractUtil.twoDimensionalArray(new Object[]{address}));
                    if (!lockedProgramResult.isSuccess()) {
                        String errorMessage = lockedProgramResult.getErrorMessage();
                        if (errorMessage != null && errorMessage.contains("can't find method")) {
                            this.unlockedNrc20Set.add(contractAddress);
                        }
                    } else {
                        lockAmount = new BigInteger(lockedProgramResult.getResult());
                    }
                }
                result = ContractUtil.getSuccess();
                ContractTokenInfo tokenInfo = new ContractTokenInfo(contractAddress, po.getNrc20TokenName(), po.getDecimals(), new BigInteger(programResult.getResult()), po.getNrc20TokenSymbol(), po.getBlockHeight());
                ProgramExecutor track = this.getProgramExecutor(chainId).begin(currentStateRoot);
                tokenInfo.setStatus(ContractStatus.getStatus(track.status(AddressTool.getAddress((String)tokenInfo.getContractAddress())).ordinal()));
                tokenInfo.setLockAmount(lockAmount);
                result.setData((Object)tokenInfo);
            }
            return result;
        }
        catch (Exception e) {
            Log.error("get contract token via VM error.", e);
            return ContractUtil.getFailed();
        }
    }

    public ProgramStatus getContractStatus(int chainId, byte[] stateRoot, byte[] contractAddress) {
        ProgramExecutor track = this.getProgramExecutor(chainId).begin(stateRoot);
        return track.status(contractAddress);
    }

    public ContractResult makeFailedContractResult(int chainId, ContractWrapperTransaction tx, CallableResult callableResult, String errorMsg) {
        ContractResult contractResult = ContractResult.genFailed(tx.getContractData(), errorMsg);
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_14) {
            contractResult.setGasUsed(0L);
        }
        ContractUtil.makeContractResult(tx, contractResult);
        if (callableResult != null) {
            callableResult.putFailed(chainId, contractResult);
        }
        return contractResult;
    }

    public void extractAssetInfoFromCallTransaction(CallContractData contractData, Transaction tx) throws NulsException {
        if (10 == tx.getType()) {
            return;
        }
        CoinData coinData = tx.getCoinDataInstance();
        List<ProgramMultyAssetValue> list = ProtocolGroupManager.getCurrentVersion((int)ContractContext.LOCAL_CHAIN_ID) >= ContractContext.PROTOCOL_20 ? (ContractContext.LOCAL_CHAIN_ID == 2 && !this.contractConfig.isDevMode() && ContractContext.bestHeight() < 10881424L ? ContractUtil.extractMultyAssetInfoFromCallTransactionBeforeP20(coinData) : ContractUtil.extractMultyAssetInfoFromCallTransactionAfterP20(contractData, coinData)) : ContractUtil.extractMultyAssetInfoFromCallTransactionBeforeP20(coinData);
        contractData.setMultyAssetValues(list);
    }

    public ContractReturnGasTransaction makeReturnGasTx(List<ContractResult> resultList, long time) throws Exception {
        if (ProtocolGroupManager.getCurrentVersion((int)ContractContext.LOCAL_CHAIN_ID) >= ContractContext.PROTOCOL_20) {
            if (ContractContext.LOCAL_CHAIN_ID == 2 && !this.contractConfig.isDevMode() && ContractContext.bestHeight() < 10891000L) {
                return this._makeReturnGasTx(resultList, time);
            }
            return this._makeReturnGasTxAfterP20(resultList, time);
        }
        return this._makeReturnGasTx(resultList, time);
    }

    private ContractReturnGasTransaction _makeReturnGasTxAfterP20(List<ContractResult> resultList, long time) throws Exception {
        HashMap<Object, BigInteger> returnMap = new HashMap<Object, BigInteger>();
        for (ContractResult contractResult : resultList) {
            ContractWrapperTransaction wrapperTx = contractResult.getTx();
            if (wrapperTx.getType() == 17 || wrapperTx.getType() == 10) continue;
            CoinData coinData = wrapperTx.getCoinDataInstance();
            BigInteger totalFee = BigInteger.ZERO;
            int[] arr = new int[]{};
            String feeAsset = null;
            for (String key : ContractContext.FEE_ASSETS_SET) {
                if (totalFee.compareTo(BigInteger.ZERO) != 0) break;
                arr = NCUtils.splitTokenId(key);
                feeAsset = key;
                totalFee = coinData.getFeeByAsset(arr[0], arr[1]);
            }
            Chain chain = ContractContext.contractHelper.getChain(ContractContext.LOCAL_CHAIN_ID);
            BigDecimal feeCoefficient = BigDecimal.valueOf(chain.getConfig().getFeeCoefficient(arr[0], arr[1]));
            ContractData contractData = wrapperTx.getContractData();
            long realGasUsed = contractResult.getGasUsed();
            long txGasUsed = contractData.getGasLimit();
            if (txGasUsed <= realGasUsed) continue;
            long returnGas = txGasUsed - realGasUsed;
            BigInteger returnValue = BigDecimal.valueOf(LongUtils.mul((long)returnGas, (long)contractData.getPrice())).multiply(feeCoefficient).toBigInteger();
            String senderKey2 = HexUtil.encode((byte[])contractData.getSender()) + "," + feeAsset;
            BigInteger senderValue2 = (BigInteger)returnMap.get(senderKey2);
            senderValue2 = senderValue2 == null ? returnValue : senderValue2.add(returnValue);
            returnMap.put(senderKey2, senderValue2);
        }
        if (!returnMap.isEmpty()) {
            CoinData coinData = new CoinData();
            List toList = coinData.getTo();
            returnMap.forEach((senderKey, senderValue) -> {
                String[] split = senderKey.split(",");
                int[] assetInfo = NCUtils.splitTokenId(split[1]);
                CoinTo returnCoin = new CoinTo(HexUtil.decode((String)split[0]), assetInfo[0], assetInfo[1], senderValue, 0L);
                toList.add(returnCoin);
            });
            ContractReturnGasTransaction tx = new ContractReturnGasTransaction();
            tx.setTime(time);
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            return tx;
        }
        return null;
    }

    private ContractReturnGasTransaction _makeReturnGasTx(List<ContractResult> resultList, long time) throws IOException {
        HashMap<ByteArrayWrapper, BigInteger> returnMap = new HashMap<ByteArrayWrapper, BigInteger>();
        for (ContractResult contractResult : resultList) {
            ContractWrapperTransaction wrapperTx = contractResult.getTx();
            if (wrapperTx.getType() == 17 || wrapperTx.getType() == 10) continue;
            ContractData contractData = wrapperTx.getContractData();
            long realGasUsed = contractResult.getGasUsed();
            long txGasUsed = contractData.getGasLimit();
            if (txGasUsed <= realGasUsed) continue;
            long returnGas = txGasUsed - realGasUsed;
            BigInteger returnValue = BigInteger.valueOf(LongUtils.mul((long)returnGas, (long)contractData.getPrice()));
            ByteArrayWrapper sender = new ByteArrayWrapper(contractData.getSender());
            BigInteger senderValue = (BigInteger)returnMap.get(sender);
            senderValue = senderValue == null ? returnValue : senderValue.add(returnValue);
            returnMap.put(sender, senderValue);
        }
        if (!returnMap.isEmpty()) {
            CoinData coinData = new CoinData();
            List toList = coinData.getTo();
            Set entries = returnMap.entrySet();
            for (Map.Entry entry : entries) {
                CoinTo returnCoin = new CoinTo(((ByteArrayWrapper)entry.getKey()).getBytes(), ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID, (BigInteger)entry.getValue(), 0L);
                toList.add(returnCoin);
            }
            ContractReturnGasTransaction tx = new ContractReturnGasTransaction();
            tx.setTime(time);
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            return tx;
        }
        return null;
    }

    public Result onCommitForCreateV14(int chainId, BlockHeader blockHeader, ContractCreate contractCreate, NulsHash hash, long txTime, byte[] contractAddress, byte[] sender, byte[] contractCode, String alias, Map<String, ContractAddressInfoPo> infoPoMap) throws Exception {
        long blockHeight = blockHeader.getHeight();
        String contractAddressStr = AddressTool.getStringAddressByBytes((byte[])contractAddress);
        ContractAddressInfoPo info = new ContractAddressInfoPo();
        info.setContractAddress(contractAddress);
        info.setSender(sender);
        info.setCreateTxHash(hash.getBytes());
        info.setAlias(alias);
        info.setCreateTime(txTime);
        info.setBlockHeight(blockHeight);
        boolean isNrc20Contract = TokenTypeStatus.NRC20.status() == contractCreate.getTokenType();
        boolean acceptDirectTransfer = contractCreate.isAcceptDirectTransfer();
        info.setAcceptDirectTransfer(acceptDirectTransfer);
        info.setNrc20(isNrc20Contract);
        info.setTokenType(contractCreate.getTokenType());
        if (contractCreate.getTokenType() != TokenTypeStatus.NOT_TOKEN.status()) {
            String tokenName = contractCreate.getTokenName();
            String tokenSymbol = contractCreate.getTokenSymbol();
            int tokenDecimals = contractCreate.getTokenDecimals();
            BigInteger tokenTotalSupply = contractCreate.getTokenTotalSupply();
            info.setNrc20TokenName(tokenName);
            info.setNrc20TokenSymbol(tokenSymbol);
            if (isNrc20Contract) {
                info.setDecimals(tokenDecimals);
                info.setTotalSupply(tokenTotalSupply);
                List<ProgramMethod> methods = this.getAllMethods(chainId, contractCode);
                boolean isNewNrc20 = false;
                for (ProgramMethod method : methods) {
                    if (!"transferCrossChain".equals(method.getName()) || !"(String to, BigInteger value) return boolean".equals(method.getDesc())) continue;
                    isNewNrc20 = true;
                    break;
                }
                if (isNewNrc20) {
                    Log.info("CROSS-NRC20-TOKEN contract [{}] Register contract assets with the ledger", contractAddressStr);
                    Map resultMap = LedgerCall.commitNRC20Assets(chainId, tokenName, tokenSymbol, (short)tokenDecimals, tokenTotalSupply, contractAddressStr);
                    if (resultMap != null) {
                        int assetId = Integer.parseInt(resultMap.get("assetId").toString());
                        Chain chain = this.getChain(chainId);
                        Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = chain.getTokenAssetsInfoMap();
                        Map<String, String> tokenAssetsContractAddressInfoMap = chain.getTokenAssetsContractAddressInfoMap();
                        tokenAssetsInfoMap.put(contractAddressStr, new ContractTokenAssetsInfo(chainId, assetId));
                        tokenAssetsContractAddressInfoMap.put(chainId + "-" + assetId, contractAddressStr);
                    }
                }
            }
        }
        infoPoMap.put(contractAddressStr, info);
        return this.contractAddressStorageService.saveContractAddress(chainId, contractAddress, info);
    }

    public Result onRollbackForCreateV14(int chainId, byte[] contractAddress, boolean isNrc20) throws Exception {
        String contractAddressStr = AddressTool.getStringAddressByBytes((byte[])contractAddress);
        if (isNrc20) {
            LedgerCall.rollBackNRC20Assets(chainId, AddressTool.getStringAddressByBytes((byte[])contractAddress));
            Chain chain = this.getChain(chainId);
            Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = chain.getTokenAssetsInfoMap();
            ContractTokenAssetsInfo tokenAssetsInfo = tokenAssetsInfoMap.remove(contractAddressStr);
            if (tokenAssetsInfo != null) {
                Map<String, String> tokenAssetsContractAddressInfoMap = chain.getTokenAssetsContractAddressInfoMap();
                tokenAssetsContractAddressInfoMap.remove(chainId + "-" + tokenAssetsInfo.getAssetId());
            }
        }
        Result result = this.contractAddressStorageService.deleteContractAddress(chainId, contractAddress);
        return result;
    }

    public Result onCommitForCreateV16(int chainId, BlockHeader blockHeader, ContractCreate contractCreate, NulsHash hash, long txTime, byte[] contractAddress, byte[] sender, byte[] contractCode, String alias, Map<String, ContractAddressInfoPo> infoPoMap) throws Exception {
        return this.onCommitForCreateV14(chainId, blockHeader, contractCreate, hash, txTime, contractAddress, sender, contractCode, alias, infoPoMap);
    }

    public Result onRollbackForCreateV16(int chainId, byte[] contractAddress, boolean isNrc20) throws Exception {
        return this.onRollbackForCreateV14(chainId, contractAddress, isNrc20);
    }

    public Result saveContractRewardLogByConsensus(int chainId, List<CoinTo> tos) throws Exception {
        return this.contractRewardLogByConsensusStorageService.save(chainId, tos);
    }

    public Result deleteContractRewardLogByConsensus(int chainId, List<CoinTo> tos) throws Exception {
        return this.contractRewardLogByConsensusStorageService.delete(chainId, tos);
    }

    public Set<String> getAssetsAboutContractRewardLogByConsensus(int chainId, byte[] address) {
        return this.contractRewardLogByConsensusStorageService.getAssets(chainId, address);
    }

    public Map<String, String> getAssetsMapAboutContractRewardLogByConsensus(int chainId, byte[] address) {
        return this.contractRewardLogByConsensusStorageService.getAssetsMap(chainId, address);
    }

    public BigInteger getAssetAmountAboutContractRewardLogByConsensus(int chainId, byte[] address, int assetChainId, int assetId) {
        return this.contractRewardLogByConsensusStorageService.getAssetAmount(chainId, address, assetChainId, assetId);
    }
}

