/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.helper;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.util.MapUtil;
import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.program.ProgramAccount;
import io.nuls.contract.vm.program.ProgramNewTx;
import io.nuls.contract.vm.program.impl.ProgramExecutorImpl;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Component
public class ContractNewTxFromOtherModuleHandler {
    @Autowired
    private NulsCoresConfig contractConfig;

    public Transaction updateNonceAndVmBalance(int chainId, byte[] contractAddressBytes, String txHash, String txStr, Frame frame) {
        try {
            int assetId;
            int assetChainId;
            byte[] contractBytes;
            byte[] txBytes = RPCUtil.decode((String)txStr);
            Transaction tx = new Transaction();
            tx.parse(txBytes, 0);
            CoinFrom contractFrom = null;
            CoinData coinData = tx.getCoinDataInstance();
            List fromList = coinData.getFrom();
            boolean existContract = false;
            for (CoinFrom from : fromList) {
                if (!Arrays.equals(contractAddressBytes, from.getAddress())) continue;
                contractFrom = from;
                existContract = true;
                break;
            }
            if (!existContract) {
                throw new RuntimeException("Illegal transaction: contract address must be exist in data of coin-from.");
            }
            boolean isUnlockTx = contractFrom.getLocked() == -1;
            ProgramAccount account = frame.vm.getProgramExecutor().getAccount(contractAddressBytes, contractFrom.getAssetsChainId(), contractFrom.getAssetsId());
            if (!isUnlockTx) {
                byte[] hashBytes = HexUtil.decode((String)txHash);
                byte[] currentNonceBytes = Arrays.copyOfRange(hashBytes, hashBytes.length - 8, hashBytes.length);
                account.setNonce(RPCUtil.encode((byte[])currentNonceBytes));
            }
            LinkedHashMap<String, BigInteger>[] contracts = this.filterContractValue(chainId, List.of(tx));
            LinkedHashMap<String, BigInteger> contractFromValue = contracts[0];
            LinkedHashMap<String, BigInteger> contractFromLockValue = contracts[1];
            LinkedHashMap<String, BigInteger> contractToValue = contracts[2];
            LinkedHashMap<String, BigInteger> contractToLockValue = contracts[3];
            ProgramExecutorImpl programExecutor = frame.vm.getProgramExecutor();
            Set<Map.Entry<String, BigInteger>> lockTos = contractToLockValue.entrySet();
            for (Map.Entry<String, BigInteger> entry : lockTos) {
                String string = entry.getKey();
                String[] stringArray = string.split("_");
                contractBytes = ContractUtil.asBytes(stringArray[0]);
                assetChainId = Integer.parseInt(stringArray[1]);
                assetId = Integer.parseInt(stringArray[2]);
                programExecutor.getAccount(contractBytes, assetChainId, assetId).addFreeze(entry.getValue());
            }
            Set<Map.Entry<String, BigInteger>> _tos = contractToValue.entrySet();
            for (Map.Entry<String, BigInteger> entry : _tos) {
                String string = entry.getKey();
                String[] keySplit = string.split("_");
                contractBytes = ContractUtil.asBytes(keySplit[0]);
                assetChainId = Integer.parseInt(keySplit[1]);
                assetId = Integer.parseInt(keySplit[2]);
                programExecutor.getAccount(contractBytes, assetChainId, assetId).addBalance(entry.getValue());
            }
            Set<Map.Entry<String, BigInteger>> set = contractFromLockValue.entrySet();
            for (Map.Entry<String, BigInteger> entry : set) {
                String key = entry.getKey();
                String[] keySplit = key.split("_");
                contractBytes = ContractUtil.asBytes(keySplit[0]);
                assetChainId = Integer.parseInt(keySplit[1]);
                assetId = Integer.parseInt(keySplit[2]);
                programExecutor.getAccount(contractBytes, assetChainId, assetId).addFreeze(entry.getValue().negate());
            }
            Set<Map.Entry<String, BigInteger>> set2 = contractFromValue.entrySet();
            for (Map.Entry<String, BigInteger> from : set2) {
                String key = from.getKey();
                String[] keySplit = key.split("_");
                contractBytes = ContractUtil.asBytes(keySplit[0]);
                assetChainId = Integer.parseInt(keySplit[1]);
                assetId = Integer.parseInt(keySplit[2]);
                programExecutor.getAccount(contractBytes, assetChainId, assetId).addBalance(from.getValue().negate());
            }
            return tx;
        }
        catch (NulsException e) {
            Log.error(e);
            throw new RuntimeException(e);
        }
    }

    public boolean refreshTempBalance(int chainId, byte[] contractAddressBytes, List<ProgramNewTx> programNewTxList, ContractTempBalanceManager tempBalanceManager) {
        try {
            int assetId;
            int assetChainId;
            byte[] contractBytes;
            List<Transaction> collect = programNewTxList.stream().map(a -> a.getTx()).collect(Collectors.toList());
            LinkedHashMap<String, BigInteger>[] contracts = this.filterContractValue(chainId, collect);
            LinkedHashMap<String, BigInteger> contractFromValue = contracts[0];
            LinkedHashMap<String, BigInteger> contractFromLockValue = contracts[1];
            LinkedHashMap<String, BigInteger> contractToValue = contracts[2];
            LinkedHashMap<String, BigInteger> contractToLockValue = contracts[3];
            Set<Map.Entry<String, BigInteger>> lockTos = contractToLockValue.entrySet();
            for (Map.Entry<String, BigInteger> entry : lockTos) {
                String string = entry.getKey();
                String[] stringArray = string.split("_");
                contractBytes = ContractUtil.asBytes(stringArray[0]);
                assetChainId = Integer.parseInt(stringArray[1]);
                assetId = Integer.parseInt(stringArray[2]);
                tempBalanceManager.getBalance(contractBytes, assetChainId, assetId);
                tempBalanceManager.addLockedTempBalance(contractBytes, entry.getValue(), assetChainId, assetId);
            }
            Set<Map.Entry<String, BigInteger>> tos = contractToValue.entrySet();
            for (Map.Entry<String, BigInteger> entry : tos) {
                String string = entry.getKey();
                String[] keySplit = string.split("_");
                contractBytes = ContractUtil.asBytes(keySplit[0]);
                assetChainId = Integer.parseInt(keySplit[1]);
                assetId = Integer.parseInt(keySplit[2]);
                tempBalanceManager.getBalance(contractBytes, assetChainId, assetId);
                tempBalanceManager.addTempBalance(contractBytes, entry.getValue(), assetChainId, assetId);
            }
            Set<Map.Entry<String, BigInteger>> set = contractFromLockValue.entrySet();
            for (Map.Entry<String, BigInteger> entry : set) {
                String key = entry.getKey();
                String[] keySplit = key.split("_");
                contractBytes = ContractUtil.asBytes(keySplit[0]);
                assetChainId = Integer.parseInt(keySplit[1]);
                assetId = Integer.parseInt(keySplit[2]);
                tempBalanceManager.getBalance(contractBytes, assetChainId, assetId);
                tempBalanceManager.minusLockedTempBalance(contractBytes, entry.getValue(), assetChainId, assetId);
            }
            Set<Map.Entry<String, BigInteger>> set2 = contractFromValue.entrySet();
            for (Map.Entry<String, BigInteger> from : set2) {
                String key = from.getKey();
                String[] keySplit = key.split("_");
                contractBytes = ContractUtil.asBytes(keySplit[0]);
                assetChainId = Integer.parseInt(keySplit[1]);
                assetId = Integer.parseInt(keySplit[2]);
                tempBalanceManager.getBalance(contractBytes, assetChainId, assetId);
                tempBalanceManager.minusTempBalance(contractBytes, from.getValue(), assetChainId, assetId);
            }
            return true;
        }
        catch (NulsException e) {
            Log.error(e);
            return false;
        }
    }

    private LinkedHashMap<String, BigInteger>[] filterContractValue(int chainId, List<Transaction> programNewTxList) throws NulsException {
        LinkedHashMap contractFromValue = MapUtil.createLinkedHashMap(4);
        LinkedHashMap contractFromLockValue = MapUtil.createLinkedHashMap(4);
        LinkedHashMap contractToValue = MapUtil.createLinkedHashMap(4);
        LinkedHashMap contractToLockValue = MapUtil.createLinkedHashMap(4);
        LinkedHashMap[] contracts = new LinkedHashMap[]{contractFromValue, contractFromLockValue, contractToValue, contractToLockValue};
        for (Transaction tx : programNewTxList) {
            int assetId;
            int assetChainId;
            long txTime = tx.getTime();
            CoinData coinData = tx.getCoinDataInstance();
            List froms = coinData.getFrom();
            List tos = coinData.getTo();
            for (CoinFrom from : froms) {
                byte[] fromAddress = from.getAddress();
                if (!ContractUtil.isLegalContractAddress(chainId, fromAddress)) continue;
                assetChainId = from.getAssetsChainId();
                assetId = from.getAssetsId();
                if (this.isLockedAmount(txTime, from.getLocked())) {
                    ContractUtil.mapAddBigInteger(contractFromLockValue, fromAddress, assetChainId, assetId, from.getAmount());
                    continue;
                }
                ContractUtil.mapAddBigInteger(contractFromValue, fromAddress, assetChainId, assetId, from.getAmount());
            }
            for (CoinTo to : tos) {
                byte[] toAddress = to.getAddress();
                if (!ContractUtil.isLegalContractAddress(chainId, toAddress)) continue;
                assetChainId = to.getAssetsChainId();
                assetId = to.getAssetsId();
                if (this.isLockedAmount(txTime, to.getLockTime())) {
                    ContractUtil.mapAddBigInteger(contractToLockValue, toAddress, assetChainId, assetId, to.getAmount());
                    continue;
                }
                ContractUtil.mapAddBigInteger(contractToValue, toAddress, assetChainId, assetId, to.getAmount());
            }
        }
        return contracts;
    }

    private boolean isLockedAmount(long time, long lockTime) {
        if (lockTime < 0L) {
            return true;
        }
        return time < lockTime;
    }

    public boolean rollbackTempBalance(int chainId, byte[] contractAddressBytes, List<ProgramNewTx> programNewTxList, ContractTempBalanceManager tempBalanceManager) {
        try {
            int assetId;
            int assetChainId;
            byte[] contractBytes;
            List<Transaction> collect = programNewTxList.stream().map(a -> a.getTx()).collect(Collectors.toList());
            LinkedHashMap<String, BigInteger>[] contracts = this.filterContractValue(chainId, collect);
            LinkedHashMap<String, BigInteger> contractFromValue = contracts[0];
            LinkedHashMap<String, BigInteger> contractFromLockValue = contracts[1];
            LinkedHashMap<String, BigInteger> contractToValue = contracts[2];
            LinkedHashMap<String, BigInteger> contractToLockValue = contracts[3];
            Set<Map.Entry<String, BigInteger>> froms = contractFromValue.entrySet();
            for (Map.Entry<String, BigInteger> from : froms) {
                String string = from.getKey();
                String[] stringArray = string.split("_");
                contractBytes = ContractUtil.asBytes(stringArray[0]);
                ContractBalance balance = (ContractBalance)tempBalanceManager.getBalance(contractBytes, assetChainId = Integer.parseInt(stringArray[1]), assetId = Integer.parseInt(stringArray[2])).getData();
                if (StringUtils.isNotBlank((CharSequence)balance.getPreNonce())) {
                    balance.setNonce(balance.getPreNonce());
                }
                tempBalanceManager.addTempBalance(contractBytes, (BigInteger)from.getValue(), assetChainId, assetId);
            }
            Set<Map.Entry<String, BigInteger>> lockFroms = contractFromLockValue.entrySet();
            for (Map.Entry entry : lockFroms) {
                String string = (String)entry.getKey();
                String[] keySplit = string.split("_");
                contractBytes = ContractUtil.asBytes(keySplit[0]);
                ContractBalance balance = (ContractBalance)tempBalanceManager.getBalance(contractBytes, assetChainId = Integer.parseInt(keySplit[1]), assetId = Integer.parseInt(keySplit[2])).getData();
                if (StringUtils.isNotBlank((CharSequence)balance.getPreNonce())) {
                    balance.setNonce(balance.getPreNonce());
                }
                tempBalanceManager.addLockedTempBalance(contractBytes, (BigInteger)entry.getValue(), assetChainId, assetId);
            }
            Set<Map.Entry<String, BigInteger>> tos = contractToValue.entrySet();
            for (Map.Entry<String, BigInteger> entry : tos) {
                String key = entry.getKey();
                String[] keySplit = key.split("_");
                contractBytes = ContractUtil.asBytes(keySplit[0]);
                assetChainId = Integer.parseInt(keySplit[1]);
                assetId = Integer.parseInt(keySplit[2]);
                tempBalanceManager.getBalance(contractBytes, assetChainId, assetId);
                tempBalanceManager.minusTempBalance(contractBytes, entry.getValue(), assetChainId, assetId);
            }
            Set<Map.Entry<String, BigInteger>> set = contractToLockValue.entrySet();
            for (Map.Entry<String, BigInteger> lockTo : set) {
                String key = lockTo.getKey();
                String[] keySplit = key.split("_");
                contractBytes = ContractUtil.asBytes(keySplit[0]);
                assetChainId = Integer.parseInt(keySplit[1]);
                assetId = Integer.parseInt(keySplit[2]);
                tempBalanceManager.getBalance(contractBytes, assetChainId, assetId);
                tempBalanceManager.minusLockedTempBalance(contractBytes, lockTo.getValue(), assetChainId, assetId);
            }
            return true;
        }
        catch (NulsException e) {
            Log.error(e);
            return false;
        }
    }
}

