/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.helper;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.constant.ContractConstant;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.model.bo.ContractMergedTransfer;
import io.nuls.contract.model.bo.ContractMultyAssetMergedTransfer;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.bo.MultyAssetOutput;
import io.nuls.contract.model.bo.Output;
import io.nuls.contract.model.tx.ContractTransferTransaction;
import io.nuls.contract.model.txdata.ContractTransferData;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.util.MapUtil;
import io.nuls.contract.vm.program.ProgramTransfer;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@Component
public class ContractTransferHandler {
    @Autowired
    private ContractHelper contractHelper;

    public boolean refreshTempBalance(int chainId, List<ProgramTransfer> transfers, ContractTempBalanceManager tempBalanceManager) {
        try {
            if (transfers != null && transfers.size() > 0) {
                int assetId;
                int assetChainId;
                byte[] contractBytes;
                LinkedHashMap<String, BigInteger>[] contracts = this.filterContractValue(chainId, transfers);
                LinkedHashMap<String, BigInteger> contractFromValue = contracts[0];
                LinkedHashMap<String, BigInteger> contractToValue = contracts[1];
                LinkedHashMap<String, BigInteger> contractToLockValue = contracts[2];
                Set<Map.Entry<String, BigInteger>> lockTos = contractToLockValue.entrySet();
                for (Map.Entry<String, BigInteger> entry : lockTos) {
                    String string = entry.getKey();
                    String[] keySplit = string.split("_");
                    contractBytes = ContractUtil.asBytes(keySplit[0]);
                    assetChainId = Integer.parseInt(keySplit[1]);
                    assetId = Integer.parseInt(keySplit[2]);
                    tempBalanceManager.getBalance(contractBytes, assetChainId, assetId);
                    tempBalanceManager.addLockedTempBalance(contractBytes, entry.getValue(), assetChainId, assetId);
                }
                Set<Map.Entry<String, BigInteger>> tos = contractToValue.entrySet();
                for (Map.Entry<String, BigInteger> entry : tos) {
                    String key = entry.getKey();
                    String[] keySplit = key.split("_");
                    contractBytes = ContractUtil.asBytes(keySplit[0]);
                    assetChainId = Integer.parseInt(keySplit[1]);
                    assetId = Integer.parseInt(keySplit[2]);
                    tempBalanceManager.getBalance(contractBytes, assetChainId, assetId);
                    tempBalanceManager.addTempBalance(contractBytes, entry.getValue(), assetChainId, assetId);
                }
                Set<Map.Entry<String, BigInteger>> set = contractFromValue.entrySet();
                for (Map.Entry<String, BigInteger> from : set) {
                    String key = from.getKey();
                    String[] keySplit = key.split("_");
                    contractBytes = ContractUtil.asBytes(keySplit[0]);
                    ContractBalance balance = (ContractBalance)tempBalanceManager.getBalance(contractBytes, assetChainId = Integer.parseInt(keySplit[1]), assetId = Integer.parseInt(keySplit[2])).getData();
                    if (StringUtils.isBlank((CharSequence)balance.getPreNonce())) {
                        balance.setPreNonce(balance.getNonce());
                    }
                    tempBalanceManager.minusTempBalance(contractBytes, from.getValue(), assetChainId, assetId);
                }
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    public boolean rollbackContractTempBalance(int chainId, List<ProgramTransfer> transfers, ContractTempBalanceManager tempBalanceManager) {
        try {
            if (transfers != null && transfers.size() > 0) {
                int assetId;
                int assetChainId;
                byte[] contractBytes;
                LinkedHashMap<String, BigInteger>[] contracts = this.filterContractValue(chainId, transfers);
                LinkedHashMap<String, BigInteger> contractFromValue = contracts[0];
                LinkedHashMap<String, BigInteger> contractToValue = contracts[1];
                LinkedHashMap<String, BigInteger> contractToLockValue = contracts[2];
                Set<Map.Entry<String, BigInteger>> froms = contractFromValue.entrySet();
                for (Map.Entry<String, BigInteger> from : froms) {
                    String string = from.getKey();
                    String[] keySplit = string.split("_");
                    contractBytes = ContractUtil.asBytes(keySplit[0]);
                    ContractBalance balance = (ContractBalance)tempBalanceManager.getBalance(contractBytes, assetChainId = Integer.parseInt(keySplit[1]), assetId = Integer.parseInt(keySplit[2])).getData();
                    if (StringUtils.isNotBlank((CharSequence)balance.getPreNonce())) {
                        balance.setNonce(balance.getPreNonce());
                    }
                    tempBalanceManager.addTempBalance(contractBytes, (BigInteger)from.getValue(), assetChainId, assetId);
                }
                Set<Map.Entry<String, BigInteger>> tos = contractToValue.entrySet();
                for (Map.Entry entry : tos) {
                    String key = (String)entry.getKey();
                    String[] keySplit = key.split("_");
                    contractBytes = ContractUtil.asBytes(keySplit[0]);
                    assetChainId = Integer.parseInt(keySplit[1]);
                    assetId = Integer.parseInt(keySplit[2]);
                    tempBalanceManager.minusTempBalance(contractBytes, (BigInteger)entry.getValue(), assetChainId, assetId);
                }
                Set<Map.Entry<String, BigInteger>> lockTos = contractToLockValue.entrySet();
                for (Map.Entry<String, BigInteger> lockTo : lockTos) {
                    String key = lockTo.getKey();
                    String[] keySplit = key.split("_");
                    contractBytes = ContractUtil.asBytes(keySplit[0]);
                    assetChainId = Integer.parseInt(keySplit[1]);
                    assetId = Integer.parseInt(keySplit[2]);
                    tempBalanceManager.getBalance(contractBytes, assetChainId, assetId);
                    tempBalanceManager.minusLockedTempBalance(contractBytes, lockTo.getValue(), assetChainId, assetId);
                }
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    private LinkedHashMap<String, BigInteger>[] filterContractValue(int chainId, List<ProgramTransfer> transfers) {
        LinkedHashMap contractFromValue = MapUtil.createLinkedHashMap(4);
        LinkedHashMap contractToValue = MapUtil.createLinkedHashMap(4);
        LinkedHashMap contractToLockValue = MapUtil.createLinkedHashMap(4);
        LinkedHashMap[] contracts = new LinkedHashMap[]{contractFromValue, contractToValue, contractToLockValue};
        for (ProgramTransfer transfer : transfers) {
            boolean lock;
            byte[] from = transfer.getFrom();
            byte[] to = transfer.getTo();
            BigInteger transferValue = transfer.getValue();
            int assetChainId = transfer.getAssetChainId();
            int assetId = transfer.getAssetId();
            boolean bl = lock = transfer.getLockedTime() > 0L;
            if (ContractUtil.isLegalContractAddress(chainId, from)) {
                ContractUtil.mapAddBigInteger(contractFromValue, from, assetChainId, assetId, transferValue);
            }
            if (!ContractUtil.isLegalContractAddress(chainId, to)) continue;
            if (lock) {
                ContractUtil.mapAddBigInteger(contractToLockValue, to, assetChainId, assetId, transferValue);
                continue;
            }
            ContractUtil.mapAddBigInteger(contractToValue, to, assetChainId, assetId, transferValue);
        }
        return contracts;
    }

    public boolean handleContractTransferTxs(int chainId, long blockTime, ContractResult contractResult, ContractTempBalanceManager tempBalanceManager) {
        boolean isCorrectContractTransfer = true;
        List<ProgramTransfer> transfers = contractResult.getTransfers();
        if (transfers != null && transfers.size() > 0) {
            Result result = ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_22 ? this.verifyTransferP22(transfers) : this.verifyTransfer(transfers);
            if (result.isFailed()) {
                isCorrectContractTransfer = false;
            } else {
                try {
                    this.mergeContractTransfer(contractResult, chainId, blockTime, tempBalanceManager);
                }
                catch (Exception e) {
                    isCorrectContractTransfer = false;
                    Log.error(e);
                }
            }
            if (!isCorrectContractTransfer) {
                Log.warn("contract transfer execution failed, reason: {}", contractResult.getErrorMessage());
                contractResult.setError(true);
                contractResult.setErrorMessage(result.getErrorCode().getMsg());
                this.rollbackContractTempBalance(chainId, contractResult.getTransfers(), tempBalanceManager);
                transfers.clear();
            }
        }
        return isCorrectContractTransfer;
    }

    private Result verifyTransfer(List<ProgramTransfer> transfers) {
        if (transfers == null || transfers.size() == 0) {
            return ContractUtil.getSuccess();
        }
        for (ProgramTransfer transfer : transfers) {
            if (transfer.getAssetChainId() != ContractContext.LOCAL_CHAIN_ID || transfer.getAssetId() != ContractContext.LOCAL_MAIN_ASSET_ID || transfer.getValue().compareTo(ContractConstant.MININUM_TRANSFER_AMOUNT) >= 0) continue;
            return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
        }
        return ContractUtil.getSuccess();
    }

    private Result verifyTransferP22(List<ProgramTransfer> transfers) {
        return ContractUtil.getSuccess();
    }

    private void mergeContractTransfer(ContractResult contractResult, int chainId, long blockTime, ContractTempBalanceManager tempBalanceManager) throws Exception {
        ContractWrapperTransaction tx = contractResult.getTx();
        List<ProgramTransfer> transfers = contractResult.getTransfers();
        byte[] contractAddress = contractResult.getContractAddress();
        ArrayList<ContractTransferTransaction> contractTransferList = new ArrayList<ContractTransferTransaction>();
        contractResult.setContractTransferList(contractTransferList);
        ContractTransferData txData = new ContractTransferData(tx.getHash(), contractAddress);
        HashMap mergeCoinToMap = MapUtil.createHashMap(transfers.size());
        CoinData coinData = null;
        CoinFrom coinFrom = null;
        String compareFrom = null;
        ContractTransferTransaction contractTransferTx = null;
        ContractBalance contractBalance = null;
        HashMap<String, ContractTransferTransaction> preTx = new HashMap<String, ContractTransferTransaction>();
        HashMap<String, ContractBalance> preBalance = new HashMap<String, ContractBalance>();
        for (ProgramTransfer transfer : transfers) {
            byte[] from = transfer.getFrom();
            byte[] to = transfer.getTo();
            BigInteger value = transfer.getValue();
            int assetChainId = transfer.getAssetChainId();
            int assetId = transfer.getAssetId();
            long lockedTime = transfer.getLockedTime();
            String wrapperFrom = ContractUtil.addressKey(from, assetChainId, assetId);
            if (compareFrom == null || !compareFrom.equals(wrapperFrom)) {
                byte[] nonceBytes;
                if (compareFrom == null) {
                    contractBalance = (ContractBalance)tempBalanceManager.getBalance(from, assetChainId, assetId).getData();
                    nonceBytes = RPCUtil.decode((String)contractBalance.getNonce());
                } else {
                    this.updatePreTxHashAndAccountNonce((ContractTransferTransaction)((Object)preTx.get(compareFrom)), (ContractBalance)preBalance.get(compareFrom));
                    mergeCoinToMap.clear();
                    contractBalance = (ContractBalance)tempBalanceManager.getBalance(from, assetChainId, assetId).getData();
                    nonceBytes = RPCUtil.decode((String)contractBalance.getNonce());
                }
                Log.info("From is {}, assetChainId is {}, assetId is {}, nonce is {}", AddressTool.getStringAddressByBytes((byte[])from), assetChainId, assetId, contractBalance.getNonce());
                compareFrom = wrapperFrom;
                coinData = new CoinData();
                coinFrom = new CoinFrom(from, assetChainId, assetId, value, nonceBytes, 0);
                coinData.getFrom().add(coinFrom);
                CoinTo coinTo = new CoinTo(to, assetChainId, assetId, value, lockedTime == 0L ? lockedTime : blockTime + lockedTime);
                coinData.getTo().add(coinTo);
                mergeCoinToMap.put(ContractUtil.addressLockedKey(to, assetChainId, assetId, lockedTime), coinTo);
                long timeOffset = 0L;
                contractTransferTx = this.createContractTransferTx(coinData, txData, blockTime, timeOffset);
                contractTransferList.add(contractTransferTx);
                preTx.put(wrapperFrom, contractTransferTx);
                preBalance.put(wrapperFrom, contractBalance);
                continue;
            }
            coinFrom.setAmount(coinFrom.getAmount().add(value));
            this.mergeCoinTo(mergeCoinToMap, coinData, to, value, assetChainId, assetId, lockedTime, blockTime);
        }
        this.updatePreTxHashAndAccountNonce(contractTransferTx, contractBalance);
        List<ContractMergedTransfer> mergerdTransferList = this.contractTransfer2mergedTransfer(tx, contractTransferList);
        List<ContractMultyAssetMergedTransfer> mergerdMultyAssetTransferList = this.contractMultyAssetTransfer2mergedTransfer(tx, contractTransferList);
        contractResult.setMergedTransferList(mergerdTransferList);
        contractResult.setMergerdMultyAssetTransferList(mergerdMultyAssetTransferList);
    }

    private void mergeCoinTo(Map<String, CoinTo> mergeCoinToMap, CoinData coinData, byte[] to, BigInteger value, int assetChainId, int assetId, long lockedTime, long blockTime) {
        String key = ContractUtil.addressLockedKey(to, assetChainId, assetId, lockedTime);
        CoinTo coinTo = mergeCoinToMap.get(key);
        if (coinTo != null) {
            coinTo.setAmount(coinTo.getAmount().add(value));
        } else {
            coinTo = new CoinTo(to, assetChainId, assetId, value, lockedTime == 0L ? lockedTime : blockTime + lockedTime);
            coinData.getTo().add(coinTo);
            mergeCoinToMap.put(key, coinTo);
        }
    }

    public List<ContractMultyAssetMergedTransfer> contractMultyAssetTransfer2mergedTransfer(Transaction tx, List<ContractTransferTransaction> transferList) throws NulsException {
        ArrayList<ContractMultyAssetMergedTransfer> resultList = new ArrayList<ContractMultyAssetMergedTransfer>();
        for (ContractTransferTransaction transfer : transferList) {
            CoinData coinData = transfer.getCoinDataObj();
            CoinFrom coinFrom = (CoinFrom)coinData.getFrom().get(0);
            int assetChainId = coinFrom.getAssetsChainId();
            int assetId = coinFrom.getAssetsId();
            if (ContractContext.LOCAL_CHAIN_ID == assetChainId && ContractContext.LOCAL_MAIN_ASSET_ID == assetId) continue;
            resultList.add(this.transformMultyAssetMergedTransfer(tx.getHash(), transfer));
        }
        return resultList;
    }

    public List<ContractMergedTransfer> contractTransfer2mergedTransfer(Transaction tx, List<ContractTransferTransaction> transferList) throws NulsException {
        ArrayList<ContractMergedTransfer> resultList = new ArrayList<ContractMergedTransfer>();
        for (ContractTransferTransaction transfer : transferList) {
            CoinData coinData = transfer.getCoinDataObj();
            CoinFrom coinFrom = (CoinFrom)coinData.getFrom().get(0);
            int assetChainId = coinFrom.getAssetsChainId();
            int assetId = coinFrom.getAssetsId();
            if (ContractContext.LOCAL_CHAIN_ID != assetChainId || ContractContext.LOCAL_MAIN_ASSET_ID != assetId) continue;
            resultList.add(this.transformMergedTransfer(tx.getHash(), transfer));
        }
        return resultList;
    }

    private ContractMultyAssetMergedTransfer transformMultyAssetMergedTransfer(NulsHash orginHash, ContractTransferTransaction transfer) throws NulsException {
        ContractMultyAssetMergedTransfer result = new ContractMultyAssetMergedTransfer();
        CoinData coinData = transfer.getCoinDataObj();
        CoinFrom coinFrom = (CoinFrom)coinData.getFrom().get(0);
        int assetChainId = coinFrom.getAssetsChainId();
        int assetId = coinFrom.getAssetsId();
        result.setFrom(coinFrom.getAddress());
        result.setAssetChainId(assetChainId);
        result.setAssetId(assetId);
        result.setValue(coinFrom.getAmount());
        List toList = coinData.getTo();
        List<MultyAssetOutput> outputs = result.getOutputs();
        for (CoinTo to : toList) {
            MultyAssetOutput output = new MultyAssetOutput();
            output.setTo(to.getAddress());
            output.setValue(to.getAmount());
            output.setAssetChainId(to.getAssetsChainId());
            output.setAssetId(to.getAssetsId());
            output.setLockTime(to.getLockTime());
            outputs.add(output);
        }
        result.setHash(transfer.getHash());
        result.setOrginHash(orginHash);
        return result;
    }

    private ContractMergedTransfer transformMergedTransfer(NulsHash orginHash, ContractTransferTransaction transfer) throws NulsException {
        ContractMergedTransfer result = new ContractMergedTransfer();
        CoinData coinData = transfer.getCoinDataObj();
        CoinFrom coinFrom = (CoinFrom)coinData.getFrom().get(0);
        result.setFrom(coinFrom.getAddress());
        result.setValue(coinFrom.getAmount());
        List toList = coinData.getTo();
        List<Output> outputs = result.getOutputs();
        for (CoinTo to : toList) {
            Output output = new Output();
            output.setTo(to.getAddress());
            output.setValue(to.getAmount());
            output.setLockTime(to.getLockTime());
            outputs.add(output);
        }
        result.setHash(transfer.getHash());
        result.setOrginHash(orginHash);
        return result;
    }

    private void updatePreTxHashAndAccountNonce(ContractTransferTransaction tx, ContractBalance balance) throws IOException {
        tx.serializeData();
        NulsHash hash = NulsHash.calcHash((byte[])tx.serializeForHash());
        byte[] hashBytes = hash.getBytes();
        byte[] currentNonceBytes = Arrays.copyOfRange(hashBytes, hashBytes.length - 8, hashBytes.length);
        balance.setNonce(RPCUtil.encode((byte[])currentNonceBytes));
        tx.setHash(hash);
        Log.info("TxType is {}, hash is {}, nextNonce is {}", tx.getType(), hash.toString(), RPCUtil.encode((byte[])currentNonceBytes));
    }

    private ContractTransferTransaction createContractTransferTx(CoinData coinData, ContractTransferData txData, long blockTime, long timeOffset) {
        ContractTransferTransaction contractTransferTx = new ContractTransferTransaction();
        contractTransferTx.setCoinDataObj(coinData);
        contractTransferTx.setTxDataObj(txData);
        contractTransferTx.setTime(blockTime + timeOffset);
        return contractTransferTx;
    }
}

