/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.manager;

import io.nuls.base.basic.AddressTool;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.ioc.SpringLiteContext;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ContractTempBalanceManager {
    private int chainId;
    private Map<String, ContractBalance> tempBalanceMap;
    private Lock lock = new ReentrantLock();
    private ContractHelper contractHelper;

    public static ContractTempBalanceManager newInstance(int chainId) {
        ContractTempBalanceManager temp = new ContractTempBalanceManager();
        temp.chainId = chainId;
        temp.tempBalanceMap = new HashMap<String, ContractBalance>();
        temp.contractHelper = (ContractHelper)SpringLiteContext.getBean(ContractHelper.class);
        return temp;
    }

    private ContractTempBalanceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<ContractBalance> getBalance(byte[] address, int assetChainId, int assetId) {
        this.lock.lock();
        try {
            if (address == null || address.length != 23) {
                Result result = Result.getFailed((ErrorCode)ContractErrorCode.PARAMETER_ERROR);
                return result;
            }
            String addressKey = this.balanceKey(address, assetChainId, assetId);
            ContractBalance balance = this.tempBalanceMap.get(addressKey);
            if (balance == null) {
                balance = this.contractHelper.getRealBalance(this.chainId, assetChainId, assetId, AddressTool.getStringAddressByBytes((byte[])address));
                this.tempBalanceMap.put(addressKey, balance);
            }
            Result result = ContractUtil.getSuccess().setData((Object)balance);
            return result;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String balanceKey(byte[] address, int assetChainId, int assetId) {
        return new StringBuilder(this.chainId).append(ContractUtil.asString(address)).append("_").append(assetChainId).append("_").append(assetId).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTempBalance(byte[] address, BigInteger amount, int assetChainId, int assetId) {
        this.lock.lock();
        try {
            ContractBalance contractBalance = this.tempBalanceMap.get(this.balanceKey(address, assetChainId, assetId));
            if (contractBalance != null) {
                contractBalance.addTemp(amount);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void minusTempBalance(byte[] address, BigInteger amount, int assetChainId, int assetId) {
        this.lock.lock();
        try {
            ContractBalance contractBalance = this.tempBalanceMap.get(this.balanceKey(address, assetChainId, assetId));
            if (contractBalance != null) {
                contractBalance.minusTemp(amount);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLockedTempBalance(byte[] address, BigInteger amount, int assetChainId, int assetId) {
        this.lock.lock();
        try {
            ContractBalance contractBalance = this.tempBalanceMap.get(this.balanceKey(address, assetChainId, assetId));
            if (contractBalance != null) {
                contractBalance.addLockedTemp(amount);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void minusLockedTempBalance(byte[] address, BigInteger amount, int assetChainId, int assetId) {
        this.lock.lock();
        try {
            ContractBalance contractBalance = this.tempBalanceMap.get(this.balanceKey(address, assetChainId, assetId));
            if (contractBalance != null) {
                contractBalance.minusLockedTemp(amount);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

