/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.manager;

import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.util.MapUtil;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ContractTxCreateUnconfirmedManager {
    private Map<String, Map<String, Map<String, String>>> localUnconfirmedCreateContractTransaction;
    private ReentrantLock lock;
    private int chainId;

    public static ContractTxCreateUnconfirmedManager newInstance(int chainId) {
        ContractTxCreateUnconfirmedManager manager = new ContractTxCreateUnconfirmedManager();
        manager.localUnconfirmedCreateContractTransaction = MapUtil.createLinkedHashMap(4);
        manager.lock = new ReentrantLock();
        manager.chainId = chainId;
        return manager;
    }

    private ContractTxCreateUnconfirmedManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLocalUnconfirmedCreateContractTransaction(String sender, Map<String, String> resultMap, long time) {
        this.lock.lock();
        try {
            LinkedHashMap map = MapUtil.createLinkedHashMap(3);
            map.putAll(resultMap);
            map.put("time", String.valueOf(time));
            String contractAddress = (String)map.get("contractAddress");
            LinkedHashMap unconfirmedOfAccountMap = this.localUnconfirmedCreateContractTransaction.get(sender);
            if (unconfirmedOfAccountMap == null) {
                unconfirmedOfAccountMap = MapUtil.createLinkedHashMap(4);
                unconfirmedOfAccountMap.put(contractAddress, map);
                this.localUnconfirmedCreateContractTransaction.put(sender, unconfirmedOfAccountMap);
            } else {
                unconfirmedOfAccountMap.put(contractAddress, map);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public LinkedList<Map<String, String>> getLocalUnconfirmedCreateContractTransaction(String sender) {
        Map<String, Map<String, String>> unconfirmedOfAccountMap = this.localUnconfirmedCreateContractTransaction.get(sender);
        if (unconfirmedOfAccountMap == null) {
            return null;
        }
        return new LinkedList<Map<String, String>>(unconfirmedOfAccountMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalUnconfirmedCreateContractTransaction(String sender, String contractAddress, ContractResult contractResult) {
        this.lock.lock();
        try {
            Map<String, Map<String, String>> unconfirmedOfAccountMap = this.localUnconfirmedCreateContractTransaction.get(sender);
            if (unconfirmedOfAccountMap == null) {
                return;
            }
            if (contractResult.isSuccess()) {
                unconfirmedOfAccountMap.remove(contractAddress);
            } else {
                Map<String, String> dataMap = unconfirmedOfAccountMap.get(contractAddress);
                if (dataMap != null) {
                    dataMap.put("success", "false");
                    dataMap.put("msg", contractResult.getErrorMessage());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalFailedUnconfirmedCreateContractTransaction(String sender, String contractAddress) {
        this.lock.lock();
        try {
            String success;
            Map<String, Map<String, String>> unconfirmedOfAccountMap = this.localUnconfirmedCreateContractTransaction.get(sender);
            if (unconfirmedOfAccountMap == null) {
                return;
            }
            Map<String, String> dataMap = unconfirmedOfAccountMap.get(contractAddress);
            if (dataMap != null && "false".equals(success = dataMap.get("success"))) {
                unconfirmedOfAccountMap.remove(contractAddress);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

