/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.bo;

import io.nuls.base.data.BlockHeader;
import io.nuls.contract.enums.BatchInfoStatus;
import io.nuls.contract.helper.ContractConflictChecker;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.ContractContainer;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.dto.ContractPackageDto;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.core.model.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BatchInfo {
    private static final long TIME_OUT = 10000L;
    private ContractTempBalanceManager tempBalanceManager;
    private BlockHeader currentBlockHeader;
    private ContractPackageDto contractPackageDto;
    private ProgramExecutor batchExecutor;
    private int txCounter = 0;
    private long height;
    private long beginTime;
    private long beforeEndTime;
    private long gasCostTotal;
    private int txTotal;
    private BatchInfoStatus status;
    private String preStateRoot;
    private LinkedHashMap<String, ContractContainer> contractContainerMap;
    private ContractConflictChecker checker;
    private Future<ContractPackageDto> contractPackageDtoFuture;
    private final ReadWriteLock gasLock = new ReentrantReadWriteLock();
    private final ReentrantLock pendingTxListlock = new ReentrantLock();
    private List<String> pendingTxHashList;
    private Map<String, Future<ContractResult>> contractMap;
    private int serialOrder;

    public BatchInfo(long height) {
        this.height = height;
        this.gasCostTotal = 0L;
        this.txTotal = 0;
        this.beginTime = System.currentTimeMillis();
        this.status = BatchInfoStatus.STARTING;
        this.contractContainerMap = new LinkedHashMap();
        this.pendingTxHashList = new ArrayList<String>();
        this.contractMap = new ConcurrentHashMap<String, Future<ContractResult>>();
        this.serialOrder = 0;
    }

    public boolean hasBegan() {
        return this.status.status() > 0;
    }

    public ContractContainer newOrGetContractContainer(String contractAddress) {
        if (StringUtils.isBlank((String)contractAddress)) {
            return null;
        }
        ContractContainer container = this.contractContainerMap.get(contractAddress);
        if (container == null) {
            HashSet<String> commitSet = new HashSet<String>();
            this.checker.add(commitSet);
            container = new ContractContainer(contractAddress, commitSet, new ArrayList<Future<ContractResult>>());
            this.contractContainerMap.put(contractAddress, container);
        }
        return container;
    }

    public int getAndIncreaseTxCounter() {
        return this.txCounter++;
    }

    public int getSerialOrder() {
        return this.serialOrder;
    }

    public void setSerialOrder(int serialOrder) {
        this.serialOrder = serialOrder;
    }

    public ContractTempBalanceManager getTempBalanceManager() {
        return this.tempBalanceManager;
    }

    public void setTempBalanceManager(ContractTempBalanceManager tempBalanceManager) {
        this.tempBalanceManager = tempBalanceManager;
    }

    public BlockHeader getCurrentBlockHeader() {
        return this.currentBlockHeader;
    }

    public void setCurrentBlockHeader(BlockHeader currentBlockHeader) {
        this.currentBlockHeader = currentBlockHeader;
    }

    public ContractPackageDto getContractPackageDto() {
        return this.contractPackageDto;
    }

    public void setContractPackageDto(ContractPackageDto contractPackageDto) {
        this.contractPackageDto = contractPackageDto;
    }

    public ProgramExecutor getBatchExecutor() {
        return this.batchExecutor;
    }

    public void setBatchExecutor(ProgramExecutor batchExecutor) {
        this.batchExecutor = batchExecutor;
    }

    public int getTxCounter() {
        return this.txCounter;
    }

    public void setTxCounter(int txCounter) {
        this.txCounter = txCounter;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getBeforeEndTime() {
        return this.beforeEndTime;
    }

    public void setBeforeEndTime(long beforeEndTime) {
        this.beforeEndTime = beforeEndTime;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public BatchInfoStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchInfoStatus status) {
        this.status = status;
    }

    public String getPreStateRoot() {
        return this.preStateRoot;
    }

    public void setPreStateRoot(String preStateRoot) {
        this.preStateRoot = preStateRoot;
    }

    public LinkedHashMap<String, ContractContainer> getContractContainerMap() {
        return this.contractContainerMap;
    }

    public void setContractContainerMap(LinkedHashMap<String, ContractContainer> contractContainerMap) {
        this.contractContainerMap = contractContainerMap;
    }

    public ContractConflictChecker getChecker() {
        return this.checker;
    }

    public void setChecker(ContractConflictChecker checker) {
        this.checker = checker;
    }

    public Future<ContractPackageDto> getContractPackageDtoFuture() {
        return this.contractPackageDtoFuture;
    }

    public void setContractPackageDtoFuture(Future<ContractPackageDto> contractPackageDtoFuture) {
        this.contractPackageDtoFuture = contractPackageDtoFuture;
    }

    public Map<String, Future<ContractResult>> getContractMap() {
        return this.contractMap;
    }

    public void setContractMap(Map<String, Future<ContractResult>> contractMap) {
        this.contractMap = contractMap;
    }

    public long getGasCostTotal() {
        return this.gasCostTotal;
    }

    public List<String> getPendingTxHashList() {
        return this.pendingTxHashList;
    }

    public void addPendingTxHashList(String txHash) {
        this.pendingTxListlock.lock();
        try {
            this.pendingTxHashList.add(txHash);
        }
        finally {
            this.pendingTxListlock.unlock();
        }
    }

    public boolean checkGasCostTotal(String txHash) {
        this.gasLock.readLock().lock();
        try {
            if (this.isExceed()) {
                this.addPendingTxHashList(txHash);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.gasLock.readLock().unlock();
        }
    }

    public boolean isExceed() {
        boolean exceedGas;
        boolean exceedTx = this.txTotal > 600;
        boolean bl = exceedGas = this.gasCostTotal > 13000000L;
        return exceedTx || exceedGas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGasCostTotal(long gasCost, String txHash) {
        this.gasLock.writeLock().lock();
        try {
            if (this.isExceed()) {
                this.addPendingTxHashList(txHash);
                boolean bl = false;
                return bl;
            }
            ++this.txTotal;
            this.gasCostTotal += gasCost;
            if (this.isExceed()) {
                this.addPendingTxHashList(txHash);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.gasLock.writeLock().unlock();
        }
    }
}

