/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.bo;

import io.nuls.contract.enums.ContractStatus;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.exception.NulsException;
import java.math.BigInteger;

public class ContractTokenInfo {
    private String contractAddress;
    private String name;
    private String symbol;
    private BigInteger amount;
    private BigInteger lockAmount;
    private long decimals;
    private long blockHeight;
    private ContractStatus status;

    public ContractTokenInfo() {
    }

    public ContractTokenInfo(String contractAddress, String name, long decimals, BigInteger amount, String symbol, long blockHeight) {
        this.name = name;
        this.amount = amount;
        this.lockAmount = BigInteger.ZERO;
        this.contractAddress = contractAddress;
        this.decimals = decimals;
        this.symbol = symbol;
        this.blockHeight = blockHeight;
    }

    public BigInteger getLockAmount() {
        return this.lockAmount;
    }

    public void setLockAmount(BigInteger lockAmount) {
        this.lockAmount = lockAmount;
    }

    public ContractTokenInfo setName(String name) {
        this.name = name;
        return this;
    }

    public ContractTokenInfo setAmount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    public boolean isLock(int chainId) throws NulsException {
        return ContractUtil.isLockContract(chainId, this.blockHeight);
    }

    public boolean isStop() {
        return ContractUtil.isTerminatedContract(this.status.status());
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public long getDecimals() {
        return this.decimals;
    }

    public void setDecimals(long decimals) {
        this.decimals = decimals;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public ContractStatus getStatus() {
        return this.status;
    }

    public void setStatus(ContractStatus status) {
        this.status = status;
    }
}

