/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.data.BlockHeader;
import io.nuls.contract.util.ContractUtil;
import java.io.Serializable;

public class BlockHeaderDto
implements Serializable {
    private String hash;
    private String preHash;
    private long time;
    private long height;
    private long txCount;
    private byte[] packingAddress;
    private byte[] stateRoot;

    public BlockHeaderDto() {
    }

    public BlockHeaderDto(int chainId, BlockHeader header) {
        this.hash = header.getPreHash() == null ? null : header.getHash().toHex();
        this.preHash = header.getPreHash() == null ? null : header.getPreHash().toHex();
        this.time = header.getTime();
        this.height = header.getHeight();
        this.txCount = header.getTxCount();
        this.packingAddress = header.getPackingAddress(chainId);
        this.stateRoot = ContractUtil.getStateRoot(header);
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getPreHash() {
        return this.preHash;
    }

    public void setPreHash(String preHash) {
        this.preHash = preHash;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getTxCount() {
        return this.txCount;
    }

    public void setTxCount(long txCount) {
        this.txCount = txCount;
    }

    public byte[] getPackingAddress() {
        return this.packingAddress;
    }

    public void setPackingAddress(byte[] packingAddress) {
        this.packingAddress = packingAddress;
    }

    public byte[] getStateRoot() {
        return this.stateRoot;
    }

    public void setStateRoot(byte[] stateRoot) {
        this.stateRoot = stateRoot;
    }
}

