/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.contract.model.bo.ContractTokenInfo;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel(name="Contract Token Details")
public class ContractTokenInfoDto {
    @ApiModelProperty(description="Contract address")
    private String contractAddress;
    @ApiModelProperty(description="tokenname")
    private String name;
    @ApiModelProperty(description="tokensymbol")
    private String symbol;
    @ApiModelProperty(description="tokenAvailable quantity")
    private String amount;
    @ApiModelProperty(description="tokenLock quantity")
    private String lockAmount;
    @ApiModelProperty(description="tokenSupported Decimal Places")
    private long decimals;
    @ApiModelProperty(description="Block height during contract creation")
    private long blockHeight;
    @ApiModelProperty(description="Contract status(0-Not present, 1-normal, 2-termination)")
    private int status;

    public ContractTokenInfoDto() {
    }

    public ContractTokenInfoDto(ContractTokenInfo info) {
        this.contractAddress = info.getContractAddress();
        this.name = info.getName();
        this.symbol = info.getSymbol();
        this.amount = ContractUtil.bigInteger2String(info.getAmount());
        this.lockAmount = ContractUtil.bigInteger2String(info.getLockAmount());
        this.decimals = info.getDecimals();
        this.blockHeight = info.getBlockHeight();
        this.status = info.getStatus().status();
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getLockAmount() {
        return this.lockAmount;
    }

    public void setLockAmount(String lockAmount) {
        this.lockAmount = lockAmount;
    }

    public long getDecimals() {
        return this.decimals;
    }

    public void setDecimals(long decimals) {
        this.decimals = decimals;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

