/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.contract.model.po.ContractTokenTransferInfoPo;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class ContractTokenTransferTransactionDto {
    @ApiModelProperty(description="Contract address")
    private String contractAddress;
    @ApiModelProperty(description="Payer")
    private String from;
    @ApiModelProperty(description="Payee")
    private String to;
    @ApiModelProperty(description="Transfer amount")
    private String value;
    @ApiModelProperty(description="Transaction time")
    private long time;
    @ApiModelProperty(description="Transaction status\uff080 - Confirming, 1 - Confirmed, 2 - fail\uff09")
    private byte status;
    @ApiModelProperty(description="transactionhash")
    private String txHash;
    @ApiModelProperty(description="block height")
    private long blockHeight;
    @ApiModelProperty(description="tokenname")
    private String name;
    @ApiModelProperty(description="tokensymbol")
    private String symbol;
    @ApiModelProperty(description="tokenSupported Decimal Places")
    private long decimals;
    @ApiModelProperty(description="tokenAsset change information")
    private String info;

    public ContractTokenTransferTransactionDto(ContractTokenTransferInfoPo po, byte[] address) {
        this.contractAddress = po.getContractAddress();
        if (po.getFrom() != null) {
            this.from = AddressTool.getStringAddressByBytes((byte[])po.getFrom());
        }
        if (po.getTo() != null) {
            this.to = AddressTool.getStringAddressByBytes((byte[])po.getTo());
        }
        this.value = ContractUtil.bigInteger2String(po.getValue());
        this.time = po.getTime();
        this.status = po.getStatus();
        this.txHash = HexUtil.encode((byte[])po.getTxHash());
        this.blockHeight = po.getBlockHeight();
        this.name = po.getName();
        this.symbol = po.getSymbol();
        this.decimals = po.getDecimals();
        this.info = po.getInfo(address);
    }

    public int compareTo(long thatTime) {
        if (this.time > thatTime) {
            return -1;
        }
        if (this.time < thatTime) {
            return 1;
        }
        return 0;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public long getDecimals() {
        return this.decimals;
    }

    public void setDecimals(long decimals) {
        this.decimals = decimals;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }
}

