/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.model.txdata.CreateContractData;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class CreateContractDataDto {
    @ApiModelProperty(description="Transaction creator address")
    private String sender;
    @ApiModelProperty(description="Contract address created")
    private String contractAddress;
    @ApiModelProperty(description="Contract alias")
    private String alias;
    @ApiModelProperty(description="Smart Contract Code(BytecodeHexEncoding string)")
    private String hexCode;
    @ApiModelProperty(description="GASlimit")
    private long gasLimit;
    @ApiModelProperty(description="GASunit price")
    private long price;
    @ApiModelProperty(description="parameter list")
    private String[][] args;

    public CreateContractDataDto(ContractData contractData) {
        CreateContractData create = (CreateContractData)contractData;
        this.sender = AddressTool.getStringAddressByBytes((byte[])create.getSender());
        this.contractAddress = AddressTool.getStringAddressByBytes((byte[])create.getContractAddress());
        this.alias = create.getAlias();
        this.hexCode = HexUtil.encode((byte[])create.getCode());
        this.gasLimit = create.getGasLimit();
        this.price = create.getPrice();
        this.args = create.getArgs();
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getHexCode() {
        return this.hexCode;
    }

    public void setHexCode(String hexCode) {
        this.hexCode = hexCode;
    }

    public long getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(long gasLimit) {
        this.gasLimit = gasLimit;
    }

    public long getPrice() {
        return this.price;
    }

    public void setPrice(long price) {
        this.price = price;
    }

    public String[][] getArgs() {
        return this.args;
    }

    public void setArgs(String[][] args) {
        this.args = args;
    }
}

