/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.processor;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.contract.enums.TokenTypeStatus;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.model.bo.ContractInternalCreate;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.dto.CallContractDataDto;
import io.nuls.contract.model.dto.ContractResultDto;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.contract.model.txdata.CallContractData;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.service.ContractService;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.parse.JSONUtils;
import java.util.HashMap;
import java.util.List;

@Component
public class CallContractTxProcessor {
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractService contractService;

    public Result onCommit(int chainId, ContractWrapperTransaction tx) {
        try {
            BlockHeader blockHeader = this.contractHelper.getBatchInfoCurrentBlockHeader(chainId);
            long blockHeight = blockHeader.getHeight();
            ContractResult contractResult = tx.getContractResult();
            contractResult.setBlockHeight(blockHeight);
            ContractData callContractData = tx.getContractData();
            byte[] contractAddress = callContractData.getContractAddress();
            Result<ContractAddressInfoPo> contractAddressInfoPoResult = this.contractHelper.getContractAddressInfo(chainId, contractAddress);
            ContractAddressInfoPo contractAddressInfoPo = (ContractAddressInfoPo)contractAddressInfoPoResult.getData();
            contractResult.setNrc20(contractAddressInfoPo.isNrc20());
            tx.setBlockHeight(blockHeight);
            return this.contractService.saveContractExecuteResult(chainId, tx.getHash(), contractResult);
        }
        catch (Exception e) {
            Log.error("save call contract tx error.", e);
            return ContractUtil.getFailed();
        }
    }

    public Result onRollback(int chainId, ContractWrapperTransaction tx) {
        try {
            ContractResult contractResult = tx.getContractResult();
            if (contractResult == null) {
                contractResult = this.contractService.getContractExecuteResult(chainId, tx.getHash());
            }
            if (contractResult == null) {
                return ContractUtil.getSuccess();
            }
            try {
                CallContractData contractData = (CallContractData)tx.getContractData();
                Log.info("rollback call tx, contract data is {}, result is {}", JSONUtils.obj2json((Object)new CallContractDataDto(contractData)), JSONUtils.obj2json((Object)new ContractResultDto(chainId, contractResult, contractData.getGasLimit())));
            }
            catch (Exception e) {
                Log.warn("failed to trace call rollback log, error is {}", e.getMessage());
            }
            return this.contractService.deleteContractExecuteResult(chainId, tx.getHash());
        }
        catch (Exception e) {
            Log.error("rollback call contract tx error.", e);
            return ContractUtil.getFailed();
        }
    }

    public Result onCommitV8(int chainId, ContractWrapperTransaction tx) {
        try {
            BlockHeader blockHeader = this.contractHelper.getBatchInfoCurrentBlockHeaderV8(chainId);
            long blockHeight = blockHeader.getHeight();
            ContractResult contractResult = tx.getContractResult();
            contractResult.setBlockHeight(blockHeight);
            ContractData callContractData = tx.getContractData();
            byte[] contractAddress = callContractData.getContractAddress();
            Result<ContractAddressInfoPo> contractAddressInfoPoResult = this.contractHelper.getContractAddressInfo(chainId, contractAddress);
            ContractAddressInfoPo contractAddressInfoPo = (ContractAddressInfoPo)contractAddressInfoPoResult.getData();
            contractResult.setNrc20(contractAddressInfoPo.isNrc20());
            tx.setBlockHeight(blockHeight);
            return this.contractService.saveContractExecuteResult(chainId, tx.getHash(), contractResult);
        }
        catch (Exception e) {
            Log.error("save call contract tx error.", e);
            return ContractUtil.getFailed();
        }
    }

    public Result onRollbackV8(int chainId, ContractWrapperTransaction tx) {
        try {
            ContractResult contractResult = tx.getContractResult();
            if (contractResult == null) {
                contractResult = this.contractService.getContractExecuteResult(chainId, tx.getHash());
            }
            if (contractResult == null) {
                return ContractUtil.getSuccess();
            }
            try {
                CallContractData contractData = (CallContractData)tx.getContractData();
                Log.info("rollback call tx, contract data is {}, result is {}", JSONUtils.obj2json((Object)new CallContractDataDto(contractData)), JSONUtils.obj2json((Object)new ContractResultDto(chainId, contractResult, contractData.getGasLimit())));
            }
            catch (Exception e) {
                Log.warn("failed to trace call rollback log, error is {}", e.getMessage());
            }
            return this.contractService.deleteContractExecuteResult(chainId, tx.getHash());
        }
        catch (Exception e) {
            Log.error("rollback call contract tx error.", e);
            return ContractUtil.getFailed();
        }
    }

    public Result onCommitV14(int chainId, ContractWrapperTransaction tx) {
        try {
            BlockHeader blockHeader = this.contractHelper.getBatchInfoCurrentBlockHeaderV8(chainId);
            byte[] stateRoot = blockHeader.getStateRoot();
            long blockHeight = blockHeader.getHeight();
            ContractResult contractResult = tx.getContractResult();
            contractResult.setBlockHeight(blockHeight);
            ContractData callContractData = tx.getContractData();
            byte[] contractAddress = callContractData.getContractAddress();
            String contractAddressStr = AddressTool.getStringAddressByBytes((byte[])contractAddress);
            Result<ContractAddressInfoPo> contractAddressInfoPoResult = this.contractHelper.getContractAddressInfo(chainId, contractAddress);
            ContractAddressInfoPo contractAddressInfoPo = (ContractAddressInfoPo)contractAddressInfoPoResult.getData();
            contractResult.setNrc20(contractAddressInfoPo.isNrc20());
            tx.setBlockHeight(blockHeight);
            HashMap<String, ContractAddressInfoPo> infoPoMap = new HashMap<String, ContractAddressInfoPo>();
            infoPoMap.put(contractAddressStr, contractAddressInfoPo);
            List<ContractInternalCreate> internalCreates = contractResult.getInternalCreates();
            if (internalCreates != null && !internalCreates.isEmpty()) {
                for (ContractInternalCreate internalCreate : internalCreates) {
                    Result result = this.contractHelper.onCommitForCreateV14(chainId, blockHeader, internalCreate, tx.getHash(), tx.getTime(), internalCreate.getContractAddress(), internalCreate.getSender(), this.contractHelper.getContractCode(chainId, stateRoot, internalCreate.getCodeCopyBy()), "internal_create", infoPoMap);
                    if (!result.isFailed()) continue;
                    return result;
                }
            }
            return this.contractService.saveContractExecuteResult(chainId, tx.getHash(), contractResult);
        }
        catch (Exception e) {
            Log.error("save call contract tx error.", e);
            return ContractUtil.getFailed();
        }
    }

    public Result onRollbackV14(int chainId, ContractWrapperTransaction tx) {
        try {
            ContractResult contractResult = tx.getContractResult();
            if (contractResult == null) {
                contractResult = this.contractService.getContractExecuteResult(chainId, tx.getHash());
            }
            if (contractResult == null) {
                return ContractUtil.getSuccess();
            }
            try {
                CallContractData contractData = (CallContractData)tx.getContractData();
                Log.info("rollback call tx, contract data is {}, result is {}", JSONUtils.obj2json((Object)new CallContractDataDto(contractData)), JSONUtils.obj2json((Object)new ContractResultDto(chainId, contractResult, contractData.getGasLimit())));
            }
            catch (Exception e) {
                Log.warn("failed to trace call rollback log, error is {}", e.getMessage());
            }
            List<ContractInternalCreate> internalCreates = contractResult.getInternalCreates();
            if (internalCreates != null && !internalCreates.isEmpty()) {
                for (ContractInternalCreate internalCreate : internalCreates) {
                    Result result = this.contractHelper.onRollbackForCreateV14(chainId, internalCreate.getContractAddress(), internalCreate.getTokenType() == TokenTypeStatus.NRC20.status());
                    if (!result.isFailed()) continue;
                    return result;
                }
            }
            return this.contractService.deleteContractExecuteResult(chainId, tx.getHash());
        }
        catch (Exception e) {
            Log.error("rollback call contract tx error.", e);
            return ContractUtil.getFailed();
        }
    }
}

