/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.processor;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.enums.TokenTypeStatus;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractCreate;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractTokenAssetsInfo;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.dto.ContractResultDto;
import io.nuls.contract.model.dto.CreateContractDataDto;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.model.txdata.CreateContractData;
import io.nuls.contract.rpc.call.LedgerCall;
import io.nuls.contract.service.ContractService;
import io.nuls.contract.service.ContractTxService;
import io.nuls.contract.storage.ContractAddressStorageService;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramMethod;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.parse.JSONUtils;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class CreateContractTxProcessor {
    @Autowired
    private ContractAddressStorageService contractAddressStorageService;
    @Autowired
    private ContractService contractService;
    @Autowired
    private ContractTxService contractTxService;
    @Autowired
    private ContractHelper contractHelper;

    public Result onCommit(int chainId, ContractWrapperTransaction tx) throws Exception {
        BlockHeader blockHeader = this.contractHelper.getBatchInfoCurrentBlockHeader(chainId);
        long blockHeight = blockHeader.getHeight();
        ContractResult contractResult = tx.getContractResult();
        contractResult.setBlockHeight(blockHeight);
        Result saveContractExecuteResult = this.contractService.saveContractExecuteResult(chainId, tx.getHash(), contractResult);
        if (saveContractExecuteResult.isFailed()) {
            return saveContractExecuteResult;
        }
        CreateContractData txData = (CreateContractData)tx.getContractData();
        byte[] contractAddress = txData.getContractAddress();
        byte[] sender = txData.getSender();
        String senderStr = AddressTool.getStringAddressByBytes((byte[])sender);
        String contractAddressStr = AddressTool.getStringAddressByBytes((byte[])contractAddress);
        this.contractHelper.getChain(chainId).getContractTxCreateUnconfirmedManager().removeLocalUnconfirmedCreateContractTransaction(senderStr, contractAddressStr, contractResult);
        if (!contractResult.isSuccess()) {
            return ContractUtil.getSuccess();
        }
        NulsHash hash = tx.getHash();
        tx.setBlockHeight(blockHeight);
        ContractAddressInfoPo info = new ContractAddressInfoPo();
        info.setContractAddress(contractAddress);
        info.setSender(sender);
        info.setCreateTxHash(hash.getBytes());
        info.setAlias(txData.getAlias());
        info.setCreateTime(tx.getTime());
        info.setBlockHeight(blockHeight);
        boolean isNrc20Contract = contractResult.isNrc20();
        boolean acceptDirectTransfer = contractResult.isAcceptDirectTransfer();
        info.setAcceptDirectTransfer(acceptDirectTransfer);
        info.setNrc20(isNrc20Contract);
        info.setTokenType(contractResult.getTokenType());
        if (isNrc20Contract) {
            String tokenName = contractResult.getTokenName();
            String tokenSymbol = contractResult.getTokenSymbol();
            int tokenDecimals = contractResult.getTokenDecimals();
            BigInteger tokenTotalSupply = contractResult.getTokenTotalSupply();
            info.setNrc20TokenName(tokenName);
            info.setNrc20TokenSymbol(tokenSymbol);
            info.setDecimals(tokenDecimals);
            info.setTotalSupply(tokenTotalSupply);
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_V250) {
                List<ProgramMethod> methods = this.contractHelper.getAllMethods(chainId, txData.getCode());
                boolean isNewNrc20 = false;
                for (ProgramMethod method : methods) {
                    if (!"transferCrossChain".equals(method.getName()) || !"(String to, BigInteger value) return boolean".equals(method.getDesc())) continue;
                    isNewNrc20 = true;
                    break;
                }
                if (isNewNrc20) {
                    Log.info("CROSS-NRC20-TOKEN contract [{}] Register contract assets with the ledger", contractAddressStr);
                    Map resultMap = LedgerCall.commitNRC20Assets(chainId, tokenName, tokenSymbol, (short)tokenDecimals, tokenTotalSupply, contractAddressStr);
                    if (resultMap != null) {
                        int assetId = Integer.parseInt(resultMap.get("assetId").toString());
                        Chain chain = this.contractHelper.getChain(chainId);
                        Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = chain.getTokenAssetsInfoMap();
                        Map<String, String> tokenAssetsContractAddressInfoMap = chain.getTokenAssetsContractAddressInfoMap();
                        tokenAssetsInfoMap.put(contractAddressStr, new ContractTokenAssetsInfo(chainId, assetId));
                        tokenAssetsContractAddressInfoMap.put(chainId + "-" + assetId, contractAddressStr);
                    }
                }
            }
        }
        return this.contractAddressStorageService.saveContractAddress(chainId, contractAddress, info);
    }

    public Result onRollback(int chainId, ContractWrapperTransaction tx) throws Exception {
        Result result;
        ContractData txData = tx.getContractData();
        byte[] contractAddress = txData.getContractAddress();
        ContractResult contractResult = tx.getContractResult();
        if (contractResult == null) {
            contractResult = this.contractService.getContractExecuteResult(chainId, tx.getHash());
        }
        if (contractResult == null) {
            return Result.getSuccess(null);
        }
        try {
            CreateContractData contractData = (CreateContractData)tx.getContractData();
            Log.info("rollback create tx, contract data is {}, result is {}", JSONUtils.obj2json((Object)new CreateContractDataDto(contractData)), JSONUtils.obj2json((Object)new ContractResultDto(chainId, contractResult, contractData.getGasLimit())));
        }
        catch (Exception e) {
            Log.warn("failed to trace create rollback log, error is {}", e.getMessage());
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_V250 && contractResult.isNrc20()) {
            LedgerCall.rollBackNRC20Assets(chainId, AddressTool.getStringAddressByBytes((byte[])contractAddress));
            Chain chain = this.contractHelper.getChain(chainId);
            Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = chain.getTokenAssetsInfoMap();
            ContractTokenAssetsInfo tokenAssetsInfo = tokenAssetsInfoMap.remove(contractAddress);
            if (tokenAssetsInfo != null) {
                Map<String, String> tokenAssetsContractAddressInfoMap = chain.getTokenAssetsContractAddressInfoMap();
                tokenAssetsContractAddressInfoMap.remove(chainId + "-" + tokenAssetsInfo.getAssetId());
            }
        }
        if ((result = this.contractAddressStorageService.deleteContractAddress(chainId, contractAddress)).isFailed()) {
            return result;
        }
        return this.contractService.deleteContractExecuteResult(chainId, tx.getHash());
    }

    public Result onCommitV8(int chainId, ContractWrapperTransaction tx) throws Exception {
        BlockHeader blockHeader = this.contractHelper.getBatchInfoCurrentBlockHeaderV8(chainId);
        long blockHeight = blockHeader.getHeight();
        ContractResult contractResult = tx.getContractResult();
        contractResult.setBlockHeight(blockHeight);
        Result saveContractExecuteResult = this.contractService.saveContractExecuteResult(chainId, tx.getHash(), contractResult);
        if (saveContractExecuteResult.isFailed()) {
            return saveContractExecuteResult;
        }
        CreateContractData txData = (CreateContractData)tx.getContractData();
        byte[] contractAddress = txData.getContractAddress();
        byte[] sender = txData.getSender();
        String contractAddressStr = AddressTool.getStringAddressByBytes((byte[])contractAddress);
        if (!contractResult.isSuccess()) {
            return ContractUtil.getSuccess();
        }
        NulsHash hash = tx.getHash();
        tx.setBlockHeight(blockHeight);
        ContractAddressInfoPo info = new ContractAddressInfoPo();
        info.setContractAddress(contractAddress);
        info.setSender(sender);
        info.setCreateTxHash(hash.getBytes());
        info.setAlias(txData.getAlias());
        info.setCreateTime(tx.getTime());
        info.setBlockHeight(blockHeight);
        boolean isNrc20Contract = contractResult.isNrc20();
        boolean isNrc721Contract = TokenTypeStatus.NRC721.status() == contractResult.getTokenType();
        boolean acceptDirectTransfer = contractResult.isAcceptDirectTransfer();
        info.setAcceptDirectTransfer(acceptDirectTransfer);
        info.setNrc20(isNrc20Contract);
        info.setTokenType(contractResult.getTokenType());
        if (isNrc20Contract || isNrc721Contract) {
            String tokenName = contractResult.getTokenName();
            String tokenSymbol = contractResult.getTokenSymbol();
            int tokenDecimals = contractResult.getTokenDecimals();
            BigInteger tokenTotalSupply = contractResult.getTokenTotalSupply();
            info.setNrc20TokenName(tokenName);
            info.setNrc20TokenSymbol(tokenSymbol);
            if (isNrc20Contract) {
                info.setDecimals(tokenDecimals);
                info.setTotalSupply(tokenTotalSupply);
                if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_V250) {
                    List<ProgramMethod> methods = this.contractHelper.getAllMethods(chainId, txData.getCode());
                    boolean isNewNrc20 = false;
                    for (ProgramMethod method : methods) {
                        if (!"transferCrossChain".equals(method.getName()) || !"(String to, BigInteger value) return boolean".equals(method.getDesc())) continue;
                        isNewNrc20 = true;
                        break;
                    }
                    if (isNewNrc20) {
                        Log.info("CROSS-NRC20-TOKEN contract [{}] Register contract assets with the ledger", contractAddressStr);
                        Map resultMap = LedgerCall.commitNRC20Assets(chainId, tokenName, tokenSymbol, (short)tokenDecimals, tokenTotalSupply, contractAddressStr);
                        if (resultMap != null) {
                            int assetId = Integer.parseInt(resultMap.get("assetId").toString());
                            Chain chain = this.contractHelper.getChain(chainId);
                            Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = chain.getTokenAssetsInfoMap();
                            Map<String, String> tokenAssetsContractAddressInfoMap = chain.getTokenAssetsContractAddressInfoMap();
                            tokenAssetsInfoMap.put(contractAddressStr, new ContractTokenAssetsInfo(chainId, assetId));
                            tokenAssetsContractAddressInfoMap.put(chainId + "-" + assetId, contractAddressStr);
                        }
                    }
                }
            }
        }
        return this.contractAddressStorageService.saveContractAddress(chainId, contractAddress, info);
    }

    public Result onRollbackV8(int chainId, ContractWrapperTransaction tx) throws Exception {
        Result result;
        ContractData txData = tx.getContractData();
        byte[] contractAddress = txData.getContractAddress();
        ContractResult contractResult = tx.getContractResult();
        if (contractResult == null) {
            contractResult = this.contractService.getContractExecuteResult(chainId, tx.getHash());
        }
        if (contractResult == null) {
            return Result.getSuccess(null);
        }
        try {
            CreateContractData contractData = (CreateContractData)tx.getContractData();
            Log.info("rollback create tx, contract data is {}, result is {}", JSONUtils.obj2json((Object)new CreateContractDataDto(contractData)), JSONUtils.obj2json((Object)new ContractResultDto(chainId, contractResult, contractData.getGasLimit())));
        }
        catch (Exception e) {
            Log.warn("failed to trace create rollback log, error is {}", e.getMessage());
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_V250 && contractResult.isNrc20()) {
            LedgerCall.rollBackNRC20Assets(chainId, AddressTool.getStringAddressByBytes((byte[])contractAddress));
            Chain chain = this.contractHelper.getChain(chainId);
            Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = chain.getTokenAssetsInfoMap();
            ContractTokenAssetsInfo tokenAssetsInfo = tokenAssetsInfoMap.remove(contractAddress);
            if (tokenAssetsInfo != null) {
                Map<String, String> tokenAssetsContractAddressInfoMap = chain.getTokenAssetsContractAddressInfoMap();
                tokenAssetsContractAddressInfoMap.remove(chainId + "-" + tokenAssetsInfo.getAssetId());
            }
        }
        if ((result = this.contractAddressStorageService.deleteContractAddress(chainId, contractAddress)).isFailed()) {
            return result;
        }
        return this.contractService.deleteContractExecuteResult(chainId, tx.getHash());
    }

    public Result onCommitV14(int chainId, ContractWrapperTransaction tx) throws Exception {
        BlockHeader blockHeader = this.contractHelper.getBatchInfoCurrentBlockHeaderV8(chainId);
        long blockHeight = blockHeader.getHeight();
        tx.setBlockHeight(blockHeight);
        ContractResult contractResult = tx.getContractResult();
        contractResult.setBlockHeight(blockHeight);
        Result saveContractExecuteResult = this.contractService.saveContractExecuteResult(chainId, tx.getHash(), contractResult);
        if (saveContractExecuteResult.isFailed()) {
            return saveContractExecuteResult;
        }
        if (!contractResult.isSuccess()) {
            return ContractUtil.getSuccess();
        }
        CreateContractData txData = (CreateContractData)tx.getContractData();
        byte[] contractAddress = txData.getContractAddress();
        byte[] sender = txData.getSender();
        String alias = txData.getAlias();
        byte[] code = txData.getCode();
        ContractCreate create = new ContractCreate();
        create.setTokenType(contractResult.getTokenType());
        create.setTokenName(contractResult.getTokenName());
        create.setTokenSymbol(contractResult.getTokenSymbol());
        create.setTokenDecimals(contractResult.getTokenDecimals());
        create.setTokenTotalSupply(contractResult.getTokenTotalSupply());
        create.setAcceptDirectTransfer(contractResult.isAcceptDirectTransfer());
        HashMap<String, ContractAddressInfoPo> infoPoMap = new HashMap<String, ContractAddressInfoPo>();
        Result result = this.contractHelper.onCommitForCreateV14(chainId, blockHeader, create, tx.getHash(), tx.getTime(), contractAddress, sender, code, alias, infoPoMap);
        return result;
    }

    public Result onRollbackV14(int chainId, ContractWrapperTransaction tx) throws Exception {
        ContractData txData = tx.getContractData();
        byte[] contractAddress = txData.getContractAddress();
        ContractResult contractResult = tx.getContractResult();
        if (contractResult == null) {
            contractResult = this.contractService.getContractExecuteResult(chainId, tx.getHash());
        }
        if (contractResult == null) {
            return Result.getSuccess(null);
        }
        try {
            CreateContractData contractData = (CreateContractData)tx.getContractData();
            Log.info("rollback create tx, contract data is {}, result is {}", JSONUtils.obj2json((Object)new CreateContractDataDto(contractData)), JSONUtils.obj2json((Object)new ContractResultDto(chainId, contractResult, contractData.getGasLimit())));
        }
        catch (Exception e) {
            Log.warn("failed to trace create rollback log, error is {}", e.getMessage());
        }
        Result result = this.contractHelper.onRollbackForCreateV14(chainId, contractAddress, contractResult.isNrc20());
        if (result.isFailed()) {
            return result;
        }
        return this.contractService.deleteContractExecuteResult(chainId, tx.getHash());
    }
}

