/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.rpc;

import io.nuls.contract.util.Log;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.Map;

public class CallHelper {
    public static Object request(String moduleCode, String cmd, Map params) throws NulsException {
        try {
            params.put("version", "1.0");
            Response response = ResponseMessageProcessor.requestAndResponse((String)moduleCode, (String)cmd, (Map)params);
            Map resData = (Map)response.getResponseData();
            if (!response.isSuccess()) {
                Log.error("response error info is {}, cmd is {}, params is {}", response, cmd, JSONUtils.obj2json((Object)params));
                String errorCode = response.getResponseErrorCode();
                Log.error("Call interface [{}] error, ErrorCode is {}, ResponseComment:{}", cmd, errorCode, response.getResponseComment());
                throw new NulsException(ErrorCode.init((String)errorCode));
            }
            return resData.get(cmd);
        }
        catch (Exception e) {
            Log.error(e);
            if (e instanceof NulsException) {
                throw (NulsException)((Object)e);
            }
            throw new NulsException((Throwable)e);
        }
    }
}

