/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.storage.impl;

import io.nuls.base.data.CoinTo;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.storage.ContractRewardLogByConsensusStorageService;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rockdb.service.RocksDBService;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

@Component
public class ContractRewardLogByConsensusStorageServiceImpl
implements ContractRewardLogByConsensusStorageService {
    private final String baseArea = "contract_offline_tx_hash_list_";
    private final byte[] asset_prefix = "csr-a-".getBytes(StandardCharsets.UTF_8);
    private final byte[] asset_amount_prefix = "csr-am-".getBytes(StandardCharsets.UTF_8);

    private byte[] assetsKey(byte[] address) {
        byte[] key = ArrayUtils.addAll((byte[])this.asset_prefix, (byte[])address);
        return key;
    }

    @Override
    public Set<String> getAssets(int chainId, byte[] address) {
        byte[] key = this.assetsKey(address);
        return this.getAssetsByKey(chainId, key);
    }

    private Set<String> getAssetsByKey(int chainId, byte[] key) {
        byte[] bytes = RocksDBService.get((String)("contract_offline_tx_hash_list_" + chainId), (byte[])key);
        if (bytes == null) {
            return new HashSet<String>();
        }
        String result = new String(bytes, StandardCharsets.UTF_8);
        String[] split = result.split(",");
        HashSet<String> res = new HashSet<String>();
        for (String s : split) {
            res.add(s.trim());
        }
        return res;
    }

    @Override
    public Map<String, String> getAssetsMap(int chainId, byte[] address) {
        Set<String> assets = this.getAssets(chainId, address);
        HashMap<String, String> res = new HashMap<String, String>();
        for (String asset : assets) {
            String[] split = asset.split("-");
            int assetChainId = Integer.parseInt(split[0]);
            int assetId = Integer.parseInt(split[1]);
            res.put(asset, this.getAssetAmount(chainId, address, assetChainId, assetId).toString());
        }
        return res;
    }

    private byte[] assetAmountKey(byte[] address, int assetChainId, int assetId) {
        byte[] key = ArrayUtils.addAll((byte[])this.asset_amount_prefix, (byte[])address);
        key = ArrayUtils.addAll((byte[])key, (byte[])("-" + assetChainId + "-" + assetId).getBytes(StandardCharsets.UTF_8));
        return key;
    }

    private BigInteger getAssetAmount(int chainId, byte[] key) {
        byte[] bytes = RocksDBService.get((String)("contract_offline_tx_hash_list_" + chainId), (byte[])key);
        if (bytes == null) {
            return BigInteger.ZERO;
        }
        return new BigInteger(new String(bytes, StandardCharsets.UTF_8));
    }

    @Override
    public BigInteger getAssetAmount(int chainId, byte[] address, int assetChainId, int assetId) {
        byte[] key = this.assetAmountKey(address, assetChainId, assetId);
        return this.getAssetAmount(chainId, key);
    }

    @Override
    public Result save(int chainId, List<CoinTo> tos) throws Exception {
        if (tos == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        for (CoinTo to : tos) {
            String assetKey;
            byte[] assetsKey = this.assetsKey(to.getAddress());
            Set<String> assets = this.getAssetsByKey(chainId, assetsKey);
            if (assets.add(assetKey = to.getAssetsChainId() + "-" + to.getAssetsId())) {
                StringBuilder sb = new StringBuilder();
                for (String asset : assets) {
                    sb.append(asset).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                RocksDBService.put((String)("contract_offline_tx_hash_list_" + chainId), (byte[])assetsKey, (byte[])sb.toString().getBytes(StandardCharsets.UTF_8));
            }
            byte[] assetAmountKey = this.assetAmountKey(to.getAddress(), to.getAssetsChainId(), to.getAssetsId());
            BigInteger assetAmount = this.getAssetAmount(chainId, assetAmountKey);
            RocksDBService.put((String)("contract_offline_tx_hash_list_" + chainId), (byte[])assetAmountKey, (byte[])assetAmount.add(to.getAmount()).toString().getBytes(StandardCharsets.UTF_8));
        }
        return ContractUtil.getSuccess();
    }

    @Override
    public Result delete(int chainId, List<CoinTo> tos) throws Exception {
        if (tos == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        for (CoinTo to : tos) {
            byte[] assetAmountKey = this.assetAmountKey(to.getAddress(), to.getAssetsChainId(), to.getAssetsId());
            BigInteger assetAmount = this.getAssetAmount(chainId, assetAmountKey);
            RocksDBService.put((String)("contract_offline_tx_hash_list_" + chainId), (byte[])assetAmountKey, (byte[])assetAmount.subtract(to.getAmount()).toString().getBytes(StandardCharsets.UTF_8));
        }
        return ContractUtil.getSuccess();
    }
}

