/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.tx;

import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractTokenAssetsInfo;
import io.nuls.contract.rpc.call.LedgerCall;
import io.nuls.contract.rpc.call.TransactionCall;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.VMFactory;
import io.nuls.core.basic.VersionChangeInvoker;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SmartContractVersionChangeInvoker
implements VersionChangeInvoker {
    private static SmartContractVersionChangeInvoker invoker = new SmartContractVersionChangeInvoker();
    private boolean isloadV8 = false;
    private boolean isloadV14 = false;
    private boolean isloadV15 = false;

    private SmartContractVersionChangeInvoker() {
    }

    public static SmartContractVersionChangeInvoker instance() {
        return invoker;
    }

    public void process(int currentChainId) {
        ChainManager.chainHandle(currentChainId);
        Short currentVersion = ProtocolGroupManager.getCurrentVersion((int)currentChainId);
        Log.info("Trigger protocol upgrade,chainId: [{}], Version is: [{}]", currentChainId, currentVersion);
        ChainManager chainManager = (ChainManager)SpringLiteContext.getBean(ChainManager.class);
        if (currentVersion >= ContractContext.PROTOCOL_15) {
            this.loadV15(chainManager.getChainMap().get(currentChainId), currentVersion.shortValue());
        } else if (currentVersion >= ContractContext.PROTOCOL_14) {
            this.loadV14(chainManager.getChainMap().get(currentChainId), currentVersion.shortValue());
        } else if (currentVersion >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
            this.loadV8(chainManager.getChainMap().get(currentChainId), currentVersion.shortValue());
        }
        this.setContractGenerateTxTypes(currentChainId, currentVersion);
        Map<Integer, Chain> chainMap = chainManager.getChainMap();
        for (Chain chain : chainMap.values()) {
            int chainId = chain.getChainId();
            Short version = ProtocolGroupManager.getCurrentVersion((int)chainId);
            if (version < ContractContext.UPDATE_VERSION_V250) continue;
            Log.info("Protocol upgrade successful, obtain from ledger moduletokenAsset list,chainId: [{}], Version is: [{}]", chainId, version);
            try {
                List<Map> regTokenList = LedgerCall.getRegTokenList(chainId);
                if (regTokenList == null || regTokenList.isEmpty()) continue;
                Map<String, ContractTokenAssetsInfo> tokenAssetsInfoMap = chain.getTokenAssetsInfoMap();
                Map<String, String> tokenAssetsContractAddressInfoMap = chain.getTokenAssetsContractAddressInfoMap();
                regTokenList.stream().forEach(map -> {
                    int assetId = Integer.parseInt(map.get("assetId").toString());
                    String tokenContractAddress = map.get("assetOwnerAddress").toString();
                    tokenAssetsInfoMap.put(tokenContractAddress, new ContractTokenAssetsInfo(chainId, assetId));
                    tokenAssetsContractAddressInfoMap.put(chainId + "-" + assetId, tokenContractAddress);
                });
            }
            catch (NulsException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setContractGenerateTxTypes(int currentChainId, Short currentVersion) {
        List<Integer> list = List.of(Integer.valueOf(18), Integer.valueOf(20), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23));
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        resultList.addAll(list);
        if (currentVersion >= ContractContext.UPDATE_VERSION_V250) {
            resultList.add(26);
        }
        try {
            TransactionCall.setContractGenerateTxTypes(currentChainId, resultList);
        }
        catch (NulsException e) {
            Log.warn("Exception in obtaining transaction type for smart contract generation", e);
        }
    }

    private void loadV8(Chain chain, int currentVersion) {
        if (this.isloadV8) {
            return;
        }
        chain.clearOldBatchInfo();
        Log.info("version[{}]Protocol upgrade successful, reinitialize smart contractVM", currentVersion);
        VMFactory.reInitVM_v8();
        this.isloadV8 = true;
    }

    private void loadV14(Chain chain, int currentVersion) {
        if (this.isloadV14) {
            return;
        }
        chain.clearBatchInfo();
        Log.info("version[{}]Protocol upgrade successful, reinitialize smart contractVM", currentVersion);
        VMFactory.reInitVM_v14();
        this.isloadV14 = true;
    }

    private void loadV15(Chain chain, int currentVersion) {
        if (this.isloadV15) {
            return;
        }
        chain.clearBatchInfo();
        Log.info("version[{}]Protocol upgrade successful, reinitialize smart contractVM", currentVersion);
        VMFactory.reInitVM_v15();
        this.isloadV15 = true;
    }
}

