/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.tx.common;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.CommonAdvice;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.enums.BlockType;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.storage.ContractOfflineTxHashListStorageService;
import io.nuls.contract.tx.v1.CallContractProcessor;
import io.nuls.contract.tx.v8.CallContractProcessorV8;
import io.nuls.contract.util.Log;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class TransactionRollbackAdvice
implements CommonAdvice {
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractOfflineTxHashListStorageService contractOfflineTxHashListStorageService;
    @Autowired
    private CallContractProcessor callContractProcessor;
    @Autowired
    private CallContractProcessorV8 callContractProcessorV8;

    public void begin(int chainId, List<Transaction> txList, BlockHeader header) {
        try {
            ChainManager.chainHandle(chainId, BlockType.VERIFY_BLOCK.type());
            Short currentVersion = ProtocolGroupManager.getCurrentVersion((int)chainId);
            Log.info("[Rollback] height: {}, blockHash: {}, begin", header != null ? header.getHeight() : 0L, header != null ? header.getHash().toHex() : "empty");
            this.contractOfflineTxHashListStorageService.deleteOfflineTxHashList(chainId, header.getHash().getBytes());
            if (currentVersion >= ContractContext.UPDATE_VERSION_V250) {
                List<Transaction> crossTxList = txList.stream().filter(tx -> tx.getType() == 10).collect(Collectors.toList());
                if (currentVersion >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
                    this.callContractProcessorV8.rollback(chainId, crossTxList, header);
                } else {
                    this.callContractProcessor.rollback(chainId, crossTxList, header);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void end(int chainId, List<Transaction> txList, BlockHeader blockHeader) {
    }

    public void coinbase(int chainId, Transaction tx, BlockHeader blockHeader) {
        try {
            if (ProtocolGroupManager.getCurrentVersion((int)chainId) < ContractContext.PROTOCOL_21) {
                return;
            }
            if (1 != tx.getType()) {
                return;
            }
            Log.info("Rollback contractRewardLogByConsensus, height: {}, coinbase hash: {}", blockHeader.getHeight(), tx.getHash().toHex());
            CoinData coinData = tx.getCoinDataInstance();
            List toList = coinData.getTo();
            int toListSize = toList.size();
            if (toListSize == 0) {
                return;
            }
            ArrayList<CoinTo> assetRewardList = new ArrayList<CoinTo>();
            for (CoinTo to : toList) {
                byte[] address = to.getAddress();
                BigInteger value = to.getAmount();
                if (value.compareTo(BigInteger.ZERO) < 0) {
                    Log.error("address [{}] - error amount [{}]", AddressTool.getStringAddressByBytes((byte[])address), value.toString());
                    return;
                }
                if (!AddressTool.validContractAddress((byte[])address, (int)chainId)) continue;
                assetRewardList.add(to);
            }
            this.contractHelper.deleteContractRewardLogByConsensus(chainId, assetRewardList);
            Log.info("Rollback contractRewardLogByConsensus end, assetRewardList size: {}", assetRewardList.size());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

