/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.tx.v1;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.dto.ContractPackageDto;
import io.nuls.contract.model.tx.DeleteContractTransaction;
import io.nuls.contract.model.txdata.DeleteContractData;
import io.nuls.contract.processor.DeleteContractTxProcessor;
import io.nuls.contract.util.Log;
import io.nuls.contract.validator.DeleteContractTxValidator;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="DeleteContractProcessor")
public class DeleteContractProcessor
implements TransactionProcessor {
    @Autowired
    private DeleteContractTxProcessor deleteContractTxProcessor;
    @Autowired
    private DeleteContractTxValidator deleteContractTxValidator;
    @Autowired
    private ContractHelper contractHelper;

    public int getType() {
        return 17;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ChainManager.chainHandle(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Transaction> errorList = new ArrayList<Transaction>();
        result.put("txList", errorList);
        String errorCode = null;
        for (Transaction tx : txs) {
            DeleteContractTransaction deleteTx = new DeleteContractTransaction();
            deleteTx.copyTx(tx);
            try {
                Result validate = this.deleteContractTxValidator.validate(chainId, deleteTx);
                if (!validate.isFailed()) continue;
                errorCode = validate.getErrorCode().getCode();
                errorList.add(tx);
            }
            catch (NulsException e) {
                Log.error(e);
                errorCode = e.getErrorCode().getCode();
                errorList.add(tx);
            }
        }
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader header) {
        try {
            ContractPackageDto contractPackageDto = this.contractHelper.getChain(chainId).getBatchInfo().getContractPackageDto();
            if (contractPackageDto != null) {
                Map<String, ContractResult> contractResultMap = contractPackageDto.getContractResultMap();
                for (Transaction tx : txs) {
                    String txHash = tx.getHash().toString();
                    ContractResult contractResult = contractResultMap.get(txHash);
                    if (contractResult == null) {
                        Log.warn("empty contract result with txHash: {}", txHash);
                        continue;
                    }
                    ContractWrapperTransaction wrapperTx = contractResult.getTx();
                    wrapperTx.setContractResult(contractResult);
                    this.deleteContractTxProcessor.onCommit(chainId, wrapperTx);
                }
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        try {
            ChainManager.chainHandle(chainId);
            for (Transaction tx : txs) {
                DeleteContractData delete = new DeleteContractData();
                delete.parse(tx.getTxData(), 0);
                this.deleteContractTxProcessor.onRollback(chainId, new ContractWrapperTransaction(tx, delete));
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }
}

