/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import io.nuls.contract.util.Log;
import io.nuls.core.log.logback.LoggerBuilder;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.StringUtils;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private LogUtil() {
    }

    public static void configDefaultLog(String fileName, String packageLogPackages, String packageLogLevels) {
        Log.DEFAULT_BASIC_LOGGER = LoggerBuilder.getLogger((String)fileName);
        Log.DEFAULT_BASIC_LOGGER.addBasicPath(Log.class.getName());
        if (StringUtils.isNotBlank((String)packageLogPackages) && StringUtils.isNotBlank((String)packageLogLevels)) {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            String[] packages = packageLogPackages.split(",");
            String[] levels = packageLogLevels.split(",");
            int levelsLength = levels.length;
            int length = packages.length;
            for (int i = 0; i < length; ++i) {
                String packagePath = packages[i];
                String logLevel = i >= levelsLength ? "INFO" : levels[i];
                Logger packageLogger = context.getLogger(packagePath);
                packageLogger.setLevel(Level.toLevel((String)logLevel));
            }
        }
    }

    public static void configChainLog(Integer chainId, String fileName) {
        NulsLogger nulsLogger = LoggerBuilder.getLogger((String)fileName, (int)chainId);
        nulsLogger.addBasicPath(Log.class.getName());
        Log.BASIC_LOGGER_MAP.put(chainId, nulsLogger);
    }

    public static void configDefaultLog(String fileName) {
        LogUtil.configDefaultLog(fileName, null, null);
    }
}

