/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.validator;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.common.NCUtils;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.constant.ContractConstant;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.tx.CallContractTransaction;
import io.nuls.contract.model.txdata.CallContractData;
import io.nuls.contract.rpc.call.AccountCall;
import io.nuls.contract.util.ContractLedgerUtil;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.BigIntegerUtils;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Component
public class CallContractTxValidator {
    @Autowired
    private ContractHelper contractHelper;

    public Result validate(int chainId, CallContractTransaction tx) throws NulsException {
        BigInteger fee;
        CoinData coinData = tx.getCoinDataInstance();
        List fromList = coinData.getFrom();
        List toList = coinData.getTo();
        CallContractData txData = (CallContractData)tx.getTxDataObj();
        byte[] sender = txData.getSender();
        boolean existSender = false;
        Chain chain = this.contractHelper.getChain(chainId);
        int assetsId = chain.getConfig().getAssetId();
        for (CoinFrom from : fromList) {
            if (from.getAssetsChainId() != chainId || from.getAssetsId() != assetsId) {
                Log.error("contract call error: The chain id or assets id of coin from is error.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_ASSETS_ERROR);
            }
            if (existSender || !Arrays.equals(from.getAddress(), sender)) continue;
            existSender = true;
        }
        Set addressSet = SignatureUtil.getAddressFromTX((Transaction)tx, (int)chainId);
        if (!existSender || !addressSet.contains(AddressTool.getStringAddressByBytes((byte[])sender))) {
            Log.error("contract call error: The contract caller is not the transaction creator.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CALLER_ERROR);
        }
        if (!ContractUtil.checkPrice(txData.getPrice())) {
            Log.error("contract call error: The gas price is error.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_MINIMUM_PRICE_ERROR);
        }
        if (!ContractUtil.checkGasLimit(txData.getGasLimit())) {
            Log.error("contract call error: The value of gas limit ranges from 1 to 10,000,000.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_GAS_LIMIT_ERROR);
        }
        BigInteger transferValue = txData.getValue();
        byte[] contractAddress = txData.getContractAddress();
        if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddress)) {
            Log.error("contract call error: The contract does not exist.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
        }
        BigInteger contractReceivedValue = BigInteger.ZERO;
        for (CoinTo coin : toList) {
            if (coin.getAssetsChainId() != chainId || coin.getAssetsId() != assetsId) {
                Log.error("contract call error: The chain id or assets id of coin to is error.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_ASSETS_ERROR);
            }
            if (coin.getLockTime() != 0L) {
                Log.error("contract call error: Transfer amount cannot be locked.");
                return Result.getFailed((ErrorCode)ContractErrorCode.AMOUNT_LOCK_ERROR);
            }
            byte[] owner = coin.getAddress();
            if (addressSet.contains(AddressTool.getStringAddressByBytes((byte[])owner))) continue;
            if (!Arrays.equals(owner, contractAddress)) {
                Log.error("contract call error: The receiver is not the contract address.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_RECEIVER_ERROR);
            }
            contractReceivedValue = contractReceivedValue.add(coin.getAmount());
            if (coin.getAmount().compareTo(ContractConstant.MININUM_TRANSFER_AMOUNT) >= 0) continue;
            Log.error("contract call error: The amount of the transfer is too small.");
            return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
        }
        if (contractReceivedValue.compareTo(transferValue) < 0) {
            Log.error("contract call error: Insufficient balance to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        BigInteger realFee = tx.getFee();
        if (realFee.compareTo(fee = TransactionFeeCalculator.getNormalTxFee((int)tx.size(), (long)chain.getConfig().getFeeUnit(chainId, assetsId)).add(BigInteger.valueOf(txData.getGasLimit()).multiply(BigInteger.valueOf(txData.getPrice())))) >= 0) {
            return ContractUtil.getSuccess();
        }
        Log.error("contract call error: The contract transaction fee is not right.");
        return Result.getFailed((ErrorCode)ContractErrorCode.FEE_NOT_RIGHT);
    }

    public Result validateV8(int chainId, CallContractTransaction tx) throws NulsException {
        String assetKey;
        int assetId;
        int assetChainId;
        CoinData coinData = tx.getCoinDataInstance();
        List fromList = coinData.getFrom();
        List toList = coinData.getTo();
        CallContractData txData = (CallContractData)tx.getTxDataObj();
        byte[] sender = txData.getSender();
        Set signatureAddressSet = SignatureUtil.getAddressFromTX((Transaction)tx, (int)chainId);
        if (!signatureAddressSet.contains(AddressTool.getStringAddressByBytes((byte[])sender))) {
            Log.error("contract call error: The contract caller is not the transaction signer.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CALLER_SIGN_ERROR);
        }
        if (!ContractUtil.checkGasLimit(txData.getGasLimit())) {
            Log.error("contract call error: The value of gas limit ranges from 25 to 10,000,000.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_GAS_LIMIT_ERROR);
        }
        byte[] contractAddress = txData.getContractAddress();
        if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddress)) {
            Log.error("contract call error: The contract does not exist.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
        }
        HashMap<CallSite, BigInteger> multyAssetMap = new HashMap<CallSite, BigInteger>();
        HashSet<CallSite> multyAssetKeys = new HashSet<CallSite>();
        BigInteger nulsValue = BigInteger.ZERO;
        for (CoinFrom from : fromList) {
            assetChainId = from.getAssetsChainId();
            assetId = from.getAssetsId();
            assetKey = assetChainId + "_" + assetId;
            if (ContractContext.LOCAL_CHAIN_ID == assetChainId && ContractContext.LOCAL_MAIN_ASSET_ID == assetId) {
                nulsValue = nulsValue.add(from.getAmount());
                continue;
            }
            multyAssetKeys.add((CallSite)((Object)assetKey));
            BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "from", BigInteger.ZERO);
            multyAssetMap.put((CallSite)((Object)(assetKey + "from")), multyAssetValue.add(from.getAmount()));
        }
        int toSize = toList.size();
        BigInteger transferNulsValue = txData.getValue();
        BigInteger contractReceivedNulsValue = BigInteger.ZERO;
        if (toSize > 0) {
            for (CoinTo coin : toList) {
                boolean bl;
                if (coin.getLockTime() != 0L) {
                    Log.error("contract call error: Transfer amount cannot be locked.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.AMOUNT_LOCK_ERROR);
                }
                Object owner = coin.getAddress();
                if (!Arrays.equals((byte[])owner, contractAddress)) {
                    Log.error("contract call error: The receiver is not the contract address.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_RECEIVER_ERROR);
                }
                assetChainId = coin.getAssetsChainId();
                assetId = coin.getAssetsId();
                boolean bl2 = bl = assetChainId == ContractContext.LOCAL_CHAIN_ID && assetId == ContractContext.LOCAL_MAIN_ASSET_ID;
                if (!bl) {
                    if (coin.getAmount().compareTo(BigInteger.ZERO) == 0) {
                        Log.error("contract call error: Transfer amount cannot be zero.");
                        return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
                    }
                    assetKey = assetChainId + "_" + assetId;
                    multyAssetKeys.add((CallSite)((Object)assetKey));
                    BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "to", BigInteger.ZERO);
                    multyAssetMap.put((CallSite)((Object)(assetKey + "to")), multyAssetValue.add(coin.getAmount()));
                    continue;
                }
                if (coin.getAmount().compareTo(ContractConstant.MININUM_TRANSFER_AMOUNT) < 0) {
                    Log.error("contract call error: The amount of the transfer is too small.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
                }
                contractReceivedNulsValue = contractReceivedNulsValue.add(coin.getAmount());
            }
        }
        for (String string : multyAssetKeys) {
            BigInteger assetKeyFrom = (BigInteger)multyAssetMap.get(string + "from");
            BigInteger assetKeyTo = (BigInteger)multyAssetMap.get(string + "to");
            if (null == assetKeyFrom) {
                Log.error("contract call error: Illegal coinFrom in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_FROM_ERROR);
            }
            if (null == assetKeyTo) {
                Log.error("contract call error: Illegal coinTo in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_ERROR);
            }
            if (BigIntegerUtils.isEqual((BigInteger)assetKeyFrom, (BigInteger)assetKeyTo)) continue;
            Log.error("contract call error: The amount of coin data is error.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_ASSETS_ERROR);
        }
        if (contractReceivedNulsValue.compareTo(transferNulsValue) < 0) {
            Log.error("contract call error: Insufficient balance of nuls to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        if (transferNulsValue.compareTo(BigInteger.ZERO) > 0 && nulsValue.compareTo(transferNulsValue) < 0) {
            Log.error("contract call error: Insufficient balance to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        BigInteger realFee = coinData.getFeeByAsset(ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
        Chain chain = this.contractHelper.getChain(chainId);
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)tx.size(), (long)chain.getConfig().getFeeUnit(ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID)).add(BigInteger.valueOf(txData.getGasLimit()).multiply(BigInteger.valueOf(txData.getPrice())));
        if (realFee.compareTo(fee) >= 0) {
            return ContractUtil.getSuccess();
        }
        Log.error("contract call error: The contract transaction fee is not right.");
        return Result.getFailed((ErrorCode)ContractErrorCode.FEE_NOT_RIGHT);
    }

    public Result validateV13(int chainId, CallContractTransaction tx) throws NulsException {
        String assetKey;
        int assetId;
        int assetChainId;
        CoinData coinData = tx.getCoinDataInstance();
        List fromList = coinData.getFrom();
        List toList = coinData.getTo();
        CallContractData txData = (CallContractData)tx.getTxDataObj();
        byte[] sender = txData.getSender();
        Set signatureAddressSet = SignatureUtil.getAddressFromTX((Transaction)tx, (int)chainId);
        if (!signatureAddressSet.contains(AddressTool.getStringAddressByBytes((byte[])sender))) {
            Log.error("contract call error: The contract caller is not the transaction signer.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CALLER_SIGN_ERROR);
        }
        if (!ContractUtil.checkGasLimit(txData.getGasLimit())) {
            Log.error("contract call error: The value of gas limit ranges from 0 to 10,000,000.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_GAS_LIMIT_ERROR);
        }
        byte[] contractAddress = txData.getContractAddress();
        if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddress)) {
            Log.error("contract call error: The contract does not exist.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
        }
        HashMap<CallSite, BigInteger> multyAssetMap = new HashMap<CallSite, BigInteger>();
        HashSet<CallSite> multyAssetKeys = new HashSet<CallSite>();
        BigInteger nulsValue = BigInteger.ZERO;
        for (CoinFrom from : fromList) {
            assetChainId = from.getAssetsChainId();
            assetId = from.getAssetsId();
            assetKey = assetChainId + "_" + assetId;
            if (ContractContext.LOCAL_CHAIN_ID == assetChainId && ContractContext.LOCAL_MAIN_ASSET_ID == assetId) {
                nulsValue = nulsValue.add(from.getAmount());
                continue;
            }
            multyAssetKeys.add((CallSite)((Object)assetKey));
            BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "from", BigInteger.ZERO);
            multyAssetMap.put((CallSite)((Object)(assetKey + "from")), multyAssetValue.add(from.getAmount()));
        }
        int toSize = toList.size();
        BigInteger transferNulsToContractValue = txData.getValue();
        BigInteger contractReceivedNulsValue = BigInteger.ZERO;
        BigInteger transferNulsToOtherAccountValue = BigInteger.ZERO;
        if (toSize > 0) {
            for (CoinTo coin : toList) {
                boolean mainAsset;
                if (coin.getLockTime() != 0L) {
                    Log.error("contract call error: Transfer amount cannot be locked.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.AMOUNT_LOCK_ERROR);
                }
                Object to = coin.getAddress();
                boolean bl = Arrays.equals((byte[])to, contractAddress);
                assetChainId = coin.getAssetsChainId();
                assetId = coin.getAssetsId();
                boolean bl2 = mainAsset = assetChainId == ContractContext.LOCAL_CHAIN_ID && assetId == ContractContext.LOCAL_MAIN_ASSET_ID;
                if (!mainAsset) {
                    if (coin.getAmount().compareTo(BigInteger.ZERO) == 0) {
                        Log.error("contract call error: Transfer amount cannot be zero.");
                        return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
                    }
                    assetKey = assetChainId + "_" + assetId;
                    multyAssetKeys.add((CallSite)((Object)assetKey));
                    BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "to", BigInteger.ZERO);
                    multyAssetMap.put((CallSite)((Object)(assetKey + "to")), multyAssetValue.add(coin.getAmount()));
                    continue;
                }
                if (coin.getAmount().compareTo(ContractConstant.MININUM_TRANSFER_AMOUNT) < 0) {
                    Log.error("contract call error: The amount of the transfer is too small.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
                }
                if (bl) {
                    contractReceivedNulsValue = contractReceivedNulsValue.add(coin.getAmount());
                    continue;
                }
                String toStr = AddressTool.getStringAddressByBytes((byte[])to);
                boolean whiteAddress = AccountCall.validationWhitelistForTransferOnContractCall(chainId, toStr);
                if (!whiteAddress) {
                    Log.error("contract call error: The receiver is not a whitelisted address.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_ERROR);
                }
                transferNulsToOtherAccountValue = transferNulsToOtherAccountValue.add(coin.getAmount());
            }
        }
        for (String string : multyAssetKeys) {
            BigInteger assetKeyFrom = (BigInteger)multyAssetMap.get(string + "from");
            BigInteger assetKeyTo = (BigInteger)multyAssetMap.get(string + "to");
            if (null == assetKeyFrom) {
                Log.error("contract call error: Illegal coinFrom in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_FROM_ERROR);
            }
            if (null == assetKeyTo) {
                Log.error("contract call error: Illegal coinTo in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_ERROR);
            }
            if (BigIntegerUtils.isEqual((BigInteger)assetKeyFrom, (BigInteger)assetKeyTo)) continue;
            Log.error("contract call error: The amount of coin data is error.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_ASSETS_ERROR);
        }
        if (contractReceivedNulsValue.compareTo(transferNulsToContractValue) < 0) {
            Log.error("contract call error: Insufficient balance of nuls to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        if (transferNulsToContractValue.compareTo(BigInteger.ZERO) > 0 && nulsValue.compareTo(transferNulsToContractValue.add(transferNulsToOtherAccountValue)) < 0) {
            Log.error("contract call error: Insufficient balance to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        BigInteger realFee = coinData.getFeeByAsset(ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
        Chain chain = this.contractHelper.getChain(chainId);
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)tx.size(), (long)chain.getConfig().getFeeUnit(ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID)).add(BigInteger.valueOf(txData.getGasLimit()).multiply(BigInteger.valueOf(txData.getPrice())));
        if (realFee.compareTo(fee) >= 0) {
            return ContractUtil.getSuccess();
        }
        Log.error("contract call error: The contract transaction fee is not right.");
        return Result.getFailed((ErrorCode)ContractErrorCode.FEE_NOT_RIGHT);
    }

    public Result validateV14(int chainId, CallContractTransaction tx) throws NulsException {
        String assetKey;
        int assetId;
        int assetChainId;
        CoinData coinData = tx.getCoinDataInstance();
        List fromList = coinData.getFrom();
        List toList = coinData.getTo();
        CallContractData txData = (CallContractData)tx.getTxDataObj();
        byte[] sender = txData.getSender();
        if (fromList == null || fromList.isEmpty()) {
            Log.error("contract call error: The contract caller is not the transaction signer.[0]");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CALLER_SIGN_ERROR);
        }
        boolean existSender = false;
        for (CoinFrom from : fromList) {
            if (!Arrays.equals(from.getAddress(), sender)) continue;
            existSender = true;
            break;
        }
        if (!existSender) {
            Log.error("contract call error: The contract caller is not the transaction signer.[1]");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CALLER_SIGN_ERROR);
        }
        if (!ContractUtil.checkGasLimit(txData.getGasLimit())) {
            Log.error("contract call error: The value of gas limit ranges from 0 to 10,000,000.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_GAS_LIMIT_ERROR);
        }
        byte[] contractAddress = txData.getContractAddress();
        if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddress)) {
            Log.error("contract call error: The contract does not exist.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
        }
        HashMap<CallSite, BigInteger> multyAssetMap = new HashMap<CallSite, BigInteger>();
        HashSet<CallSite> multyAssetKeys = new HashSet<CallSite>();
        BigInteger nulsValue = BigInteger.ZERO;
        for (CoinFrom from : fromList) {
            assetChainId = from.getAssetsChainId();
            assetId = from.getAssetsId();
            assetKey = assetChainId + "_" + assetId;
            if (ContractContext.LOCAL_CHAIN_ID == assetChainId && ContractContext.LOCAL_MAIN_ASSET_ID == assetId) {
                nulsValue = nulsValue.add(from.getAmount());
                continue;
            }
            multyAssetKeys.add((CallSite)((Object)assetKey));
            BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "from", BigInteger.ZERO);
            multyAssetMap.put((CallSite)((Object)(assetKey + "from")), multyAssetValue.add(from.getAmount()));
        }
        int toSize = toList.size();
        BigInteger transferNulsToContractValue = txData.getValue();
        BigInteger contractReceivedNulsValue = BigInteger.ZERO;
        BigInteger transferNulsToOtherAccountValue = BigInteger.ZERO;
        if (toSize > 0) {
            for (CoinTo coin : toList) {
                boolean mainAsset;
                if (coin.getLockTime() != 0L) {
                    Log.error("contract call error: Transfer amount cannot be locked.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.AMOUNT_LOCK_ERROR);
                }
                Object to = coin.getAddress();
                boolean bl = Arrays.equals((byte[])to, contractAddress);
                assetChainId = coin.getAssetsChainId();
                assetId = coin.getAssetsId();
                boolean bl2 = mainAsset = assetChainId == ContractContext.LOCAL_CHAIN_ID && assetId == ContractContext.LOCAL_MAIN_ASSET_ID;
                if (!mainAsset) {
                    if (coin.getAmount().compareTo(BigInteger.ZERO) == 0) {
                        Log.error("contract call error: Transfer amount cannot be zero.");
                        return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
                    }
                    assetKey = assetChainId + "_" + assetId;
                    multyAssetKeys.add((CallSite)((Object)assetKey));
                    BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "to", BigInteger.ZERO);
                    multyAssetMap.put((CallSite)((Object)(assetKey + "to")), multyAssetValue.add(coin.getAmount()));
                    continue;
                }
                if (coin.getAmount().compareTo(ContractConstant.MININUM_TRANSFER_AMOUNT) < 0) {
                    Log.error("contract call error: The amount of the transfer is too small.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
                }
                if (bl) {
                    contractReceivedNulsValue = contractReceivedNulsValue.add(coin.getAmount());
                    continue;
                }
                String toStr = AddressTool.getStringAddressByBytes((byte[])to);
                boolean whiteAddress = AccountCall.validationWhitelistForTransferOnContractCall(chainId, toStr);
                if (!whiteAddress) {
                    Log.error("contract call error: The receiver is not a whitelisted address.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_ERROR);
                }
                transferNulsToOtherAccountValue = transferNulsToOtherAccountValue.add(coin.getAmount());
            }
        }
        for (String string : multyAssetKeys) {
            BigInteger assetKeyFrom = (BigInteger)multyAssetMap.get(string + "from");
            BigInteger assetKeyTo = (BigInteger)multyAssetMap.get(string + "to");
            if (null == assetKeyFrom) {
                Log.error("contract call error: Illegal coinFrom in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_FROM_ERROR);
            }
            if (null == assetKeyTo) {
                Log.error("contract call error: Illegal coinTo in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_ERROR);
            }
            if (BigIntegerUtils.isEqual((BigInteger)assetKeyFrom, (BigInteger)assetKeyTo)) continue;
            Log.error("contract call error: The amount of coin data is error.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_ASSETS_ERROR);
        }
        if (contractReceivedNulsValue.compareTo(transferNulsToContractValue) < 0) {
            Log.error("contract call error: Insufficient balance of nuls to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        if (transferNulsToContractValue.compareTo(BigInteger.ZERO) > 0 && nulsValue.compareTo(transferNulsToContractValue.add(transferNulsToOtherAccountValue)) < 0) {
            Log.error("contract call error: Insufficient balance to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        BigInteger realFee = coinData.getFeeByAsset(ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
        Chain chain = this.contractHelper.getChain(chainId);
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)tx.size(), (long)chain.getConfig().getFeeUnit(ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID)).add(BigInteger.valueOf(txData.getGasLimit()).multiply(BigInteger.valueOf(txData.getPrice())));
        if (realFee.compareTo(fee) >= 0) {
            return ContractUtil.getSuccess();
        }
        Log.error("contract call error: The contract transaction fee is not right.");
        return Result.getFailed((ErrorCode)ContractErrorCode.FEE_NOT_RIGHT);
    }

    /*
     * WARNING - void declaration
     */
    public Result validateV20(int chainId, CallContractTransaction tx) throws NulsException {
        void var23_27;
        String assetKey;
        int assetId;
        int assetChainId;
        CoinData coinData = tx.getCoinDataInstance();
        List fromList = coinData.getFrom();
        List toList = coinData.getTo();
        CallContractData txData = (CallContractData)tx.getTxDataObj();
        byte[] sender = txData.getSender();
        if (fromList == null || fromList.isEmpty()) {
            Log.error("contract call error: The contract caller is not the transaction signer.[0]");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CALLER_SIGN_ERROR);
        }
        boolean existSender = false;
        for (CoinFrom from : fromList) {
            if (!Arrays.equals(from.getAddress(), sender)) continue;
            existSender = true;
            break;
        }
        if (!existSender) {
            Log.error("contract call error: The contract caller is not the transaction signer.[1]");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CALLER_SIGN_ERROR);
        }
        if (!ContractUtil.checkGasLimit(txData.getGasLimit())) {
            Log.error("contract call error: The value of gas limit ranges from 0 to 10,000,000.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_GAS_LIMIT_ERROR);
        }
        byte[] contractAddress = txData.getContractAddress();
        if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddress)) {
            Log.error("contract call error: The contract does not exist.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
        }
        HashMap<CallSite, BigInteger> multyAssetMap = new HashMap<CallSite, BigInteger>();
        HashSet<CallSite> multyAssetKeys = new HashSet<CallSite>();
        BigInteger nulsValue = BigInteger.ZERO;
        for (CoinFrom from : fromList) {
            assetChainId = from.getAssetsChainId();
            assetId = from.getAssetsId();
            assetKey = assetChainId + "_" + assetId;
            if (ContractContext.LOCAL_CHAIN_ID == assetChainId && ContractContext.LOCAL_MAIN_ASSET_ID == assetId) {
                nulsValue = nulsValue.add(from.getAmount());
                continue;
            }
            multyAssetKeys.add((CallSite)((Object)assetKey));
            BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "from", BigInteger.ZERO);
            multyAssetMap.put((CallSite)((Object)(assetKey + "from")), multyAssetValue.add(from.getAmount()));
        }
        int toSize = toList.size();
        BigInteger transferNulsToContractValue = txData.getValue();
        BigInteger contractReceivedNulsValue = BigInteger.ZERO;
        BigInteger transferNulsToOtherAccountValue = BigInteger.ZERO;
        if (toSize > 0) {
            for (CoinTo coin : toList) {
                boolean mainAsset;
                if (coin.getLockTime() != 0L) {
                    Log.error("contract call error: Transfer amount cannot be locked.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.AMOUNT_LOCK_ERROR);
                }
                Object to = coin.getAddress();
                boolean bl = Arrays.equals((byte[])to, contractAddress);
                assetChainId = coin.getAssetsChainId();
                assetId = coin.getAssetsId();
                boolean bl2 = mainAsset = assetChainId == ContractContext.LOCAL_CHAIN_ID && assetId == ContractContext.LOCAL_MAIN_ASSET_ID;
                if (!mainAsset) {
                    if (coin.getAmount().compareTo(BigInteger.ZERO) == 0) {
                        Log.error("contract call error: Transfer amount cannot be zero.");
                        return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
                    }
                    assetKey = assetChainId + "_" + assetId;
                    multyAssetKeys.add((CallSite)((Object)assetKey));
                    BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "to", BigInteger.ZERO);
                    multyAssetMap.put((CallSite)((Object)(assetKey + "to")), multyAssetValue.add(coin.getAmount()));
                    continue;
                }
                if (coin.getAmount().compareTo(ContractConstant.MININUM_TRANSFER_AMOUNT) < 0) {
                    Log.error("contract call error: The amount of the transfer is too small.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
                }
                if (bl) {
                    contractReceivedNulsValue = contractReceivedNulsValue.add(coin.getAmount());
                    continue;
                }
                String toStr = AddressTool.getStringAddressByBytes((byte[])to);
                boolean whiteAddress = AccountCall.validationWhitelistForTransferOnContractCall(chainId, toStr);
                if (!whiteAddress) {
                    Log.error("contract call error: The receiver is not a whitelisted address.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_ERROR);
                }
                transferNulsToOtherAccountValue = transferNulsToOtherAccountValue.add(coin.getAmount());
            }
        }
        for (String string : multyAssetKeys) {
            BigInteger assetKeyFrom = (BigInteger)multyAssetMap.get(string + "from");
            BigInteger assetKeyTo = (BigInteger)multyAssetMap.get(string + "to");
            if (null == assetKeyFrom) {
                Log.error("contract call error: Illegal coinFrom in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_FROM_ERROR);
            }
            if (ContractContext.FEE_ASSETS_SET.contains(string.replace("_", "-"))) continue;
            if (null == assetKeyTo) {
                Log.error("contract call error: Illegal coinTo in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_ERROR);
            }
            if (BigIntegerUtils.isEqual((BigInteger)assetKeyFrom, (BigInteger)assetKeyTo)) continue;
            Log.error("contract call error: The amount of coin data is error.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_ASSETS_ERROR);
        }
        if (contractReceivedNulsValue.compareTo(transferNulsToContractValue) < 0) {
            Log.error("contract call error: Insufficient balance of nuls to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        if (transferNulsToContractValue.compareTo(BigInteger.ZERO) > 0 && nulsValue.compareTo(transferNulsToContractValue.add(transferNulsToOtherAccountValue)) < 0) {
            Log.error("contract call error: Insufficient balance to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        BigInteger realFee = BigInteger.ZERO;
        int[] nArray = new int[]{};
        for (String key : ContractContext.FEE_ASSETS_SET) {
            if (realFee.compareTo(BigInteger.ZERO) != 0) break;
            int[] nArray2 = NCUtils.splitTokenId(key);
            realFee = coinData.getFeeByAsset(nArray2[0], nArray2[1]);
        }
        Chain chain = this.contractHelper.getChain(chainId);
        BigInteger scFee = BigInteger.valueOf(txData.getGasLimit()).multiply(BigInteger.valueOf(txData.getPrice()));
        scFee = new BigDecimal(scFee).multiply(BigDecimal.valueOf(chain.getConfig().getFeeCoefficient((int)var23_27[0], (int)var23_27[1]))).toBigInteger();
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)tx.size(), (long)chain.getConfig().getFeeUnit((int)var23_27[0], (int)var23_27[1])).add(scFee);
        if (realFee.compareTo(fee) >= 0) {
            return ContractUtil.getSuccess();
        }
        Log.error("contract call error: The contract transaction fee is not right.");
        return Result.getFailed((ErrorCode)ContractErrorCode.FEE_NOT_RIGHT);
    }

    /*
     * WARNING - void declaration
     */
    public Result validateV22(int chainId, CallContractTransaction tx) throws NulsException {
        void var23_27;
        String assetKey;
        int assetId;
        int assetChainId;
        CoinData coinData = tx.getCoinDataInstance();
        List fromList = coinData.getFrom();
        List toList = coinData.getTo();
        CallContractData txData = (CallContractData)tx.getTxDataObj();
        byte[] sender = txData.getSender();
        if (fromList == null || fromList.isEmpty()) {
            Log.error("contract call error: The contract caller is not the transaction signer.[0]");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CALLER_SIGN_ERROR);
        }
        boolean existSender = false;
        for (CoinFrom from : fromList) {
            if (!Arrays.equals(from.getAddress(), sender)) continue;
            existSender = true;
            break;
        }
        if (!existSender) {
            Log.error("contract call error: The contract caller is not the transaction signer.[1]");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_CALLER_SIGN_ERROR);
        }
        if (!ContractUtil.checkGasLimit(txData.getGasLimit())) {
            Log.error("contract call error: The value of gas limit ranges from 0 to 10,000,000.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_GAS_LIMIT_ERROR);
        }
        byte[] contractAddress = txData.getContractAddress();
        if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddress)) {
            Log.error("contract call error: The contract does not exist.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
        }
        HashMap<CallSite, BigInteger> multyAssetMap = new HashMap<CallSite, BigInteger>();
        HashSet<CallSite> multyAssetKeys = new HashSet<CallSite>();
        BigInteger nulsValue = BigInteger.ZERO;
        for (CoinFrom from : fromList) {
            assetChainId = from.getAssetsChainId();
            assetId = from.getAssetsId();
            assetKey = assetChainId + "_" + assetId;
            if (ContractContext.LOCAL_CHAIN_ID == assetChainId && ContractContext.LOCAL_MAIN_ASSET_ID == assetId) {
                nulsValue = nulsValue.add(from.getAmount());
                continue;
            }
            multyAssetKeys.add((CallSite)((Object)assetKey));
            BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "from", BigInteger.ZERO);
            multyAssetMap.put((CallSite)((Object)(assetKey + "from")), multyAssetValue.add(from.getAmount()));
        }
        int toSize = toList.size();
        BigInteger transferNulsToContractValue = txData.getValue();
        BigInteger contractReceivedNulsValue = BigInteger.ZERO;
        BigInteger transferNulsToOtherAccountValue = BigInteger.ZERO;
        if (toSize > 0) {
            for (CoinTo coin : toList) {
                boolean mainAsset;
                if (coin.getLockTime() != 0L) {
                    Log.error("contract call error: Transfer amount cannot be locked.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.AMOUNT_LOCK_ERROR);
                }
                Object to = coin.getAddress();
                boolean bl = Arrays.equals((byte[])to, contractAddress);
                assetChainId = coin.getAssetsChainId();
                assetId = coin.getAssetsId();
                boolean bl2 = mainAsset = assetChainId == ContractContext.LOCAL_CHAIN_ID && assetId == ContractContext.LOCAL_MAIN_ASSET_ID;
                if (!mainAsset) {
                    if (coin.getAmount().compareTo(BigInteger.ZERO) == 0) {
                        Log.error("contract call error: Transfer amount cannot be zero.");
                        return Result.getFailed((ErrorCode)ContractErrorCode.TOO_SMALL_AMOUNT);
                    }
                    assetKey = assetChainId + "_" + assetId;
                    multyAssetKeys.add((CallSite)((Object)assetKey));
                    BigInteger multyAssetValue = multyAssetMap.getOrDefault(assetKey + "to", BigInteger.ZERO);
                    multyAssetMap.put((CallSite)((Object)(assetKey + "to")), multyAssetValue.add(coin.getAmount()));
                    continue;
                }
                if (bl) {
                    contractReceivedNulsValue = contractReceivedNulsValue.add(coin.getAmount());
                    continue;
                }
                String toStr = AddressTool.getStringAddressByBytes((byte[])to);
                boolean whiteAddress = AccountCall.validationWhitelistForTransferOnContractCall(chainId, toStr);
                if (!whiteAddress) {
                    Log.error("contract call error: The receiver is not a whitelisted address.");
                    return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_ERROR);
                }
                transferNulsToOtherAccountValue = transferNulsToOtherAccountValue.add(coin.getAmount());
            }
        }
        for (String string : multyAssetKeys) {
            BigInteger assetKeyFrom = (BigInteger)multyAssetMap.get(string + "from");
            BigInteger assetKeyTo = (BigInteger)multyAssetMap.get(string + "to");
            if (null == assetKeyFrom) {
                Log.error("contract call error: Illegal coinFrom in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_FROM_ERROR);
            }
            if (ContractContext.FEE_ASSETS_SET.contains(string.replace("_", "-"))) continue;
            if (null == assetKeyTo) {
                Log.error("contract call error: Illegal coinTo in the contract.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_ERROR);
            }
            if (BigIntegerUtils.isEqual((BigInteger)assetKeyFrom, (BigInteger)assetKeyTo)) continue;
            Log.error("contract call error: The amount of coin data is error.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_ASSETS_ERROR);
        }
        if (contractReceivedNulsValue.compareTo(transferNulsToContractValue) < 0) {
            Log.error("contract call error: Insufficient balance of nuls to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        if (transferNulsToContractValue.compareTo(BigInteger.ZERO) > 0 && nulsValue.compareTo(transferNulsToContractValue.add(transferNulsToOtherAccountValue)) < 0) {
            Log.error("contract call error: Insufficient balance to transfer to the contract address.");
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE_TO_CONTRACT);
        }
        BigInteger realFee = BigInteger.ZERO;
        int[] nArray = new int[]{};
        for (String key : ContractContext.FEE_ASSETS_SET) {
            if (realFee.compareTo(BigInteger.ZERO) != 0) break;
            int[] nArray2 = NCUtils.splitTokenId(key);
            realFee = coinData.getFeeByAsset(nArray2[0], nArray2[1]);
        }
        Chain chain = this.contractHelper.getChain(chainId);
        BigInteger scFee = BigInteger.valueOf(txData.getGasLimit()).multiply(BigInteger.valueOf(txData.getPrice()));
        scFee = new BigDecimal(scFee).multiply(BigDecimal.valueOf(chain.getConfig().getFeeCoefficient((int)var23_27[0], (int)var23_27[1]))).toBigInteger();
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)tx.size(), (long)chain.getConfig().getFeeUnit((int)var23_27[0], (int)var23_27[1])).add(scFee);
        if (realFee.compareTo(fee) >= 0) {
            return ContractUtil.getSuccess();
        }
        Log.error("contract call error: The contract transaction fee is not right.");
        return Result.getFailed((ErrorCode)ContractErrorCode.FEE_NOT_RIGHT);
    }
}

