/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.validator;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.contract.model.tx.DeleteContractTransaction;
import io.nuls.contract.model.txdata.DeleteContractData;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@Component
public class DeleteContractTxValidator {
    @Autowired
    private ContractHelper contractHelper;

    public Result validate(int chainId, DeleteContractTransaction tx) throws NulsException {
        CoinData coinData = tx.getCoinDataInstance();
        List fromList = coinData.getFrom();
        List toList = coinData.getTo();
        if (toList.size() != 0) {
            Log.error("contract delete error: The contract coin to is not empty.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_TO_EMPTY_ERROR);
        }
        DeleteContractData txData = (DeleteContractData)tx.getTxDataObj();
        byte[] sender = txData.getSender();
        boolean existSender = false;
        Chain chain = this.contractHelper.getChain(chainId);
        int assetsId = chain.getConfig().getAssetId();
        for (CoinFrom from : fromList) {
            if (from.getAssetsChainId() != chainId || from.getAssetsId() != assetsId) {
                Log.error("contract delete error: The chain id or assets id of coin from is error.");
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_COIN_ASSETS_ERROR);
            }
            if (existSender || !Arrays.equals(from.getAddress(), sender)) continue;
            existSender = true;
        }
        Set addressSet = SignatureUtil.getAddressFromTX((Transaction)tx, (int)chainId);
        if (!existSender || !addressSet.contains(AddressTool.getStringAddressByBytes((byte[])sender))) {
            Log.error("contract delete error: The contract deleter is not the transaction creator.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_DELETER_ERROR);
        }
        byte[] contractAddressBytes = txData.getContractAddress();
        Result<ContractAddressInfoPo> contractAddressInfoPoResult = this.contractHelper.getContractAddressInfo(chainId, contractAddressBytes);
        if (contractAddressInfoPoResult.isFailed()) {
            return Result.getFailed((ErrorCode)contractAddressInfoPoResult.getErrorCode());
        }
        ContractAddressInfoPo contractAddressInfoPo = (ContractAddressInfoPo)contractAddressInfoPoResult.getData();
        if (contractAddressInfoPo == null) {
            Log.error("contract delete error: The contract does not exist.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
        }
        if (!Arrays.equals(sender, contractAddressInfoPo.getSender())) {
            Log.error("contract delete error: The contract deleter is not the contract creator.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_OWNER_ERROR);
        }
        ContractBalance balance = this.contractHelper.getRealBalance(chainId, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID, AddressTool.getStringAddressByBytes((byte[])contractAddressBytes));
        if (balance == null) {
            Log.error("contract delete error: That balance of the contract is abnormal.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_BALANCE_ERROR);
        }
        BigInteger totalBalance = balance.getTotal();
        if (totalBalance.compareTo(BigInteger.ZERO) != 0) {
            Log.error("contract delete error: The balance of the contract is not 0.");
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_DELETE_BALANCE);
        }
        return ContractUtil.getSuccess();
    }
}

