/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm;

import io.nuls.contract.vm.ObjectRef;

public class LocalVariables {
    private int maxLocals;
    private Object[] localVariables;

    public LocalVariables(int maxLocals, Object[] args) {
        this.maxLocals = maxLocals;
        this.localVariables = new Object[maxLocals];
        if (args != null) {
            System.arraycopy(args, 0, this.localVariables, 0, args.length);
        }
    }

    public int getInt(int index) {
        Object object = this.localVariables[index];
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        return (Integer)object;
    }

    public void setInt(int index, int value) {
        this.localVariables[index] = value;
    }

    public long getLong(int index) {
        return (Long)this.localVariables[index];
    }

    public void setLong(int index, long value) {
        this.localVariables[index] = value;
    }

    public float getFloat(int index) {
        return ((Float)this.localVariables[index]).floatValue();
    }

    public void setFloat(int index, float value) {
        this.localVariables[index] = Float.valueOf(value);
    }

    public double getDouble(int index) {
        return (Double)this.localVariables[index];
    }

    public void setDouble(int index, double value) {
        this.localVariables[index] = value;
    }

    public ObjectRef getRef(int index) {
        return (ObjectRef)this.localVariables[index];
    }

    public void setRef(int index, ObjectRef value) {
        this.localVariables[index] = value;
    }
}

