/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm;

import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.code.VariableType;
import java.util.Stack;

public class OperandStack
extends Stack {
    private final int maxStack;

    public OperandStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public Object push(Object value) {
        return super.push(value);
    }

    public Object push(Object value, VariableType variableType) {
        if (variableType.isPrimitive()) {
            switch (variableType.getType()) {
                case "int": {
                    value = this.pushInt((Integer)value);
                    break;
                }
                case "long": {
                    value = this.pushLong((Long)value);
                    break;
                }
                case "float": {
                    value = Float.valueOf(this.pushFloat(((Float)value).floatValue()));
                    break;
                }
                case "double": {
                    value = this.pushDouble((Double)value);
                    break;
                }
                case "boolean": {
                    value = this.pushBoolean((Boolean)value);
                    break;
                }
                case "byte": {
                    value = this.pushByte((Byte)value);
                    break;
                }
                case "char": {
                    value = this.pushChar(((Character)value).charValue());
                    break;
                }
                case "short": {
                    value = this.pushShort((Short)value);
                    break;
                }
                default: {
                    value = this.push(value);
                    break;
                }
            }
        } else {
            value = this.push(value);
        }
        return value;
    }

    public synchronized Object pop() {
        return super.pop();
    }

    public int pushInt(int value) {
        this.push((Object)value);
        return value;
    }

    public int popInt() {
        return (Integer)this.pop();
    }

    public long pushLong(long value) {
        this.push((Object)value);
        this.push((Object)null);
        return value;
    }

    public long popLong() {
        this.pop();
        return (Long)this.pop();
    }

    public float pushFloat(float value) {
        this.push(Float.valueOf(value));
        return value;
    }

    public float popFloat() {
        return ((Float)this.pop()).floatValue();
    }

    public double pushDouble(double value) {
        this.push((Object)value);
        this.push((Object)null);
        return value;
    }

    public double popDouble() {
        this.pop();
        return (Double)this.pop();
    }

    public int pushBoolean(boolean value) {
        return this.pushInt(value ? 1 : 0);
    }

    public boolean popBoolean() {
        Object pop = this.pop();
        if (pop instanceof Integer) {
            return (Integer)pop == 1;
        }
        return (Boolean)pop;
    }

    public int pushByte(byte value) {
        return this.pushInt(value);
    }

    public byte popByte() {
        return (byte)this.popInt();
    }

    public int pushChar(char value) {
        return this.pushInt(value);
    }

    public char popChar() {
        return (char)this.popInt();
    }

    public int pushShort(short value) {
        return this.pushInt(value);
    }

    public short popShort() {
        return (short)this.popInt();
    }

    public ObjectRef pushRef(ObjectRef ref) {
        this.push(ref);
        return ref;
    }

    public ObjectRef popRef() {
        return (ObjectRef)this.pop();
    }
}

